/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.flappybird.decor;

import com.arizotaz.lotus.Text;
import com.arizotaz.lotus.ui.elements.Button;
import com.arizotaz.lotus.utils.Tools;

public class FlappyBirdButton
extends Button {
    float multiplier = 0.0f;

    public FlappyBirdButton() {
        this.font = "pixels";
    }

    @Override
    public void Interact() {
        super.Interact();
        if (this.clicked) {
            this.window.AudioManager().PlaySound("click", 1.0f, 1.0f);
        }
    }

    @Override
    public void Render() {
        float padding = this.window.RenderScale() * (this.height / 6.0f);
        this.window.RenderObjects().SetColor(255.0f);
        this.window.RenderObjects().DrawImage("pipe_button", this.x, this.y, this.width + this.multiplier * (this.width / 10.0f), this.height, 0.0f, true);
        this.multiplier = this.IsHovering() ? (this.multiplier += this.window.Time().DeltaTime() / 100.0f) : (this.multiplier -= this.window.Time().DeltaTime() / 100.0f);
        this.multiplier = Tools.ClampVar(this.multiplier, 0.0f, 1.0f);
        if (this.multiplier > 0.0f) {
            this.ForceScreenUpdate();
        }
        Text text = new Text(this.text);
        text.SetFont("pixels");
        text.FontSize(this.height - this.height / 6.0f - padding);
        text.Align(1, 1);
        text.SetFont(this.font);
        text.Color(255);
        text.Render(this.x, this.y);
    }
}

