/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.flappybird.game;

import com.arizotaz.flappybird.game.Game;
import com.arizotaz.flappybird.game.MainProcess;
import com.arizotaz.gameacc.BoxCollider2D;
import com.arizotaz.gameacc.KeyManager;
import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.struc.Vector2;
import com.arizotaz.lotus.utils.Tools;
import com.arizotaz.lotus.window.Window;

public class Bird {
    private MainProcess process;
    private Window window;
    private KeyManager kbi;
    private boolean keyDown = false;
    private Game game;
    private float birdSize = 0.0f;
    private float x = 0.0f;
    private float y = 0.0f;
    private float forceX = 0.0f;
    private float forceY = 0.0f;
    private float gravity = 38.0f;
    private BoxCollider2D collider;
    private boolean freed = false;

    public Bird(MainProcess process) {
        this.process = process;
        this.window = Lotus.singleton.WindowManager().GetCurrentWindow();
        this.game = process.Game();
        this.kbi = process.KeyManager();
        this.x = 0.0f;
        this.y = 7.0f;
        this.collider = new BoxCollider2D(this.x, this.y, this.birdSize, this.birdSize);
    }

    public void Tick() {
        this.birdSize = 1.0f;
        this.collider.SetSize(this.birdSize, this.birdSize * 0.8f);
        float deltaTime = this.window.Time().DeltaTime() / 1000.0f;
        this.forceY -= this.gravity * deltaTime;
        if (this.kbi.KeyDown("bird.jump")) {
            this.freed = true;
            if (!this.keyDown) {
                this.Jump();
            }
            this.keyDown = true;
        } else {
            this.keyDown = false;
        }
        if (!this.Freed()) {
            this.forceX = 0.0f;
            this.forceY = 0.0f;
        }
        this.x += this.forceX * deltaTime;
        this.y += this.forceY * deltaTime;
        this.y = Tools.ClampVar(this.y, 0.0f, 14.0f);
        if (this.y <= 0.0f) {
            this.forceY = 0.0f;
            this.game.Lose();
        }
        if (this.y >= 14.0f) {
            this.forceY = 0.0f;
        }
        this.collider.SetPosition(this.x, this.y);
    }

    public void Render() {
        this.window.RenderObjects().SetColor(255.0f);
        this.window.RenderObjects().DrawImage("bird", this.collider.x() * this.game.RenderScale(), this.collider.y() * this.game.RenderScale(), this.collider.w() * this.game.RenderScale(), this.collider.h() * this.game.RenderScale(), this.Rotation(), true);
    }

    private float Rotation() {
        float rotation = 0.0f;
        double angle = Math.atan2(this.y - (this.y + this.forceY), this.x - (this.x + this.birdSize * 50.0f));
        rotation = (float)Math.toDegrees(angle) + 180.0f;
        return rotation;
    }

    private void Jump() {
        this.forceY += 10.0f;
        this.window.AudioManager().PlaySound("flap", 1.0f, 1.0f);
    }

    public BoxCollider2D Collider() {
        return this.collider;
    }

    public Vector2 Position() {
        return new Vector2(this.x, this.y);
    }

    public boolean Freed() {
        return this.freed;
    }
}

