/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.flappybird.game;

import com.arizotaz.flappybird.game.Bird;
import com.arizotaz.flappybird.game.MainProcess;
import com.arizotaz.flappybird.game.Pipe;
import com.arizotaz.lotus.Text;
import com.arizotaz.lotus.UserSettings;
import com.arizotaz.lotus.utils.Tools;
import com.arizotaz.lotus.window.Window;
import java.util.ArrayList;

public class Game {
    private Window window;
    private Bird bird;
    private MainProcess process;
    private float renderScaling = 0.0f;
    private float parallax = 0.0f;
    private float xDistance = 1.0f;
    private ArrayList<Pipe> pipes = new ArrayList();
    private int pipeX = 10;
    private float gameSpeed = 1.0f;
    private int points = 0;

    public Game(Window window, MainProcess flappyBird) {
        this.window = window;
        this.process = flappyBird;
        this.Reset();
    }

    public void Reset() {
        this.bird = new Bird(this.process);
        this.renderScaling = 0.0f;
        this.parallax = 0.0f;
        this.xDistance = 0.0f;
        this.pipes = new ArrayList();
        this.pipeX = 10;
        this.gameSpeed = 0.5f;
        this.points = 0;
    }

    public void Tick() {
        if (this.bird.Freed()) {
            this.parallax += this.gameSpeed * (this.window.Time().DeltaTime() / 1000.0f);
            this.xDistance += this.gameSpeed * 2.0f * (this.window.Time().DeltaTime() / 1000.0f);
            this.gameSpeed += 0.1f * (this.window.Time().DeltaTime() / 1000.0f);
        }
        this.bird.Tick();
        for (int i = 0; i < this.pipes.size(); ++i) {
            Pipe pipe = this.pipes.get(i);
            if (pipe.HasPast()) {
                this.pipes.remove(i);
                --i;
                continue;
            }
            pipe.Tick();
        }
        while (this.pipes.size() < 10) {
            float y = Tools.ClampVar((float)(Math.random() * 7.0 + 3.0), 3.0f, 10.0f);
            this.pipes.add(new Pipe(this.process, this.pipeX, y, (float)(Math.random() * 3.0 + 3.0)));
            this.pipeX += 8;
        }
    }

    public void Render() {
        this.window.RenderObjects().SetColor(255.0f);
        int bgsize = 512;
        if (this.window.TextureEngine().GetTexture("backgrouund") != null) {
            bgsize = this.window.TextureEngine().GetTexture("backgrouund").Width();
        }
        this.window.RenderObjects().DrawImageFromSheet("background", 0.0f, 0.0f, this.window.CanvasWidth(), this.window.CanvasHeight(), this.parallax, 0.0f, 1.0f, bgsize, 0.0f);
        this.renderScaling = this.window.CanvasHeight() / 15.0f;
        this.window.Translate().Move(-this.window.CanvasWidth() / 2.0f + this.renderScaling, -this.window.CanvasHeight() / 2.0f + this.renderScaling / 2.0f);
        for (int i = 0; i < this.pipes.size(); ++i) {
            this.pipes.get(i).Render();
        }
        this.bird.Render();
        this.window.Translate().Set(0.0, 0.0);
        if (!this.bird.Freed()) {
            Text text = new Text("Jump to Start");
            text.SetFont("pixels");
            text.Align(0, 2);
            text.Color(255);
            text.FontSize(this.RenderScale() / 2.0f);
            text.Render(-this.window.CanvasWidth() / 2.0f + this.RenderScale() / 2.0f, this.RenderScale());
        }
        Text text = new Text("Points: " + this.points);
        text.SetFont("pixels");
        text.Align(0, 0);
        text.Color(255);
        text.FontSize(this.RenderScale() / 3.0f);
        text.Render(-this.window.CanvasWidth() / 2.0f, this.window.CanvasHeight() / 2.0f);
    }

    public float RenderScale() {
        return this.renderScaling;
    }

    public float xDistance() {
        return this.xDistance;
    }

    public Bird Bird() {
        return this.bird;
    }

    public void AddPoint() {
        ++this.points;
        this.window.AudioManager().PlaySound("point", 1.0f, 1.0f);
    }

    public void Lose() {
        if (!UserSettings.Exists("highscore")) {
            UserSettings.SetInt("highscore", 0);
        }
        int highScore = UserSettings.GetInt("highscore");
        highScore = Math.round(Tools.SetSmallest(highScore, this.points));
        UserSettings.SetInt("highscore", highScore);
        this.process.MenuManager().GoTo(15L);
        this.window.AudioManager().PlaySound("dead", 1.0f, 1.0f);
    }

    public int Points() {
        return this.points;
    }
}

