/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.flappybird.game;

import com.arizotaz.flappybird.game.Game;
import com.arizotaz.flappybird.menus.GameRender;
import com.arizotaz.flappybird.menus.InfoScreen;
import com.arizotaz.flappybird.menus.LoseMenu;
import com.arizotaz.flappybird.menus.MainMenu;
import com.arizotaz.gameacc.KeyManager;
import com.arizotaz.lotus.Font;
import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.UserSettings;
import com.arizotaz.lotus.texture.TextureEngine;
import com.arizotaz.lotus.ui.MenuManager;
import com.arizotaz.lotus.ui.elements.Element;
import com.arizotaz.lotus.ui.elements.ElementRenderer;
import com.arizotaz.lotus.window.Window;
import java.io.File;

public class MainProcess {
    private Window window;
    private Game game;
    private KeyManager keyManager;
    private ElementRenderer elm;
    private MenuManager ui;
    public static String mainFont = "default";

    public MainProcess(Window window) {
        this.window = window;
        Element.CreateWindowParms();
        TextureEngine.AddToGlobalList("background", "com/arizotaz/flappybird/assets/background.png");
        TextureEngine.AddToGlobalList("bird", "com/arizotaz/flappybird/assets/bird.png");
        TextureEngine.AddToGlobalList("pipe", "com/arizotaz/flappybird/assets/pipe_up.png");
        TextureEngine.AddToGlobalList("pipe_button", "com/arizotaz/flappybird/assets/pipe_button.png");
        window.AudioManager().AddAudioFile("flap", "com/arizotaz/flappybird/assets/flap.ogg", false);
        window.AudioManager().AddAudioFile("point", "com/arizotaz/flappybird/assets/point.ogg", false);
        window.AudioManager().AddAudioFile("dead", "com/arizotaz/flappybird/assets/death.ogg", false);
        window.AudioManager().AddAudioFile("click", "com/arizotaz/flappybird/assets/click.ogg", false);
        this.keyManager = new KeyManager(window);
        File file = new File(Lotus.singleton.FileLocations().AppStorage().getAbsolutePath() + "/keys");
        if (file.exists()) {
            this.keyManager.LoadFromFile(file);
        } else {
            this.keyManager.RegisterKey("bird.jump", 32);
            this.keyManager.RegisterKey("bird.jump", 87);
            this.keyManager.RegisterKey("bird.jump", 265);
            this.keyManager.SaveToFile(file);
        }
        this.elm = new ElementRenderer();
        this.ui = new MenuManager(window);
        this.ui.AddMenu(0L, new MainMenu(this));
        this.ui.AddMenu(10L, new GameRender(this));
        this.ui.AddMenu(15L, new LoseMenu(this));
        this.ui.AddMenu(20L, new InfoScreen(this));
        Font pixels = new Font("pixels");
        pixels.ImportLocal("com/arizotaz/lotus/resources/fonts/pixels.json");
        mainFont = pixels.Name();
        this.game = new Game(window, this);
    }

    public void Update() {
        if (this.window.KeyboardInput().IsPressed(300)) {
            this.window.SetFullScreen(!this.window.InBorderLess());
            UserSettings.SetBoolean("window.fullscreen", this.window.NotWindowed());
        }
        this.elm.Update();
        this.ui.Update();
        this.elm.Interact();
    }

    public void Render() {
        this.ui.Render();
        this.elm.Render();
    }

    public void Events() {
        this.ui.Events();
    }

    public void Exit() {
    }

    public KeyManager KeyManager() {
        return this.keyManager;
    }

    public Game Game() {
        return this.game;
    }

    public ElementRenderer ElementRenderer() {
        return this.elm;
    }

    public MenuManager MenuManager() {
        return this.ui;
    }
}

