/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.flappybird.menus;

import com.arizotaz.flappybird.game.MainProcess;
import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.Text;
import com.arizotaz.lotus.texture.Texture;
import com.arizotaz.lotus.texture.TextureEngine;
import com.arizotaz.lotus.ui.Menu;
import com.arizotaz.lotus.ui.elements.Button;
import com.arizotaz.lotus.ui.elements.Element;
import com.arizotaz.lotus.ui.elements.ElementRenderer;
import com.arizotaz.lotus.ui.elements.Image;
import com.arizotaz.lotus.ui.elements.Panel;
import com.arizotaz.lotus.ui.elements.TextDisplay;
import com.arizotaz.lotus.utils.Fs;
import com.arizotaz.lotus.utils.Tools;
import com.arizotaz.lotus.utils.Web;
import com.arizotaz.lotus.window.Window;

public class InfoScreen
extends Menu {
    private Window window;
    private MainProcess process;
    private ElementRenderer elm;
    private float pageScale = 0.0f;
    private Button back;
    private Button arizotaz;
    private Button github;
    private int numOfLinks = 2;

    public InfoScreen(MainProcess process) {
        this.process = process;
    }

    @Override
    public void Open() {
        this.window = Lotus.singleton.WindowManager().GetCurrentWindow();
        this.elm = this.process.ElementRenderer();
        this.CreateElements();
        this.CreatePage();
    }

    private void CreateElements() {
        TextureEngine.AddURLToGlobalList("dev_avatar", "https://avatars.githubusercontent.com/u/29374798?v=4", false);
        TextureEngine.AddToGlobalList("dev_boarder", "com/arizotaz/flappybird/assets/square.png");
        this.arizotaz = Element.Button();
        this.github = Element.Button();
        this.back = Element.Button();
    }

    private void CreatePage() {
        float pfp_w;
        float yIndex = this.window.CanvasHeight() / 2.0f;
        float pageWidth = Tools.ClampVar(this.window.CanvasWidth() - 40.0f * this.window.RenderScale(), 100.0f, 1200.0f * this.window.RenderScale());
        yIndex -= 20.0f * this.window.RenderScale();
        this.pageScale = this.window.CanvasWidth() / 30.0f;
        this.elm.ClearCycle();
        this.elm.AddElement(new Panel(0.0f, 0.0f, this.window.CanvasWidth(), this.window.CanvasHeight(), 0.0f, 0, 0, 0, 150));
        Text namePlate = new Text("Developed by Colton Staiduhar");
        namePlate.Align(0, 0);
        namePlate.SetFont(this.window.GetTheme().Font());
        namePlate.Color(255);
        namePlate.MaxWidth(800.0f * this.window.RenderScale());
        Text tribute = new Text("Based on the game from Dong Nguyen");
        tribute.Align(0, 0);
        tribute.SetFont(this.window.GetTheme().Font());
        tribute.Color(255);
        float pfp_h = pfp_w = 200.0f * this.window.RenderScale();
        yIndex -= pfp_h / 2.0f;
        float header_padding = 10.0f * this.window.RenderScale();
        namePlate.FontSize(pfp_h / 6.0f);
        tribute.FontSize(namePlate.GetFontSize() / 1.5f);
        namePlate.MaxWidth(pageWidth - pfp_h - header_padding);
        tribute.MaxWidth(pageWidth - pfp_h - header_padding);
        namePlate.Calculate();
        tribute.Calculate();
        float titleW = namePlate.Width() + pfp_w + header_padding;
        float header_text_height = namePlate.Height() + tribute.Height();
        float pfp_x = -titleW / 2.0f + pfp_w / 2.0f;
        float pfp_y = yIndex;
        this.elm.AddElement(new Image("dev_boarder", pfp_x, pfp_y, pfp_w, pfp_h, 0.0f, 255));
        this.elm.AddElement(new Image("dev_avatar", pfp_x, pfp_y, pfp_w * 0.9375f, pfp_h * 0.9375f, 0.0f, 255));
        this.elm.AddElement(new TextDisplay(namePlate, -titleW / 2.0f + pfp_w + header_padding, pfp_y + header_text_height / 2.0f));
        this.elm.AddElement(new TextDisplay(tribute, -titleW / 2.0f + pfp_w + header_padding, pfp_y + header_text_height / 2.0f - tribute.Height() - 10.0f * this.window.RenderScale()));
        yIndex -= pfp_h / 2.0f;
        pageWidth = titleW;
        float buttonWidth = pageWidth / (float)this.numOfLinks;
        float buttonHeight = 25.0f * this.window.RenderScale();
        this.arizotaz.Set("Arizotaz", -pageWidth / 2.0f + buttonWidth / 2.0f, yIndex -= buttonHeight / 2.0f, buttonWidth, buttonHeight);
        this.github.Set("Src Code", -pageWidth / 2.0f + buttonWidth / 2.0f + buttonWidth, yIndex, buttonWidth, buttonHeight);
        this.elm.AddElement(this.arizotaz);
        this.elm.AddElement(this.github);
        yIndex -= buttonHeight / 2.0f + 10.0f * this.window.RenderScale();
        Text vText = new Text("App Version: " + Lotus.singleton.AppInfo().Version().toString() + " using Lotus " + Lotus.singleton.EngineInfo().Version().toString());
        vText.FontSize(16.0f * this.window.RenderScale());
        vText.Align(0, 0);
        vText.SetFont(this.window.GetTheme().Font());
        vText.Color(255);
        this.elm.AddElement(new TextDisplay(vText, -pageWidth / 2.0f, yIndex));
        vText.Calculate();
        yIndex -= vText.Height() + 30.0f * this.window.RenderScale();
        Text about = new Text(Fs.GetResourceFileAsString("com/arizotaz/flappybird/assets/about.txt"));
        about.FontSize(18.0f * this.window.RenderScale());
        about.Align(0, 0);
        about.SetFont(this.window.GetTheme().Font());
        about.Color(255);
        about.MaxWidth(pageWidth);
        this.elm.AddElement(new TextDisplay(about, -pageWidth / 2.0f, yIndex));
        this.back.Set("Back", 0.0f, -this.window.CanvasHeight() / 2.0f + 25.0f * this.window.RenderScale() / 2.0f, Tools.ClampVar(Tools.SetLargest(pageWidth, this.window.CanvasWidth()), 50.0f * this.window.RenderScale(), 500.0f * this.window.RenderScale()), 25.0f * this.window.RenderScale());
        this.elm.AddElement(this.back);
    }

    @Override
    public void Update() {
        if (this.window.SizeChanged()) {
            this.CreatePage();
        }
    }

    @Override
    public void Render() {
        Texture tex = this.window.TextureEngine().GetTexture("background");
        if (tex != null && tex.GLCreated()) {
            float ratio = (float)tex.Width() / (float)tex.Height();
            this.window.RenderObjects().SetColor(255.0f);
            this.window.RenderObjects().DrawImage("background", 0.0f, 0.0f, this.window.CanvasHeight() * ratio, this.window.CanvasHeight(), 0.0f);
        } else {
            this.window.RenderObjects().DrawImage("background", 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
        }
    }

    @Override
    public void Events() {
        if (this.back.Clicked()) {
            this.menuManager.GoBack();
        }
        if (this.arizotaz.Clicked()) {
            Web.OpenBrowser("https://arizotaz.com");
        }
        if (this.github.Clicked()) {
            Web.OpenBrowser("https://github.com/arizotaz/FlappyBird");
        }
    }

    @Override
    public void Leave() {
    }
}

