/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus;

import com.arizotaz.lotus.ApplicationInfo;
import com.arizotaz.lotus.FileDirs;
import com.arizotaz.lotus.Font;
import com.arizotaz.lotus.LotusDebug;
import com.arizotaz.lotus.LotusDemo;
import com.arizotaz.lotus.OSPlatform;
import com.arizotaz.lotus.api.ModuleInfo;
import com.arizotaz.lotus.managers.ProcessManager;
import com.arizotaz.lotus.managers.ThreadManager;
import com.arizotaz.lotus.managers.WindowManager;
import com.arizotaz.lotus.resources.BasicTextures;
import com.arizotaz.lotus.struc.CLIArgs;
import com.arizotaz.lotus.struc.Contact;
import com.arizotaz.lotus.struc.Event;
import com.arizotaz.lotus.struc.Process;
import com.arizotaz.lotus.struc.Version;
import com.arizotaz.lotus.texture.TextureEngine;
import com.arizotaz.lotus.utils.Fs;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import org.lwjgl.glfw.GLFW;

public class Lotus {
    public static boolean opened = false;
    public static Lotus singleton = null;
    private ApplicationInfo appinfo;
    private ApplicationInfo engineInfo;
    private boolean inited = false;
    private boolean run = true;
    private int exitCode = 0;
    private int singleInstanceWrite = 0;
    private final long instanceTime = 20000L;
    private boolean singleInstance = false;
    private ThreadManager threadManager;
    private ProcessManager processManager;
    private WindowManager windowManager;
    private FileDirs locations;
    private OSPlatform osplatform;
    private CLIArgs arguments;
    private Event onOpenSingleInstance = null;
    private boolean macOSStartOneShot = false;
    private String mainClass;

    public static void Reset() {
        if (opened) {
            throw new RuntimeException("Reset Not Available when Lotus Session is Open");
        }
        singleton = null;
        ProcessManager.inited = false;
        ThreadManager.inited = false;
        WindowManager.inited = false;
    }

    public Lotus(String[] args, String mainClass) {
        this.mainClass = mainClass;
        this.arguments = new CLIArgs(args);
        if (this.arguments.Exists("-ldebug")) {
            if (this.arguments.Get("-ldebug").equals("false")) {
                LotusDebug.ShowEngineConsole(false);
            } else {
                LotusDebug.ShowEngineConsole(true);
            }
        }
        singleton = this;
        opened = true;
        LotusDebug.Log("[LOTUS] New Instance Created");
        ArrayList<Contact> authors = new ArrayList<Contact>();
        Contact contact = new Contact("Colton Staiduhar", "arizotaz", "colton@staiduhar.com", "", 1110741120000L);
        contact.SetContactImageUrl("https://avatars.githubusercontent.com/u/29374798");
        contact.AddLink("Github", "https://github.com/arizotaz");
        contact.AddLink("Arizotaz", "https://arizotaz.com");
        contact.AddLink("Email", "mailto:" + contact.Email());
        authors.add(contact);
        this.engineInfo = new ApplicationInfo("lotus", new Version("0.5.2"), "Lotus Application Engine", authors);
        if (this.arguments.Exists("-lotusversion") || this.arguments.Exists("-lversion")) {
            System.out.print("version=" + this.engineInfo.Version().toString());
            singleton.Exit(0);
        }
        LotusDebug.Log("[LOTUS] Loaded Engine Info.  " + String.valueOf(this.engineInfo.Version()));
        if (this.arguments.Exists("-lotus") || this.arguments.Exists("-lotushelp") || this.arguments.Exists("-lhelp")) {
            LotusDebug.PrintHelp();
            singleton.Exit(0);
        }
        if (this.arguments.Exists("-lstartdelay")) {
            long delay = 3000L;
            try {
                delay = Long.parseLong(this.arguments.Get("-lstartdelay")) * 1000L;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                System.out.println("[LOTUS] Engine Startup will be delayed for " + delay / 1000L + " seconds.");
                Thread.sleep(delay);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void Config(ApplicationInfo info) {
        this.appinfo = info;
        if (this.arguments.Exists("-version")) {
            System.out.print("version=" + this.appinfo.Version().toString());
            singleton.Exit(0);
        }
    }

    public void Setup() {
        LotusDebug.Log("[LOTUS.SETUP] Getting Enviorment Variables");
        this.osplatform = new OSPlatform();
        this.locations = new FileDirs();
        LotusDebug.Log("[LOTUS.SETUP] DONE");
    }

    public void Init() {
        if (this.SingleInstance()) {
            if (this.InstanceOpened()) {
                Object cmd = "";
                String[] rawArgs = this.arguments.Raw();
                int i = 0;
                while (i < rawArgs.length) {
                    cmd = (String)cmd + rawArgs[i] + "\n";
                    ++i;
                }
                this.WriteInstanceOpenCMD((String)cmd);
                System.exit(5);
            }
            this.WriteInstanceFile();
            this.DeleteNewInstanceCMD();
        }
        LotusDebug.Log("[LOTUS.INIT] Creating ThreadManager");
        this.threadManager = new ThreadManager(this);
        LotusDebug.Log("[LOTUS.INIT] Creating ProcessManager");
        this.processManager = new ProcessManager(this);
        LotusDebug.Log("[LOTUS.INIT] Creating WindowManager");
        this.windowManager = new WindowManager(this);
        LotusDebug.Log("[LOTUS.INIT] Loading Basic Textures");
        BasicTextures.Load();
        LotusDebug.Log("[LOTUS.INIT] Loading Font");
        Font.SetDefault();
        this.inited = true;
        LotusDebug.Log("[LOTUS.INIT] DONE");
        if (this.arguments.Exists("-ldemo")) {
            this.AddProcess(new LotusDemo());
            this.Start();
            this.Exit(0);
        }
    }

    public void Start() {
        if (!this.inited) {
            LotusDebug.Error("[LOTUS.START] Lotus must be initialized");
            singleton.Exit(10940001);
        }
        LotusDebug.Log("[LOTUS.START] Lotus has started successfully");
        while (this.Running()) {
            this.windowManager.Update();
            this.processManager.Update();
            TextureEngine.GlobalUpdate();
            this.threadManager.Update();
            if (this.Platform().IsMac() && this.ProcessManager().MainMacOSXProcess() != null) {
                Process p = this.ProcessManager().MainMacOSXProcess();
                if (!this.macOSStartOneShot) {
                    this.macOSStartOneShot = !this.macOSStartOneShot;
                    p.Start();
                }
                try {
                    p.Update();
                }
                catch (Exception e) {
                    p.Exception(e);
                }
                catch (Error e) {
                    p.IllegalError(e);
                }
            } else {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.singleInstance) {
                this.singleInstanceWrite += 1000;
                if ((long)this.singleInstanceWrite >= 20000L / 2L) {
                    this.WriteInstanceFile();
                }
                if (this.NewInstanceOpened()) {
                    if (this.onOpenSingleInstance != null) {
                        this.onOpenSingleInstance.OnEvent(Fs.ReadText(new File(this.FileLocations().TempDir().getAbsolutePath() + "/sys/oi")));
                    }
                    this.DeleteNewInstanceCMD();
                }
            }
            if ((this.ProcessManager().MainMacOSXProcess() == null || this.ProcessManager().MainMacOSXProcess().Running()) && this.processManager.AliveProcesses() > 0) continue;
            this.run = false;
        }
        if (this.Platform().IsMac() && this.ProcessManager().MainMacOSXProcess() != null) {
            this.ProcessManager().MainMacOSXProcess().Exit();
        }
        while (this.processManager.AliveProcesses() > 0) {
            try {
                this.processManager.Update();
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.CleanUp();
        LotusDebug.Log("[LOTUS.START] Lotus exited Successfully");
        if (this.exitCode > 0) {
            this.Exit(this.exitCode);
        }
    }

    public void Stop() {
        this.run = false;
    }

    private void CleanUp() {
        int t = 1;
        while (t > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            t = this.ThreadManager().HoldTillDead();
        }
        this.CloseInstanceFile();
        opened = false;
    }

    public ThreadManager ThreadManager() {
        return this.threadManager;
    }

    public ProcessManager ProcessManager() {
        return this.processManager;
    }

    public WindowManager WindowManager() {
        return this.windowManager;
    }

    public FileDirs FileLocations() {
        return this.locations;
    }

    public int AddProcess(Process process) {
        return this.processManager.AddProcess(process);
    }

    public boolean Running() {
        return this.run;
    }

    public OSPlatform Platform() {
        return this.osplatform;
    }

    public ApplicationInfo EngineInfo() {
        return this.engineInfo;
    }

    public ApplicationInfo AppInfo() {
        return this.appinfo;
    }

    public void SetExitCode(int code) {
        this.exitCode = code;
    }

    public void Exit(int code) {
        if (code > 0) {
            System.out.println("Application was forcibly closed");
            System.out.println("0x" + Integer.toHexString(code).toUpperCase());
        }
        System.exit(code);
    }

    public void ForceSingleInstance(boolean val) {
        this.singleInstance = val;
    }

    private boolean SingleInstance() {
        return this.singleInstance;
    }

    public boolean InstanceOpened() {
        new File(this.FileLocations().TempDir().getAbsolutePath() + "/sys/").mkdirs();
        boolean reval = false;
        try {
            if (new File(this.FileLocations().TempDir().getAbsolutePath() + "/sys/instance").exists()) {
                String dat = Fs.ReadText(new File(this.FileLocations().TempDir().getAbsolutePath() + "/sys/instance"));
                long time = Long.parseLong(dat);
                boolean timePassed = System.currentTimeMillis() > time + 20000L;
                reval = !timePassed;
            } else {
                reval = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return reval;
    }

    private void WriteInstanceFile() {
        Fs.WriteText(new File(this.FileLocations().TempDir().getAbsolutePath() + "/sys/instance"), String.valueOf(System.currentTimeMillis()));
    }

    private void WriteInstanceOpenCMD(String cmdinfo) {
        new File(this.FileLocations().TempDir().getAbsolutePath() + "/sys/oi").mkdirs();
        Fs.WriteText(new File(this.FileLocations().TempDir().getAbsolutePath() + "/sys/oi"), cmdinfo);
    }

    private boolean NewInstanceOpened() {
        return new File(this.FileLocations().TempDir().getAbsolutePath() + "/sys/oi").exists();
    }

    private boolean DeleteNewInstanceCMD() {
        return new File(this.FileLocations().TempDir().getAbsolutePath() + "/sys/oi").delete();
    }

    private boolean CloseInstanceFile() {
        return new File(this.FileLocations().TempDir().getAbsolutePath() + "/sys/instance").delete();
    }

    public void OnNewInstance(Event event) {
        this.onOpenSingleInstance = event;
    }

    public ModuleInfo[] Modules() {
        ArrayList<ModuleInfo> list = new ArrayList<ModuleInfo>();
        list.add(new ModuleInfo("com.arizotaz.lotus.engine", "Lotus Engine", this.EngineInfo().Version()));
        ModuleInfo[] data = new ModuleInfo[list.size()];
        int i = 0;
        while (i < data.length) {
            data[i] = (ModuleInfo)list.get(i);
            ++i;
        }
        return data;
    }

    public boolean ContainsModule(String id) {
        boolean val = false;
        ModuleInfo[] data = this.Modules();
        int i = 0;
        while (i < data.length) {
            ModuleInfo m = data[i];
            if (m.ID().toLowerCase().equals(id.toLowerCase())) {
                val = true;
            }
            ++i;
        }
        return val;
    }

    public String ModulesText() {
        ModuleInfo[] data = this.Modules();
        Object text = "";
        int i = 0;
        while (i < data.length) {
            ModuleInfo m = data[i];
            text = (String)text + m.Name() + ": v" + String.valueOf(m.Version()) + ", ";
            ++i;
        }
        return text;
    }

    public String ModulesTextIDs() {
        ModuleInfo[] data = this.Modules();
        Object text = "";
        int i = 0;
        while (i < data.length) {
            ModuleInfo m = data[i];
            text = (String)text + m.ID() + ": v" + String.valueOf(m.Version()) + ", ";
            ++i;
        }
        return text;
    }

    public CLIArgs Arguments() {
        return this.arguments;
    }

    public static boolean NeedsRelaunchOnMacOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (!osName.contains("mac")) {
            return false;
        }
        if (System.getProperty("startOnFirstThreadRelaunched") != null) {
            return false;
        }
        try {
            GLFW.glfwInit();
            return false;
        }
        catch (IllegalStateException e) {
            return true;
        }
    }

    public static void RelaunchWithStartOnFirstThread() throws IOException {
        String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        File currentJar = new File(Lotus.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaBin);
        command.add("-XstartOnFirstThread");
        command.add("-DstartOnFirstThreadRelaunched=true");
        for (String arg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            if (arg.startsWith("-agentlib")) continue;
            command.add(arg);
        }
        if (currentJar.getName().endsWith(".jar")) {
            command.add("-jar");
            command.add(currentJar.getPath());
        } else {
            command.add("-cp");
            command.add(System.getProperty("java.class.path"));
            command.add(Lotus.singleton.mainClass);
        }
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.inheritIO();
        java.lang.Process process = builder.start();
        System.exit(0);
    }
}

