/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus;

import com.arizotaz.lotus.ApplicationInfo;
import com.arizotaz.lotus.Font;
import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.Text;
import com.arizotaz.lotus.managers.ThreadManager;
import com.arizotaz.lotus.struc.Process;
import com.arizotaz.lotus.struc.Version;
import com.arizotaz.lotus.texture.Texture;
import com.arizotaz.lotus.window.Window;
import java.util.ArrayList;

public class LotusDemo
extends Process {
    private Window window;
    private boolean closing = false;
    private boolean texturesLoading = false;
    private float px = 0.0f;
    private float py = 0.0f;
    private float bx = 0.0f;
    private float by = 0.0f;
    private float bfx = 3.0f;
    private float bfy = 3.0f;
    private float loading = 255.0f;
    private BoxCollider2D ball = new BoxCollider2D(0.0f, 0.0f, 0.0f, 0.0f);
    private BoxCollider2D player = new BoxCollider2D(0.0f, 0.0f, 0.0f, 0.0f);
    private ArrayList<Block> blocks = new ArrayList();

    @Override
    public void Start() {
        String wid = Lotus.singleton.WindowManager().CreateWindow("Lotus Engine Basic Demo", 960, 480, this.ID());
        this.window = Lotus.singleton.WindowManager().GetWindow(wid);
        this.window.Init(true);
        this.window.Process();
        try {
            this.window.SetIcon("com/arizotaz/lotus/resources/icon.window.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.window.Process();
        this.window.Minimize();
        this.window.Process();
        this.window.Show();
        this.window.Process();
        this.window.RestoreWindow();
        Font.SetDefault();
        this.window.RenderObjects().DrawImage("engine.author.arizotaz", 0.0f, 0.0f, 100.0f, 100.0f, 0.0f);
        ThreadManager tm = Lotus.singleton.ThreadManager();
        tm.Start(tm.Create(new Thread(new Runnable(){

            @Override
            public void run() {
                while (LotusDemo.this.Running()) {
                    long startTime = System.currentTimeMillis();
                    LotusDemo.this.UpdateLoop();
                    long runTime = System.currentTimeMillis() - startTime;
                    long timeToWait = 5L - runTime;
                    if (timeToWait < 0L) {
                        timeToWait = 0L;
                    }
                    try {
                        Thread.sleep(timeToWait);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        })));
        for (int i = 0; i < 40; ++i) {
            this.blocks.add(new Block(0.0f, 0.0f, 1.0f, 1.0f));
        }
        this.window.AudioManager().AddAudioFile("welcome", "/com/arizotaz/lotus/resources/audio/test.ogg", false);
        this.window.AudioManager().AddAudioFile("bounce", "/com/arizotaz/lotus/resources/audio/bounce.ogg", false);
    }

    @Override
    public void Update() {
        this.window.TextureEngine().Update();
        this.window.AudioManager().Update();
        this.window.Process();
        this.texturesLoading = this.window.TextureEngine().TexturesLoading();
        this.window.RenderObjects().SetColor(200.0f);
        this.window.RenderObjects().DrawRect(0.0f, 0.0f, this.window.CanvasWidth(), this.window.CanvasHeight(), 0.0f);
        if (this.closing) {
            this.window.RenderObjects().SetColor(100.0f);
            this.window.RenderObjects().DrawRect(0.0f, 0.0f, this.window.CanvasWidth(), this.window.CanvasHeight(), 0.0f);
            if (this.texturesLoading) {
                this.window.Render(true);
                return;
            }
            this.window.RenderObjects().SetColor(180.0f);
            this.window.RenderObjects().DrawRect(0.0f, 0.0f, this.window.CanvasWidth() - 10.0f * this.window.RenderScale(), this.window.CanvasHeight() - 10.0f * this.window.RenderScale(), 0.0f);
            Text t = new Text("Thank you for using the Lotus Engine!");
            t.Align(1, 1);
            t.FontSize(20.0f * this.window.RenderScale());
            t.Color(0);
            t.Render(0.0f, 0.0f);
            this.window.Render(true);
            return;
        }
        this.window.RenderObjects().SetColor(100.0f);
        this.window.RenderObjects().DrawRect(0.0f, 0.0f, this.window.CanvasWidth() - 10.0f, this.window.CanvasHeight() - 10.0f, 0.0f);
        this.window.RenderObjects().SetColor(255.0f, 255.0f, 0.0f);
        this.window.RenderObjects().DrawRect(0.0f, 0.0f, 100.0f, 100.0f, 0.0f);
        this.window.RenderObjects().SetColor(0.0f, 255.0f, 0.0f);
        this.window.RenderObjects().DrawRect(-25.0f, -25.0f, 50.0f, 50.0f, 0.0f);
        this.MainContent();
        this.window.Render(true);
        if (this.window.WantsToClose()) {
            ThreadManager tm = Lotus.singleton.ThreadManager();
            tm.Start(tm.Create(new Thread(new Runnable(){

                @Override
                public void run() {
                    LotusDemo.this.CloseWindow();
                }
            })));
            this.window.ShouldClose(false);
        }
    }

    @Override
    public void Exit() {
        this.window.CleanUp();
    }

    public static void main(String[] args) {
        Lotus l = new Lotus(args, LotusDemo.class.getName());
        l.Config(new ApplicationInfo("com.arizotaz.lotus", new Version(0, 0, 0), "Lotus Demo Program", null));
        l.Setup();
        l.Init();
        l.AddProcess(new LotusDemo());
        l.Start();
    }

    private void CloseWindow() {
        this.window.AudioManager().PlaySound("welcome", 1.0f, 1.0f);
        this.closing = true;
        while (this.texturesLoading) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.QuitProcess();
    }

    private void UpdateLoop() {
        if (this.loading > 0.0f) {
            return;
        }
        this.bx += this.bfx;
        this.by += this.bfy;
        if (this.bx < -this.window.CanvasWidth() / 2.0f && this.bfx < 0.0f) {
            this.bfx *= -1.0f;
            this.window.AudioManager().PlaySound("bounce", 1.0f, 1.0f);
        }
        if (this.bx > this.window.CanvasWidth() / 2.0f && this.bfx > 0.0f) {
            this.bfx *= -1.0f;
            this.window.AudioManager().PlaySound("bounce", 1.0f, 1.0f);
        }
        if (this.by > this.window.CanvasHeight() / 2.0f && this.bfy > 0.0f) {
            this.bfy *= -1.0f;
            this.window.AudioManager().PlaySound("bounce", 1.0f, 1.0f);
        }
        if (this.by < -this.window.CanvasHeight() / 2.0f && this.bfy < 0.0f) {
            this.bfy *= -1.0f;
            this.window.AudioManager().PlaySound("bounce", 1.0f, 1.0f);
        }
        this.ball = new BoxCollider2D(this.bx, this.by, 10.0f * this.window.RenderScale(), 10.0f * this.window.RenderScale());
        this.player = new BoxCollider2D(this.px, this.py, 100.0f * this.window.RenderScale(), 10.0f * this.window.RenderScale());
        for (int i = 0; i < 0; ++i) {
            float bsw = this.window.CanvasWidth() / 10.0f;
            float bsh = 20.0f * this.window.RenderScale();
            float bw = bsw * 0.95f;
            float bh = 15.0f * this.window.RenderScale();
            float row = (float)Math.floor(i / 10);
            float column = (float)i - row * 10.0f;
            float x = -this.window.CanvasWidth() / 2.0f + bsw * column + bsw / 2.0f;
            float y = this.window.CanvasHeight() / 2.0f - bsh * row - bsh / 2.0f;
            Block block = this.blocks.get(i);
            if (block.Dead()) continue;
            block.Set(x, y, bw, bh);
            if (!block.IsColliding(this.ball)) continue;
            this.window.AudioManager().PlaySound("bounce", 1.0f, 1.0f);
            if (this.bfy > 0.0f) {
                this.bfy *= -1.0f;
            }
            block.Die();
        }
        if (this.player.IsColliding(this.ball)) {
            this.window.AudioManager().PlaySound("bounce", 1.0f, 1.0f);
            this.bfy *= -1.0f;
        }
    }

    private void MainContent() {
        this.px = (float)this.window.Mouse().x();
        this.py = -this.window.CanvasHeight() / 2.0f + 40.0f * this.window.RenderScale();
        this.window.RenderObjects().SetColor(0.0f);
        this.window.RenderObjects().DrawRect(0.0f, 0.0f, this.window.CanvasWidth(), this.window.CanvasHeight(), 0.0f);
        this.window.RenderObjects().SetColor(100.0f);
        this.window.RenderObjects().DrawRect(0.0f, 0.0f, this.window.CanvasWidth() - 10.0f, this.window.CanvasHeight() - 10.0f, 0.0f);
        this.window.RenderObjects().SetColor(255.0f);
        this.window.RenderObjects().DrawRect(this.ball.x(), this.ball.y(), this.ball.w(), this.ball.h(), 0.0f);
        this.window.RenderObjects().DrawRect(this.player.x(), this.player.y(), this.player.w(), this.player.h(), 0.0f);
        for (int i = 0; i < this.blocks.size(); ++i) {
            this.blocks.get(i).Render();
        }
        Text t = new Text("FPS: " + this.window.FPS_AVERAGE() + " at " + this.window.CanvasWidth() + "x" + this.window.CanvasHeight());
        t.FontSize(16.0f * this.window.RenderScale());
        t.Align(0, 0);
        t.Color(255);
        t.Render(-this.window.CanvasWidth() / 2.0f, this.window.CanvasHeight() / 2.0f);
        if (this.loading > 0.0f) {
            if (!this.texturesLoading) {
                this.loading -= this.window.Time().DeltaTime() / 1.0f;
            }
            this.window.RenderObjects().SetColor(this.loading, (float)(Math.sqrt(this.loading * 3.0f) * 16.0));
            this.window.RenderObjects().DrawRect(0.0f, 0.0f, this.window.CanvasWidth(), this.window.CanvasHeight(), 0.0f);
            this.window.RenderObjects().SetColor(255.0f, (float)(Math.sqrt(this.loading * 3.0f) * 16.0));
            Texture tex = this.window.TextureEngine().GetTexture("engine.author.arizotaz");
            if (tex != null) {
                float ih = 200.0f * this.window.RenderScale();
                float iw = (float)tex.Width() / (float)tex.Height() * ih;
                this.window.RenderObjects().DrawImage("engine.author.arizotaz", 0.0f, 0.0f, iw, ih, 0.0f, false);
            }
        }
    }

    private class BoxCollider2D {
        private float x;
        private float y;
        private float width;
        private float height;

        public BoxCollider2D(float x, float y, float width, float height) {
            this.SetPosition(x, y);
            this.SetSize(width, height);
        }

        public void SetPosition(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public void SetSize(float width, float height) {
            this.width = width;
            this.height = height;
        }

        public float x() {
            return this.x;
        }

        public float y() {
            return this.y;
        }

        public float w() {
            return this.width;
        }

        public float h() {
            return this.height;
        }

        public boolean IsColliding(BoxCollider2D collider) {
            boolean val = this.x - this.width / 2.0f < collider.x + collider.width / 2.0f && this.x + this.width / 2.0f > collider.x - collider.width / 2.0f && this.y - this.height / 2.0f < collider.y + collider.height / 2.0f && this.y + this.height / 2.0f > collider.y - collider.height / 2.0f;
            return val;
        }
    }

    private class Block {
        private float x;
        private float y;
        private float w;
        private float h;
        private boolean dead;

        public Block(float x, float y, float w, float h) {
            this.Set(x, y, w, h);
        }

        public void Die() {
            this.dead = true;
        }

        public boolean Dead() {
            return this.dead;
        }

        public BoxCollider2D Collider() {
            return new BoxCollider2D(this.x, this.y, this.w, this.h);
        }

        public boolean IsColliding(BoxCollider2D collider) {
            return this.Collider().IsColliding(collider);
        }

        public void Set(float x, float y, float w, float h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        public void Render() {
            if (!this.dead) {
                LotusDemo.this.window.RenderObjects().DrawRect(this.x, this.y, this.w, this.h, 0.0f);
            }
        }
    }
}

