/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus;

import com.arizotaz.lotus.struc.Vector2;
import com.arizotaz.lotus.struc.Vector3;
import com.arizotaz.lotus.struc.Vector4;
import com.arizotaz.lotus.texture.Texture;
import com.arizotaz.lotus.texture.TextureEngine;
import com.arizotaz.lotus.window.Window;
import org.lwjgl.opengl.GL11;

public class RenderObjects {
    private Window window;
    private Vector4 color = new Vector4(-1.0, -1.0, -1.0, 255.0);
    private Texture texture;
    private String lastBind = "";
    private int work_itemsDrawn = 0;
    private int work_images = 0;
    private int work_textureBinds = 0;
    private int itemsDrawn = 0;
    private int imagesDraw = 0;
    private int textureBinds = 0;
    private boolean useTexture = false;
    private boolean canvasCulling = true;

    public void ClearMetrics() {
        this.itemsDrawn = this.work_itemsDrawn;
        this.imagesDraw = this.work_images;
        this.textureBinds = this.work_textureBinds;
        this.work_itemsDrawn = 0;
        this.work_images = 0;
        this.work_textureBinds = 0;
    }

    public void UseTexture(boolean t) {
        if (t) {
            GL11.glEnable(3553);
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
        } else {
            this.lastBind = "";
            GL11.glDisable(3553);
        }
        if (t != this.useTexture) {
            this.useTexture = t;
        }
    }

    private boolean GetTexture(String textureID) {
        boolean found = true;
        TextureEngine te = this.window.TextureEngine();
        Texture tex = te.GetTexture(textureID);
        if (tex == null) {
            if (TextureEngine.InGlobalList(textureID)) {
                te.LoadFromGlobalList(textureID);
                if (TextureEngine.ShowLoadingIndicator()) {
                    textureID = "engine.loading";
                    if (!this.lastBind.equals(textureID)) {
                        tex = te.GetTexture(textureID);
                    }
                    found = false;
                } else {
                    textureID = "air";
                    if (!this.lastBind.equals(textureID)) {
                        tex = te.GetTexture(textureID);
                    }
                    found = false;
                }
            } else {
                textureID = "engine.missing";
                if (!this.lastBind.equals(textureID)) {
                    tex = te.GetTexture(textureID);
                }
                found = false;
            }
        }
        this.texture = tex;
        return found;
    }

    private void BindTex() {
        if (!this.texture.ID().equals(this.lastBind)) {
            this.lastBind = this.texture.ID();
            this.texture.BindToGL();
            ++this.work_textureBinds;
        }
    }

    public RenderObjects(Window window) {
        this.window = window;
    }

    public void SetColor(float l) {
        this.SetColor(l, l, l);
    }

    public void SetColor(float l, float a) {
        this.SetColor(l, l, l, a);
    }

    public void SetColor(float r, float g, float b) {
        this.SetColor(r, g, b, 255.0f);
    }

    public void SetColor(float r, float g, float b, float a) {
        if (this.color.x() != (double)r || this.color.y() != (double)g || this.color.z() != (double)b || this.color.w() != (double)a) {
            this.color = new Vector4(r, g, b, a);
            float _r = r / 255.0f;
            float _g = g / 255.0f;
            float _b = b / 255.0f;
            float _a = a / 255.0f;
            GL11.glColor4d(_r, _g, _b, _a);
        }
    }

    public void SetColor(Vector2 color) {
        this.SetColor(color.IntX(), color.IntY());
    }

    public void SetColor(Vector3 color) {
        this.SetColor(color.IntX(), color.IntY(), color.IntZ());
    }

    public void SetColor(Vector4 color) {
        this.SetColor(color.IntX(), color.IntY(), color.IntZ(), color.IntW());
    }

    public Vector4 GetColor() {
        return this.color;
    }

    public void RenderOutsideOfCanvas(boolean val) {
        this.canvasCulling = !val;
    }

    public void DrawRect(float x, float y, float width, float height, float rot) {
        Window win = this.window;
        Vector2 translate = win.Translate();
        Vector2 offset = win.RenderOffset();
        x = (float)((double)x + translate.x());
        y = (float)((double)y + translate.y());
        if (this.canvasCulling) {
            if (x + width / 2.0f < -win.CanvasWidth() / 2.0f) {
                return;
            }
            if (x - width / 2.0f > win.CanvasWidth() / 2.0f) {
                return;
            }
            if (y + height / 2.0f < -win.CanvasHeight() / 2.0f) {
                return;
            }
            if (y - height / 2.0f > win.CanvasHeight() / 2.0f) {
                return;
            }
        }
        ++this.work_itemsDrawn;
        x = (float)((double)x + offset.x());
        y = (float)((double)y + offset.y());
        this.UseTexture(false);
        GL11.glPushMatrix();
        GL11.glTranslatef(x, y, 0.0f);
        GL11.glRotatef(rot, 0.0f, 0.0f, 1.0f);
        GL11.glBegin(7);
        GL11.glVertex2f(-width / 2.0f, -height / 2.0f);
        GL11.glVertex2f(-width / 2.0f, height / 2.0f);
        GL11.glVertex2f(width / 2.0f, height / 2.0f);
        GL11.glVertex2f(width / 2.0f, -height / 2.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public void DrawImage(String textureID, float x, float y, float width, float height, float rot) {
        this.DrawImage(textureID, x, y, width, height, rot, false);
    }

    public void DrawImage(String textureID, float x, float y, float width, float height, float rot, boolean allowStretch) {
        Vector2 translate = this.window.Translate();
        Vector2 offset = this.window.RenderOffset();
        x = (float)((double)x + translate.x());
        y = (float)((double)y + translate.y());
        if (this.canvasCulling) {
            if (x + width / 2.0f < -this.window.CanvasWidth() / 2.0f) {
                return;
            }
            if (x - width / 2.0f > this.window.CanvasWidth() / 2.0f) {
                return;
            }
            if (y + height / 2.0f < -this.window.CanvasHeight() / 2.0f) {
                return;
            }
            if (y - height / 2.0f > this.window.CanvasHeight() / 2.0f) {
                return;
            }
        }
        x = (float)((double)x + offset.x());
        y = (float)((double)y + offset.y());
        boolean found = this.GetTexture(textureID);
        if (this.texture == null) {
            return;
        }
        ++this.work_itemsDrawn;
        ++this.work_images;
        this.UseTexture(true);
        this.BindTex();
        GL11.glPushMatrix();
        GL11.glTranslatef(x, y, 0.0f);
        GL11.glRotatef(rot, 0.0f, 0.0f, 1.0f);
        if (allowStretch) {
            GL11.glBegin(7);
            GL11.glTexCoord2f(0.0f, 1.0f);
            GL11.glVertex2f(-width / 2.0f, -height / 2.0f);
            GL11.glTexCoord2f(0.0f, 0.0f);
            GL11.glVertex2f(-width / 2.0f, height / 2.0f);
            GL11.glTexCoord2f(1.0f, 0.0f);
            GL11.glVertex2f(width / 2.0f, height / 2.0f);
            GL11.glTexCoord2f(1.0f, 1.0f);
            GL11.glVertex2f(width / 2.0f, -height / 2.0f);
            GL11.glEnd();
        } else {
            float tw = this.texture.Width();
            float th = this.texture.Height();
            float imgRatioH = tw / th;
            float imgRatioW = th / tw;
            if (imgRatioW * width > height) {
                GL11.glBegin(7);
                float imgRatio = imgRatioH;
                float val = height * imgRatio / 2.0f / width;
                GL11.glTexCoord2f(0.0f, 0.5f + val);
                GL11.glVertex2f(-width / 2.0f, -height / 2.0f);
                GL11.glTexCoord2f(0.0f, 0.5f - val);
                GL11.glVertex2f(-width / 2.0f, height / 2.0f);
                GL11.glTexCoord2f(1.0f, 0.5f - val);
                GL11.glVertex2f(width / 2.0f, height / 2.0f);
                GL11.glTexCoord2f(1.0f, 0.5f + val);
                GL11.glVertex2f(width / 2.0f, -height / 2.0f);
                GL11.glEnd();
            } else {
                GL11.glBegin(7);
                float imgRatio = imgRatioW;
                float val = width * imgRatio / 2.0f / height;
                GL11.glTexCoord2f(0.5f - val, 1.0f);
                GL11.glVertex2f(-width / 2.0f, -height / 2.0f);
                GL11.glTexCoord2f(0.5f - val, 0.0f);
                GL11.glVertex2f(-width / 2.0f, height / 2.0f);
                GL11.glTexCoord2f(0.5f + val, 0.0f);
                GL11.glVertex2f(width / 2.0f, height / 2.0f);
                GL11.glTexCoord2f(0.5f + val, 1.0f);
                GL11.glVertex2f(width / 2.0f, -height / 2.0f);
                GL11.glEnd();
            }
        }
        GL11.glPopMatrix();
    }

    public void DrawImageBind(float x, float y, float width, float height, float rot) {
        Window win = this.window;
        Vector2 translate = win.Translate();
        Vector2 offset = win.RenderOffset();
        x = (float)((double)x + translate.x());
        y = (float)((double)y + translate.y());
        if (this.canvasCulling) {
            if (x + width / 2.0f < -win.CanvasWidth() / 2.0f) {
                return;
            }
            if (x - width / 2.0f > win.CanvasWidth() / 2.0f) {
                return;
            }
            if (y + height / 2.0f < -win.CanvasHeight() / 2.0f) {
                return;
            }
            if (y - height / 2.0f > win.CanvasHeight() / 2.0f) {
                return;
            }
        }
        ++this.work_itemsDrawn;
        ++this.work_images;
        x = (float)((double)x + offset.x());
        y = (float)((double)y + offset.y());
        GL11.glEnable(3553);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glPushMatrix();
        GL11.glTranslatef(x, y, 0.0f);
        GL11.glRotatef(rot, 0.0f, 0.0f, 1.0f);
        GL11.glBegin(7);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex2f(-width / 2.0f, -height / 2.0f);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex2f(-width / 2.0f, height / 2.0f);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex2f(width / 2.0f, height / 2.0f);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex2f(width / 2.0f, -height / 2.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public void DrawImageFromSheet(String textureID, float x, float y, float width, float height, float imageX, float imageY, float spritesInRow, int sheetSize, float rot) {
        Window win = this.window;
        Vector2 translate = win.Translate();
        Vector2 offset = win.RenderOffset();
        x = (float)((double)x + translate.x());
        y = (float)((double)y + translate.y());
        if (this.canvasCulling) {
            if (x + width / 2.0f < -win.CanvasWidth() / 2.0f) {
                return;
            }
            if (x - width / 2.0f > win.CanvasWidth() / 2.0f) {
                return;
            }
            if (y + height / 2.0f < -win.CanvasHeight() / 2.0f) {
                return;
            }
            if (y - height / 2.0f > win.CanvasHeight() / 2.0f) {
                return;
            }
        }
        x = (float)((double)x + offset.x());
        y = (float)((double)y + offset.y());
        boolean found = this.GetTexture(textureID);
        if (this.texture == null) {
            return;
        }
        ++this.work_itemsDrawn;
        ++this.work_images;
        this.UseTexture(true);
        this.BindTex();
        GL11.glPushMatrix();
        GL11.glTranslatef(x, y, 0.0f);
        GL11.glRotatef(rot, 0.0f, 0.0f, 1.0f);
        GL11.glBegin(7);
        GL11.glTexCoord2f(imageX / (float)sheetSize, (imageY + (float)sheetSize / spritesInRow) / (float)sheetSize);
        GL11.glVertex2f(-width / 2.0f, -height / 2.0f);
        GL11.glTexCoord2f(imageX / (float)sheetSize, imageY / (float)sheetSize);
        GL11.glVertex2f(-width / 2.0f, height / 2.0f);
        GL11.glTexCoord2f((imageX + (float)sheetSize / spritesInRow - 0.1f) / (float)sheetSize, imageY / (float)sheetSize);
        GL11.glVertex2f(width / 2.0f, height / 2.0f);
        GL11.glTexCoord2f((imageX + (float)sheetSize / spritesInRow - 0.1f) / (float)sheetSize, (imageY + (float)sheetSize / spritesInRow) / (float)sheetSize);
        GL11.glVertex2f(width / 2.0f, -height / 2.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public void DrawImageFromSheet(String textureID, float x, float y, float width, float height, float imageX, float imageY, float imageW, float imageH, int widthbyheight, float rot) {
        Window win = this.window;
        Vector2 translate = win.Translate();
        Vector2 offset = win.RenderOffset();
        x = (float)((double)x + translate.x());
        y = (float)((double)y + translate.y());
        if (this.canvasCulling) {
            if (x + width / 2.0f < -win.CanvasWidth() / 2.0f) {
                return;
            }
            if (x - width / 2.0f > win.CanvasWidth() / 2.0f) {
                return;
            }
            if (y + height / 2.0f < -win.CanvasHeight() / 2.0f) {
                return;
            }
            if (y - height / 2.0f > win.CanvasHeight() / 2.0f) {
                return;
            }
        }
        ++this.work_itemsDrawn;
        x = (float)((double)x + offset.x());
        y = (float)((double)y + offset.y());
        boolean found = this.GetTexture(textureID);
        if (this.texture == null) {
            return;
        }
        this.UseTexture(true);
        this.BindTex();
        GL11.glPushMatrix();
        GL11.glTranslatef(x, y, 0.0f);
        GL11.glRotatef(rot, 0.0f, 0.0f, 1.0f);
        float sheetSizeW = 128.0f;
        float sheetSizeH = 128.0f;
        sheetSizeW = this.texture.Width();
        sheetSizeH = this.texture.Height();
        GL11.glBegin(7);
        GL11.glTexCoord2f(imageX / sheetSizeW, (imageY + imageH) / sheetSizeH);
        GL11.glVertex2f(-width / 2.0f, -height / 2.0f);
        GL11.glTexCoord2f(imageX / sheetSizeW, imageY / sheetSizeH);
        GL11.glVertex2f(-width / 2.0f, height / 2.0f);
        GL11.glTexCoord2f((imageX + imageW) / sheetSizeW, imageY / sheetSizeH);
        GL11.glVertex2f(width / 2.0f, height / 2.0f);
        GL11.glTexCoord2f((imageX + imageW) / sheetSizeW, (imageY + imageH) / sheetSizeH);
        GL11.glVertex2f(width / 2.0f, -height / 2.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public void DrawRoundedRect(double x, double y, double z, double width, double height, double offset, int arcSeg) {
        Window win = this.window;
        Vector2 translate = win.Translate();
        Vector2 roffset = win.RenderOffset();
        x += translate.x();
        y += translate.y();
        if (this.canvasCulling) {
            if (x + width / 2.0 < (double)(-win.CanvasWidth() / 2.0f)) {
                return;
            }
            if (x - width / 2.0 > (double)(win.CanvasWidth() / 2.0f)) {
                return;
            }
            if (y + height / 2.0 < (double)(-win.CanvasHeight() / 2.0f)) {
                return;
            }
            if (y - height / 2.0 > (double)(win.CanvasHeight() / 2.0f)) {
                return;
            }
        }
        ++this.work_itemsDrawn;
        x += roffset.x();
        y += roffset.y();
        double wsize = width / 2.0;
        double hsize = height / 2.0;
        this.UseTexture(false);
        GL11.glPushMatrix();
        GL11.glPopMatrix();
        this.DrawQuadFan(x, y, z, wsize - offset, hsize - offset);
        GL11.glBegin(7);
        GL11.glVertex3d(x - wsize + offset, y + hsize - offset, z);
        GL11.glVertex3d(x + wsize - offset, y + hsize - offset, z);
        GL11.glVertex3d(x + wsize - offset, y + hsize, z);
        GL11.glVertex3d(x - wsize + offset, y + hsize, z);
        GL11.glEnd();
        GL11.glBegin(7);
        GL11.glVertex3d(x - wsize + offset, y - hsize + offset, z);
        GL11.glVertex3d(x + wsize - offset, y - hsize + offset, z);
        GL11.glVertex3d(x + wsize - offset, y - hsize, z);
        GL11.glVertex3d(x - wsize + offset, y - hsize, z);
        GL11.glEnd();
        GL11.glBegin(7);
        GL11.glVertex3d(x - wsize, y - hsize + offset, z);
        GL11.glVertex3d(x - wsize + offset, y - hsize + offset, z);
        GL11.glVertex3d(x - wsize + offset, y + hsize - offset, z);
        GL11.glVertex3d(x - wsize, y + hsize - offset, z);
        GL11.glEnd();
        GL11.glBegin(7);
        GL11.glVertex3d(x + wsize - offset, y - hsize + offset, z);
        GL11.glVertex3d(x + wsize, y - hsize + offset, z);
        GL11.glVertex3d(x + wsize, y + hsize - offset, z);
        GL11.glVertex3d(x + wsize - offset, y + hsize - offset, z);
        GL11.glEnd();
        this.DrawPie(x + wsize - offset, y + hsize - offset, z, offset, 0.0, 90.0, arcSeg);
        this.DrawPie(x - wsize + offset, y + hsize - offset, z, offset, 90.0, 180.0, arcSeg);
        this.DrawPie(x - wsize + offset, y - hsize + offset, z, offset, 180.0, 270.0, arcSeg);
        this.DrawPie(x + wsize - offset, y - hsize + offset, z, offset, 270.0, 360.0, arcSeg);
        GL11.glPopMatrix();
    }

    private void DrawQuadFan(double x, double y, double z, double w, double h) {
        ++this.work_itemsDrawn;
        GL11.glBegin(6);
        GL11.glVertex3d(x, y, z);
        GL11.glVertex3d(x - w, y - h, z);
        GL11.glVertex3d(x + w, y - h, z);
        GL11.glVertex3d(x + w, y + h, z);
        GL11.glVertex3d(x - w, y + h, z);
        GL11.glVertex3d(x - w, y - h, z);
        GL11.glEnd();
    }

    private void DrawPie(double x, double y, double z, double r, double start, double end, int seg) {
        ++this.work_itemsDrawn;
        double ang = (end - start) / (double)seg;
        GL11.glBegin(6);
        GL11.glVertex3d(x, y, z);
        for (int i = 0; i <= seg; ++i) {
            double rx = r * Math.cos((start + ang * (double)i) * 3.1416 / 180.0);
            double ry = r * Math.sin((start + ang * (double)i) * 3.1416 / 180.0);
            GL11.glVertex3d(x + rx, y + ry, z);
        }
        GL11.glEnd();
    }

    public void DrawLine(float x, float y, float x2, float y2, float weight) {
        Window win = this.window;
        Vector2 translate = win.Translate();
        Vector2 offset = win.RenderOffset();
        x = (float)((double)x + translate.x());
        y = (float)((double)y + translate.y());
        x = (float)((double)x + offset.x());
        y = (float)((double)y + offset.y());
        x2 = (float)((double)x2 + translate.x());
        y2 = (float)((double)y2 + translate.y());
        x2 = (float)((double)x2 + offset.x());
        y2 = (float)((double)y2 + offset.y());
        ++this.work_itemsDrawn;
        this.UseTexture(false);
        GL11.glPushMatrix();
        GL11.glRotatef(0.0f, 0.0f, 0.0f, 1.0f);
        GL11.glLineWidth(weight);
        GL11.glBegin(3);
        GL11.glVertex2f(x, y);
        GL11.glVertex2f(x2, y2);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public int NumbOfObjectOnLastFrame() {
        return this.itemsDrawn;
    }

    public int NumbOfImagesOnLastFrame() {
        return this.imagesDraw;
    }

    public int TextureBinds() {
        return this.textureBinds;
    }
}

