/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus;

import com.arizotaz.lotus.utils.Fs;
import java.io.File;

public class SettingsFile {
    private File location = null;

    public SettingsFile(File file) {
        this.location = file.getAbsoluteFile();
    }

    public void SetFile(File file) {
        this.location = file.getAbsoluteFile();
    }

    public void SetString(String key, String value) {
        String settings;
        key = key.toLowerCase();
        if (!this.location.exists()) {
            Fs.WriteText(this.location, "");
        }
        if ((settings = Fs.ReadText(this.location)).equals("")) {
            Fs.WriteText(this.location, key + "=" + value + "\n");
        } else {
            String[] lines = settings.split("\n");
            boolean found = false;
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                String lineKey = line.split("=")[0];
                if (!lineKey.equals(key)) continue;
                found = true;
                lines[i] = key + "=" + value;
            }
            Object saveData = "";
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                String lineKey = line.split("=")[0];
                String lineVal = line.split("=")[1];
                saveData = (String)saveData + lineKey + "=" + lineVal + "\n";
            }
            if (!found) {
                saveData = (String)saveData + key + "=" + value + "\n";
            }
            Fs.WriteText(this.location, (String)saveData);
        }
    }

    public void SetInt(String key, int value) {
        this.SetString(key, String.valueOf(value));
    }

    public void SetFloat(String key, float value) {
        this.SetString(key, String.valueOf(value));
    }

    public void SetBoolean(String key, boolean value) {
        this.SetInt(key, value ? 1 : 0);
    }

    public String GetString(String key) {
        String settings;
        key = key.toLowerCase();
        String value = "";
        if (!this.location.exists()) {
            Fs.WriteText(this.location, "");
        }
        if (!(settings = Fs.ReadText(this.location)).equals("")) {
            String[] lines = settings.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                String lineKey = line.split("=")[0];
                String lineVal = line.split("=")[1];
                if (!lineKey.equals(key)) continue;
                value = lineVal;
            }
        }
        return value;
    }

    public int GetInt(String key) {
        int value = 0;
        String lineVal = this.GetString(key);
        if (!lineVal.equals("")) {
            value = Integer.parseInt(lineVal);
        }
        return value;
    }

    public float GetFloat(String key) {
        float value = 0.0f;
        String lineVal = this.GetString(key);
        if (!lineVal.equals("")) {
            value = Float.parseFloat(lineVal);
        }
        return value;
    }

    public boolean GetBoolean(String key) {
        boolean value = false;
        value = this.GetInt(key) == 1;
        return value;
    }

    public boolean Exists(String key) {
        String settings;
        key = key.toLowerCase();
        boolean value = false;
        if (!this.location.exists()) {
            Fs.WriteText(this.location, "");
        }
        if (!(settings = Fs.ReadText(this.location)).equals("")) {
            String[] lines = settings.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                String lineKey = line.split("=")[0];
                if (!lineKey.equals(key)) continue;
                value = true;
            }
        }
        return value;
    }

    public File GetFile() {
        return this.location;
    }

    public String[] Keys() {
        String settings = Fs.ReadText(this.location);
        String[] lines = settings.split("\n");
        String[] keys = new String[lines.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = lines[i].split("=")[0];
        }
        return keys;
    }
}

