/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus;

import com.arizotaz.lotus.Font;
import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.struc.Vector2;
import com.arizotaz.lotus.struc.Vector3;
import com.arizotaz.lotus.struc.Vector4;
import com.arizotaz.lotus.utils.Tools;
import com.arizotaz.lotus.window.Window;
import java.util.Arrays;
import java.util.List;
import org.lwjgl.glfw.GLFW;

public class Text {
    public static float defaultCharacterSpacing = 0.05f;
    public static float defaultFontSize = 18.0f;
    public static float defaultLineSpacing = 1.0f;
    public static float defaultSpaceWidth = 0.5f;
    public static int defaulthHAlign = 1;
    public static int defaultVAlign = 1;
    public static int defaultTabSize = 8;
    public static int defaultMaxWordCount = Integer.MAX_VALUE;
    public static String defaultFont = "default";
    public static int dr = 0;
    public static int dg = 0;
    public static int db = 0;
    public static int da = 255;
    String text = "";
    boolean textChanged = true;
    String renderText = "";
    String textFont = defaultFont;
    float fontSize = defaultFontSize;
    float textureWidth = 0.0f;
    float textureHeight = 0.0f;
    float width = 0.0f;
    float height = 0.0f;
    float maxWidth = 1280.0f;
    int halign = defaulthHAlign;
    int valign = defaultVAlign;
    int tr = 0;
    int tg = 0;
    int tb = 0;
    int ta = 255;
    public static int left = 0;
    public static int center = 1;
    public static int right = 2;
    float characterSpacing = defaultCharacterSpacing;
    float lineSpacing = defaultLineSpacing;
    float spaceWidth = defaultSpaceWidth;
    float tabSize = defaultTabSize;
    int maxWordCount = defaultMaxWordCount;
    boolean wrapText = true;
    int selectedIndex = -1;
    private Window window;

    public static void SetDefaultColor(int r, int g, int b, int a) {
        dr = r;
        dg = g;
        db = b;
        da = a;
    }

    public static void SetDefaultColor(int r, int g, int b) {
        Text.SetDefaultColor(r, g, b, 255);
    }

    public static void SetDefaultColor(int l, int a) {
        Text.SetDefaultColor(l, l, l, a);
    }

    public static void SetDefaultColor(int l) {
        Text.SetDefaultColor(l, l, l);
    }

    public Text(String text) {
        this.tr = dr;
        this.tg = dg;
        this.tb = db;
        this.ta = da;
        this.SetText(text);
        this.Set();
    }

    private void Set() {
        Font font = Font.GetFont(this.textFont);
        this.textureWidth = font.Width();
        this.textureHeight = font.Height();
        this.renderText = this.ProcessString(this.text);
        this.width = 0.0f;
        this.height = 0.0f;
        float xIndex = 0.0f;
        float yIndex = 0.0f;
        String[] words = this.renderText.split(" ");
        int w = 0;
        while ((float)w < Tools.ClampVar(words.length, 0.0f, this.maxWordCount)) {
            if (this.wrapText && xIndex + this.GetStringLength(words[w]) + this.spaceWidth * this.fontSize > this.maxWidth) {
                if (xIndex > this.width) {
                    this.width = xIndex;
                }
                xIndex = 0.0f;
                yIndex -= this.fontSize * this.lineSpacing;
            }
            char[] chars = words[w].toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                Font.Char charObj;
                if (chars[i] == '\n') {
                    if (this.wrapText) {
                        if (xIndex > this.width) {
                            this.width = xIndex;
                        }
                        xIndex = 0.0f;
                        yIndex -= this.fontSize * this.lineSpacing;
                    } else {
                        xIndex += this.spaceWidth * this.fontSize;
                    }
                }
                if (chars[i] == '\t') {
                    xIndex += this.spaceWidth * this.fontSize * this.tabSize;
                }
                if (chars.length - i > 9 && chars[i] == '%' && chars[i + 1] == '^' && chars[i + 2] == 'c') {
                    i += 9;
                }
                if (chars.length - i > 4 && chars[i] == '%' && chars[i + 1] == '^' && chars[i + 2] == 'f') {
                    boolean fd = false;
                    Object fontName = "";
                    for (int s = i += 3; s < chars.length; ++s) {
                        if (fd) continue;
                        if (chars[s] != ';') {
                            fontName = (String)fontName + chars[s];
                            ++i;
                            continue;
                        }
                        fd = !fd;
                    }
                    font = Font.GetFont((String)fontName);
                    ++i;
                }
                if (i >= chars.length || (charObj = font.GetChar(chars[i])) == null) continue;
                float charHeight = (float)charObj.height() / font.LargestCharHeight() * this.fontSize;
                float charWidth = charHeight / (float)charObj.height() * (float)charObj.width();
                xIndex += charWidth / 2.0f + this.fontSize * this.characterSpacing;
                xIndex += charWidth / 2.0f + this.fontSize * this.characterSpacing;
            }
            if (Tools.ClampVar(words.length, 0.0f, this.maxWordCount) - 1.0f != (float)w) {
                xIndex += this.spaceWidth * this.fontSize;
            }
            ++w;
        }
        if (xIndex > this.width) {
            this.width = xIndex;
        }
        if (this.width == 0.0f) {
            this.width = xIndex;
        }
        this.height = -yIndex + this.fontSize * this.lineSpacing;
        this.textChanged = false;
    }

    public void Render(float x, float y) {
        this.window = Lotus.singleton.WindowManager().GetCurrentWindow();
        Window win = Lotus.singleton.WindowManager().GetByGL(GLFW.glfwGetCurrentContext());
        Vector2 translate = win.Translate();
        Font font = Font.GetFont(this.textFont);
        this.selectedIndex = -1;
        if (this.textChanged) {
            this.Set();
        }
        if (this.renderText.equals("")) {
            return;
        }
        float lastTransX = (float)translate.x();
        float lastTransY = (float)translate.y();
        translate.Move(x, y);
        if (this.halign == 1) {
            translate.Move(-this.width / 2.0f, 0.0);
        }
        if (this.halign == 2) {
            translate.Move(-this.width, 0.0);
        }
        if (this.valign == 1) {
            translate.Move(0.0, this.height / 2.0f);
        }
        if (this.valign == 2) {
            translate.Move(0.0, this.height);
        }
        float xIndex = 0.0f;
        float yIndex = 0.0f;
        this.window.RenderObjects().SetColor(this.tr, this.tg, this.tb, this.ta);
        String[] words = this.renderText.split(" ");
        int w = 0;
        while ((float)w < Tools.ClampVar(words.length, 0.0f, this.maxWordCount)) {
            if (this.wrapText && xIndex + this.GetStringLength(words[w]) + this.spaceWidth * this.fontSize > this.maxWidth) {
                if (xIndex > this.width) {
                    this.width = xIndex;
                }
                xIndex = 0.0f;
                yIndex -= this.fontSize * this.lineSpacing;
            }
            char[] chars = words[w].toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                Font.Char charObj;
                if (chars[i] == '\n') {
                    if (this.wrapText) {
                        if (xIndex > this.width) {
                            this.width = xIndex;
                        }
                        xIndex = 0.0f;
                        yIndex -= this.fontSize * this.lineSpacing;
                    } else {
                        xIndex += this.spaceWidth * this.fontSize;
                    }
                }
                if (chars[i] == '\t') {
                    xIndex += this.spaceWidth * this.fontSize * this.tabSize;
                }
                if (chars.length - i > 9 && chars[i] == '%' && chars[i + 1] == '^' && chars[i + 2] == 'c') {
                    String hexR = String.valueOf(chars[i + 3]) + String.valueOf(chars[i + 4]);
                    String hexG = String.valueOf(chars[i + 5]) + String.valueOf(chars[i + 6]);
                    String hexB = String.valueOf(chars[i + 7]) + String.valueOf(chars[i + 8]);
                    this.window.RenderObjects().SetColor(Integer.valueOf(hexR, 16).intValue(), Integer.valueOf(hexG, 16).intValue(), Integer.valueOf(hexB, 16).intValue(), this.ta);
                    i += 9;
                }
                if (chars.length - i > 4 && chars[i] == '%' && chars[i + 1] == '^' && chars[i + 2] == 'f') {
                    boolean fd = false;
                    Object fontName = "";
                    for (int s = i += 3; s < chars.length; ++s) {
                        if (fd) continue;
                        if (chars[s] != ';') {
                            fontName = (String)fontName + chars[s];
                            ++i;
                            continue;
                        }
                        fd = !fd;
                    }
                    font = Font.GetFont((String)fontName);
                    ++i;
                }
                if (chars.length - i > 3 && chars[i] == '%' && chars[i + 1] == '^' && chars[i + 2] == 'r') {
                    this.window.RenderObjects().SetColor(this.tr, this.tg, this.tb, this.ta);
                    i += 3;
                }
                if (i >= chars.length || (charObj = font.GetChar(chars[i])) == null) continue;
                float charHeight = (float)charObj.height() / font.LargestCharHeight() * this.fontSize;
                float charDept = (float)(charObj.originY() - charObj.height()) / font.LargestCharHeight() * this.fontSize;
                float charWidth = charHeight / (float)charObj.height() * (float)charObj.width();
                this.window.RenderObjects().DrawImageFromSheet(font.Texture(), xIndex += charWidth / 2.0f + this.fontSize * this.characterSpacing, yIndex - this.fontSize / 1.2f + charHeight / 2.0f + charDept, charWidth, charHeight, charObj.x(), charObj.y(), charObj.width(), charObj.height(), 1, 0.0f);
                xIndex += charWidth / 2.0f + this.fontSize * this.characterSpacing;
            }
            if (Tools.ClampVar(words.length, 0.0f, this.maxWordCount) - 1.0f != (float)w) {
                xIndex += this.spaceWidth * this.fontSize;
            }
            ++w;
        }
        if (xIndex > this.width) {
            this.width = xIndex;
        }
        if (this.width == 0.0f) {
            this.width = xIndex;
        }
        this.height = -yIndex + this.fontSize * this.lineSpacing;
        translate.Set(lastTransX, lastTransY);
    }

    public int GetSelectedIndex() {
        return this.selectedIndex;
    }

    public void Calculate() {
        this.Set();
    }

    public void AllowWrap(boolean val) {
        this.wrapText = val;
        this.textChanged = true;
    }

    public void MaxWordCount(int num) {
        this.maxWordCount = num > 0 ? num : defaultMaxWordCount;
    }

    public int GetMaxWordCount() {
        return this.maxWordCount;
    }

    public void SetText(String text) {
        this.text = text;
        this.textChanged = true;
    }

    public void PushText(String text) {
        this.text = this.text + text;
        this.textChanged = true;
    }

    public void UnShiftText(String text) {
        this.text = text + this.text;
        this.textChanged = true;
    }

    public String GetText() {
        return this.text;
    }

    public String GetProcessedText() {
        return this.renderText;
    }

    public void SetFont(String font) {
        this.textFont = font;
        this.textChanged = true;
    }

    public void FontSize(float font) {
        this.fontSize = font;
        this.textChanged = true;
    }

    public void MaxWidth(float max) {
        this.maxWidth = max;
        this.textChanged = true;
    }

    public void SetLineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
        this.textChanged = true;
    }

    public void SetSpaceWidth(float spaceWidth) {
        this.spaceWidth = spaceWidth;
        this.textChanged = true;
    }

    public void Align(int horizontal) {
        this.halign = horizontal;
    }

    public void Align(int horizontal, int vertical) {
        this.Align(horizontal);
        this.valign = vertical;
    }

    public void TabSize(int s) {
        this.tabSize = s;
    }

    public float Width() {
        return this.width;
    }

    public float Height() {
        return this.height;
    }

    public float GetSpaceWidth() {
        return this.spaceWidth;
    }

    public float GetLineHeight() {
        return this.lineSpacing;
    }

    public float GetFontSize() {
        return this.fontSize;
    }

    public void Color(Vector2 c) {
        this.Color(c.IntX(), c.IntY());
    }

    public void Color(Vector3 c) {
        this.Color(c.IntX(), c.IntY(), c.IntZ());
    }

    public void Color(Vector4 c) {
        this.Color(c.IntX(), c.IntY(), c.IntZ(), c.IntW());
    }

    public void Color(int v) {
        this.Color(v, 255);
    }

    public void Color(int v, int a) {
        this.Color(v, v, v, a);
    }

    public void Color(int r, int g, int b) {
        this.Color(r, g, b, 255);
    }

    public void Color(int r, int g, int b, int a) {
        this.tr = r;
        this.tg = g;
        this.tb = b;
        this.ta = a;
    }

    private String ProcessString(String val) {
        Window win = Lotus.singleton.WindowManager().GetByGL(GLFW.glfwGetCurrentContext());
        String text = val;
        String[] words = text.split(" ");
        if (words.length > 0 && words.length > this.maxWordCount) {
            List<String> arrayList = Arrays.asList(words);
            arrayList = arrayList.subList(0, this.maxWordCount);
            text = String.join((CharSequence)" ", arrayList);
        }
        text = text.replaceAll("%version%", Lotus.singleton.AppInfo().Version().toString());
        text = text.replaceAll("%id%", Lotus.singleton.AppInfo().ID());
        text = text.replaceAll("%appname%", Lotus.singleton.AppInfo().Name());
        text = text.replaceAll("%fps%", String.valueOf(Math.round(win.FPS())));
        text = text.replaceAll("%fps.average%", String.valueOf(Math.round(win.FPS_AVERAGE())));
        text = text.replaceAll("%fps.high%", String.valueOf(Math.round(win.FPS_LOW())));
        text = text.replaceAll("%fps.low%", String.valueOf(Math.round(win.FPS_HIGH())));
        text = text.replaceAll("%lversion%", Lotus.singleton.EngineInfo().Version().toString());
        text = text.replaceAll("%platform%", Lotus.singleton.Platform().OSName());
        while (text.contains("%gar%")) {
            String setOfCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890-=[];,./!@#%^&*()_+{}|:<>?";
            int randomInt = (int)Math.round(Math.random() * (double)(setOfCharacters.length() - 1));
            text = text.replaceFirst("%core.gar%", String.valueOf(setOfCharacters.charAt(randomInt)));
        }
        return text;
    }

    public float GetStringLength(String val) {
        Font font = Font.GetFont(this.textFont);
        float result = 0.0f;
        char[] chars = val.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            Font.Char charObj;
            if (chars[i] == '\n') {
                if (this.wrapText) {
                    if (result > this.width) {
                        this.width = result;
                    }
                    result = 0.0f;
                    result -= this.fontSize * this.lineSpacing;
                } else {
                    result += this.spaceWidth * this.fontSize;
                }
            }
            if (chars[i] == '\t') {
                result += this.spaceWidth * this.fontSize * this.tabSize;
            }
            if (chars.length - i > 9 && chars[i] == '%' && chars[i + 1] == '^' && chars[i + 2] == 'c') {
                i += 9;
            }
            if (chars.length - i > 4 && chars[i] == '%' && chars[i + 1] == '^' && chars[i + 2] == 'f') {
                boolean fd = false;
                Object fontName = "";
                for (int s = i += 3; s < chars.length; ++s) {
                    if (fd) continue;
                    if (chars[s] != ';') {
                        fontName = (String)fontName + chars[s];
                        ++i;
                        continue;
                    }
                    fd = !fd;
                }
                font = Font.GetFont((String)fontName);
                ++i;
            }
            if (i >= chars.length || (charObj = font.GetChar(chars[i])) == null) continue;
            float charHeight = (float)charObj.height() / font.LargestCharHeight() * this.fontSize;
            float charWidth = charHeight / (float)charObj.height() * (float)charObj.width();
            result += charWidth / 2.0f + this.fontSize * this.characterSpacing;
            result += charWidth / 2.0f + this.fontSize * this.characterSpacing;
        }
        return result;
    }
}

