/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.gamepad;

import com.arizotaz.lotus.gamepad.Controller;

public class ControllerManager {
    public static final int max_controllers = 16;
    private Controller[] controllers = new Controller[16];

    public void ConnectController(int jid) {
        this.controllers[jid] = new Controller(jid);
    }

    public Controller GetController(int id) {
        return this.controllers[id];
    }

    public boolean GetAnyButton(int button) {
        boolean val = false;
        for (int c = 0; c < this.controllers.length; ++c) {
            Controller controller = this.controllers[c];
            if (controller == null || !controller.Button(button)) continue;
            val = true;
        }
        return val;
    }

    public float GetAnyAxis(int axis) {
        float extreme = 0.0f;
        float val = 0.0f;
        for (int c = 0; c < this.controllers.length; ++c) {
            float a;
            float abs;
            Controller controller = this.controllers[c];
            if (controller == null || !((abs = Math.abs(a = controller.Axis(axis))) > extreme)) continue;
            extreme = abs;
            val = a;
        }
        return val;
    }

    public float GetAnyValue(int input) {
        float extreme = 0.0f;
        float val = 0.0f;
        for (int c = 0; c < this.controllers.length; ++c) {
            float a;
            float abs;
            Controller controller = this.controllers[c];
            if (controller == null || !((abs = Math.abs(a = controller.Value(input))) > extreme)) continue;
            extreme = abs;
            val = a;
        }
        return val;
    }

    public void Poll() {
        for (int c = 0; c < this.controllers.length; ++c) {
            if (this.controllers[c] == null) continue;
            this.controllers[c].GetStates();
        }
    }

    public void DisconnectController(int jid) {
        if (this.controllers[jid] != null) {
            this.controllers[jid].Disconnected();
        }
        this.controllers[jid] = null;
    }
}

