/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.managers;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.LotusDebug;
import com.arizotaz.lotus.utils.TextShorts;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class ThreadManager {
    public static boolean inited = false;
    public static long startProtection = 60000L;
    private volatile TreeMap<Integer, ThreadWrapper> threads = new TreeMap();
    private volatile boolean lock = false;
    private int maxThreads = 128;
    private volatile int aliveThreads = 0;

    public ThreadManager(Lotus lotus) {
        if (inited) {
            Lotus.singleton.Exit(10940003);
        }
        inited = true;
        this.lock = false;
        this.maxThreads = Runtime.getRuntime().availableProcessors();
        if (this.maxThreads < 10) {
            this.maxThreads = 10;
        }
        LotusDebug.Log("[THREADMANAGER] INITED");
    }

    public int Create(Thread thread) {
        return this.Create("T" + (Math.floor(Math.random() * 399.0) + 1.0), thread, false);
    }

    public int Create(String name, Thread thread) {
        return this.Create(name, thread, false);
    }

    public int Create(String name, Thread thread, boolean persistent) {
        return this.Create(name, thread, persistent, false);
    }

    public int Create(String name, Thread thread, boolean persistent, boolean ignoreLimit) {
        LotusDebug.Log("[THREADMANAGER] Attempting to create a thread named " + name);
        this.WaitForLock();
        LotusDebug.Log("[THREADMANAGER] Creating a thread named " + name);
        try {
            int id = 0;
            id = (int)Math.floor(Math.random() * 9.9999999E7) + 1;
            while (this.threads.get(id) != null) {
                id = (int)Math.floor(Math.random() * 9.9999999E7) + 1;
            }
            LotusDebug.Log("[THREADMANAGER] thread named " + name + " has been given an id of " + id);
            ThreadWrapper tw = new ThreadWrapper();
            tw.id = id;
            tw.name = name;
            tw.thread = thread;
            tw.killedReason = 0;
            tw.persistent = persistent;
            tw.timeEnd = -1L;
            tw.timeStart = System.currentTimeMillis();
            tw.alive = false;
            tw.ignoreLimit = ignoreLimit;
            LotusDebug.Log("[THREADMANAGER] Created thread wrapper for " + id);
            this.threads.put(id, tw);
            LotusDebug.Log("[THREADMANAGER] Created new thread:" + id + " named " + name);
            LotusDebug.Log("[THREADMANAGER] Releasing Lock " + id);
            this.ReleaseLock();
            return id;
        }
        catch (Exception e) {
            this.ReleaseLock();
            System.err.println("Failed to create thread " + name + "\n" + TextShorts.StackTraceToString(e));
            return 0;
        }
    }

    public boolean Start(int id) {
        boolean success = true;
        boolean shouldWait = true;
        this.WaitForLock();
        try {
            shouldWait = !this.threads.get(id).IgnoreLimit();
        }
        catch (Exception e) {
            System.err.println("Failed to check thread " + id + " ignore status\n" + TextShorts.StackTraceToString(e));
        }
        this.ReleaseLock();
        if (shouldWait) {
            this.WaitForOpenThread();
        }
        this.WaitForLock();
        try {
            success = this.threads.get(id).Start();
            if (!success) {
                System.err.println("This thread has already been used");
            } else {
                ++this.aliveThreads;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to start thread " + id + "\n" + TextShorts.StackTraceToString(e));
            success = false;
        }
        this.ReleaseLock();
        return success;
    }

    public void Update() {
        this.CheckAlive();
    }

    private ThreadWrapper GetThread(int id) {
        ThreadWrapper thread = null;
        this.WaitForLock();
        thread = this.threads.get(id);
        this.ReleaseLock();
        return thread;
    }

    private boolean ThreadInList(int id) {
        ThreadWrapper thread = null;
        this.WaitForLock();
        thread = this.threads.get(id);
        this.ReleaseLock();
        return thread != null;
    }

    public boolean IsAlive(int id) {
        boolean alive = false;
        this.WaitForLock();
        try {
            ThreadWrapper thread = this.threads.get(id);
            if (thread != null) {
                alive = thread.Alive();
            }
        }
        catch (Exception e) {
            System.err.println("Failed to check thread " + id + " status\n" + TextShorts.StackTraceToString(e));
            alive = false;
        }
        this.ReleaseLock();
        return alive;
    }

    public int ThreadsAlive() {
        return this.aliveThreads;
    }

    private void CheckAlive() {
        int n = 0;
        this.WaitForLock();
        try {
            for (Map.Entry<Integer, ThreadWrapper> t : this.threads.entrySet()) {
                if (!t.getValue().Alive()) {
                    if (!t.getValue().started && t.getValue().timeStart + startProtection >= System.currentTimeMillis()) continue;
                    t.getValue().dead = true;
                    continue;
                }
                ++n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ReleaseLock();
        this.aliveThreads = n;
    }

    public int ThreadsTotal() {
        return this.threads.size();
    }

    public String[] ThreadNames() {
        String[] names = new String[this.threads.size()];
        this.WaitForLock();
        int i = 0;
        for (Map.Entry<Integer, ThreadWrapper> t : this.threads.entrySet()) {
            names[i] = t.getValue().Name();
            ++i;
        }
        this.ReleaseLock();
        return names;
    }

    public boolean IsPersistent(int id) {
        boolean persistent = false;
        this.WaitForLock();
        try {
            persistent = this.threads.get(id).Persistent();
        }
        catch (Exception e) {
            System.err.println("Failed to check thread " + id + " status\n" + TextShorts.StackTraceToString(e));
            persistent = false;
        }
        this.ReleaseLock();
        return persistent;
    }

    public void GC() {
        this.WaitForLock();
        for (Map.Entry<Integer, ThreadWrapper> t : this.threads.entrySet()) {
            if (t.getValue().Alive()) continue;
            t.getValue().dead = true;
        }
        this.ReleaseLock();
    }

    public void CleanDeadThreads() {
        this.WaitForLock();
        try {
            ArrayList<Integer> killThreads = new ArrayList<Integer>();
            for (Map.Entry<Integer, ThreadWrapper> t : this.threads.entrySet()) {
                if (!t.getValue().Dead()) continue;
                killThreads.add(t.getValue().ID());
            }
            for (int i = 0; i < killThreads.size(); ++i) {
                this.threads.remove(killThreads.get(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ReleaseLock();
    }

    public void DeleteThread(int id) {
        this.WaitForLock();
        try {
            this.threads.remove(id);
        }
        catch (Exception e) {
            System.err.println("Failed to delete thread " + id + "\n" + TextShorts.StackTraceToString(e));
        }
        this.ReleaseLock();
    }

    public void WaitForOpenThread() {
        if (this.aliveThreads >= this.maxThreads) {
            System.err.println("A thread has been queued until the thread limit is left " + this.aliveThreads + "/" + this.maxThreads);
        }
        while (this.aliveThreads >= this.maxThreads) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public int HoldTillDead() {
        int n = 0;
        try {
            for (Map.Entry<Integer, ThreadWrapper> t : this.threads.entrySet()) {
                if (!t.getValue().thread.isAlive()) continue;
                ++n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return n;
    }

    public void SetMaxThreads(int val) {
        this.maxThreads = val;
    }

    public int MaxThreads() {
        return this.maxThreads;
    }

    private boolean WaitForLock() {
        if (Lotus.singleton.Platform().IsMac()) {
            return true;
        }
        while (this.lock) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.lock = true;
        return true;
    }

    private boolean ReleaseLock() {
        this.lock = false;
        return true;
    }

    public String GetName(int id) {
        String result = "";
        this.WaitForLock();
        try {
            ThreadWrapper thread = this.threads.get(id);
            if (thread == null) {
                return "Unknown Thread";
            }
            result = thread.Name();
        }
        catch (Exception e) {
            System.err.println("Failed to get thread " + id + "\n" + TextShorts.StackTraceToString(e));
        }
        this.ReleaseLock();
        return result;
    }

    public ThreadWrapper[] List() {
        ThreadWrapper[] result = new ThreadWrapper[this.threads.size()];
        this.WaitForLock();
        try {
            int i = 0;
            for (Map.Entry<Integer, ThreadWrapper> me : this.threads.entrySet()) {
                result[i] = me.getValue();
                ++i;
            }
            this.ReleaseLock();
        }
        catch (Exception e) {
            System.err.println("Failed to list threads \n" + TextShorts.StackTraceToString(e));
            this.ReleaseLock();
            result = this.List();
        }
        return result;
    }

    public class ThreadWrapper {
        private int id;
        private String name;
        private Thread thread;
        private boolean persistent;
        private long timeStart;
        private long timeEnd;
        private boolean alive;
        private int killedReason;
        private boolean started;
        private boolean dead = false;
        private boolean ignoreLimit = false;

        public int ID() {
            return this.id;
        }

        public boolean Dead() {
            return this.dead;
        }

        public boolean Start() {
            if (!this.started) {
                this.started = true;
                this.thread.start();
                return true;
            }
            return false;
        }

        public boolean Started() {
            return this.started;
        }

        public String Name() {
            return this.name;
        }

        public boolean Persistent() {
            return this.persistent;
        }

        public boolean Alive() {
            return this.thread.isAlive();
        }

        public boolean IgnoreLimit() {
            return this.ignoreLimit;
        }
    }
}

