/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.parseXL;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.OSPlatform;
import com.arizotaz.lotus.utils.FileDownload;
import com.arizotaz.lotus.utils.Fs;
import com.arizotaz.lotus.utils.Java;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class PARSEXL {
    public static String parseXLjar = "";
    public static String status = "";
    public static JSONObject importJSON;
    private static boolean showWindow;

    public static FileDownload DownloadObject() {
        File file = Fs.FileUnite(Lotus.singleton.FileLocations().AppStorage(), "com.arizotaz.PARSEXL.jar");
        File tempFile = new File(file.getAbsolutePath() + ".tmp");
        if (Lotus.singleton.Platform().IsMac()) {
            tempFile = Fs.FileUnite(Fs.FileUnite(Lotus.singleton.FileLocations().UserHome(), "Downloads"), "ParseXL.jar.download");
        }
        FileDownload fileDownload = new FileDownload("https://lumonality.com/libraries/PARSEXL.jar", file, tempFile);
        fileDownload.UseTempFile(true);
        return fileDownload;
    }

    public static boolean Installed() {
        status = "Checking Installation";
        File localFile = Fs.FileUnite(Lotus.singleton.FileLocations().AppStorage(), "com.arizotaz.PARSEXL.jar");
        if (localFile.exists()) {
            parseXLjar = localFile.getAbsolutePath();
            return true;
        }
        return false;
    }

    public static void ShowWindow() {
        showWindow = true;
    }

    public static void HideWindow() {
        showWindow = false;
    }

    public static void ToggleWindow() {
        showWindow = !showWindow;
    }

    public static boolean WindowVisible() {
        return showWindow;
    }

    public static void ImportFile(File excelFile) throws IOException, ParseException {
        if (PARSEXL.Installed()) {
            OSPlatform os = new OSPlatform();
            status = "Creating temp file";
            int i = 0;
            String loc = new File("parseXL").getAbsolutePath();
            new File("parseXL").mkdirs();
            while (new File(loc + i + "_load.json").exists()) {
                ++i;
            }
            File saveToFile = new File(loc + i + "_load.json");
            saveToFile.createNewFile();
            status = "Launching ParseXL";
            String extra = "-Dextra";
            if (!os.IsWindows()) {
                extra = "-XstartOnFirstThread";
            }
            String windowSetting = "-Dwin";
            if (!showWindow) {
                windowSetting = "-DnoWindow=true";
            }
            ProcessBuilder pb = new ProcessBuilder(Java.FindJava(), extra, "-DreadFile=" + excelFile.getAbsolutePath(), "-DsaveLoc=" + saveToFile.getAbsolutePath(), windowSetting, "-jar", parseXLjar);
            Process p = pb.start();
            status = "Listening to ParseXL";
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append(System.getProperty("line.separator"));
            }
            String result = builder.toString();
            reader.close();
            if (result.contains("SAVED:")) {
                String st;
                status = "Reading returned data";
                Object fileContent = "";
                BufferedReader br = new BufferedReader(new FileReader(saveToFile));
                while ((st = br.readLine()) != null) {
                    fileContent = (String)fileContent + st;
                }
                br.close();
                status = "Parsing JSON";
                JSONParser parse = new JSONParser();
                importJSON = (JSONObject)parse.parse((String)fileContent);
                System.out.println("Imported " + excelFile.getAbsolutePath());
            } else {
                status = "Fail";
                System.out.println("Failed to read Excel File");
            }
            status = "Cleaning up";
            Fs.Remove(saveToFile);
        } else {
            System.out.println("parseXL is not installed");
        }
    }

    public static boolean SaveFile(String json) throws IOException {
        return PARSEXL.SaveFile(json, false);
    }

    public static boolean SaveFile(String json, boolean debug) throws IOException {
        if (PARSEXL.Installed()) {
            boolean success;
            OSPlatform os = new OSPlatform();
            status = "Creating temp file";
            int i = 0;
            String loc = new File("parseXL").getAbsolutePath();
            new File("parseXL").mkdirs();
            while (new File(loc + i + "_write.json").exists()) {
                ++i;
            }
            File saveLocation = new File(loc + i + "_write.json");
            FileWriter saveFile = new FileWriter(saveLocation);
            saveFile.write(json);
            saveFile.close();
            status = "Launching ParseXL";
            String extra = "-Dextra";
            if (!os.IsWindows()) {
                extra = "-XstartOnFirstThread";
            }
            String windowSetting = "-Dwin";
            if (!showWindow) {
                windowSetting = "-DnoWindow=true";
            }
            ProcessBuilder pb = new ProcessBuilder(Java.FindJava(), extra, "-DloadFile=" + saveLocation.getAbsolutePath(), windowSetting, "-jar", parseXLjar);
            Process p = pb.start();
            status = "Listening to ParseXL";
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append(System.getProperty("line.separator"));
            }
            String result = builder.toString();
            reader.close();
            if (result.contains("EXCELEXPORTDONE")) {
                System.out.println("SUCCESS");
                status = "SUCCESS";
                success = true;
            } else {
                status = "Fail";
                System.err.println(result);
                System.out.println("Failed to Write Excel File");
                success = false;
            }
            status = "Cleaning up";
            if (!debug) {
                Fs.Remove(saveLocation);
            } else {
                System.out.println("File Saved to " + saveLocation.getAbsolutePath());
            }
            return success;
        }
        System.out.println("parseXL is not installed");
        return false;
    }

    static {
        showWindow = false;
    }
}

