/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.parseXL.uielements;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.Text;
import com.arizotaz.lotus.parseXL.Cell;
import com.arizotaz.lotus.ui.elements.HoverArea;
import com.arizotaz.lotus.utils.Tools;
import com.arizotaz.lotus.window.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class SheetView {
    private Window window;
    private float x = 0.0f;
    private float y = 0.0f;
    private float width = 0.0f;
    private float height = 0.0f;
    private float maxCellHeight = 0.0f;
    private boolean useScroll = false;
    private boolean showRowIndex = false;
    private int lastNumOfRows = 0;
    private float scroll = 0.0f;
    private boolean hasScrollChange = false;
    ArrayList<ArrayList<Cell>> cells = new ArrayList();

    public SheetView() {
        this.window = Lotus.singleton.WindowManager().GetCurrentWindow();
        this.Clear();
    }

    public void Set(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void AddCellRow(Cell[] cells) {
        this.AddCellRow(cells, this.cells.size());
    }

    public void AddCellRow(Cell[] cells, int index) {
        ArrayList<Cell> row = new ArrayList<Cell>();
        for (int i = 0; i < cells.length; ++i) {
            row.add(cells[i]);
        }
        this.cells.add(index, row);
    }

    public void AddCellToRow(Cell cell, int r) {
        this.cells.get(r).add(cell);
    }

    public int LengthOfRow(int r) {
        return this.cells.get(r).size();
    }

    public void RenderRange(int end) {
        this.RenderRange(0, end, false);
    }

    public void SetMaxCellHeight(float height) {
        this.maxCellHeight = height;
    }

    public float GetMaxCellHeight() {
        return this.maxCellHeight;
    }

    public int NumOfRows() {
        return this.cells.size();
    }

    public void ShowScrollIndex(boolean val) {
        this.showRowIndex = val;
    }

    public void AllowScroll(boolean scroll) {
        this.useScroll = scroll;
    }

    public void SetScroll(int scroll) {
        this.scroll = -scroll;
    }

    public float GetScroll() {
        return -this.scroll;
    }

    public int RowsShown() {
        return this.lastNumOfRows;
    }

    public void Clear() {
        this.cells = new ArrayList();
    }

    public void Update() {
        HoverArea scrollBounds = new HoverArea();
        if (this.useScroll) {
            scrollBounds.Set(this.x + this.width / 2.0f, this.y - this.height / 2.0f, this.width, this.height);
            scrollBounds.Interact();
            if (scrollBounds.IsHoveringInBounds()) {
                this.scroll += this.window.Mouse().ScrollY();
                this.scroll = -Math.round(Tools.ClampVar(-this.scroll, 0.0f, this.NumOfRows() - 2));
                this.hasScrollChange = true;
            }
        }
    }

    public void RenderRange(int start, int end, boolean showHeader) {
        this.hasScrollChange = false;
        int offSet = 0;
        offSet = Math.round(Tools.SetSmallest(-this.scroll, 0.0f));
        end += offSet;
        end = Math.round(Tools.SetLargest(end, this.cells.size() - 1));
        int numberOfRows = end - (start += offSet);
        if (start == 0 && showHeader) {
            showHeader = false;
        }
        if (showHeader) {
            ++numberOfRows;
        }
        ArrayList rows = new ArrayList();
        int numOfHorizontalCells = 0;
        if (showHeader) {
            numOfHorizontalCells = this.LengthOfRow(0);
            HashMap<Integer, Serializable> dat = new HashMap<Integer, Serializable>();
            dat.put(0, Integer.valueOf(0));
            dat.put(1, this.cells.get(0));
            rows.add(dat);
        }
        for (int r = start; r < end; ++r) {
            if (this.cells.get(r) == null) continue;
            numOfHorizontalCells = Math.round(Tools.SetSmallest(numOfHorizontalCells, this.LengthOfRow(r)));
            HashMap<Integer, Serializable> dat = new HashMap<Integer, Serializable>();
            dat.put(0, Integer.valueOf(r));
            dat.put(1, this.cells.get(r));
            rows.add(dat);
        }
        float cellHeight = this.height / (float)numberOfRows;
        cellHeight = Tools.SetLargest(cellHeight, this.maxCellHeight);
        float indexWidth = 0.0f;
        if (this.showRowIndex) {
            indexWidth = cellHeight * 1.5f;
        }
        float cellWidth = (this.width - indexWidth) / (float)numOfHorizontalCells;
        this.window.RenderObjects().SetColor(0.0f);
        for (int r = 0; r < rows.size(); ++r) {
            if (this.showRowIndex) {
                this.RenderRowIndex((Integer)((HashMap)rows.get(r)).get(0), this.x, this.y - (float)r * cellHeight, indexWidth, cellHeight, r);
            }
            for (int c = 0; c < ((ArrayList)((HashMap)rows.get(r)).get(1)).size(); ++c) {
                Cell cell = (Cell)((ArrayList)((HashMap)rows.get(r)).get(1)).get(c);
                this.RenderCell(cell, this.x + indexWidth + (float)c * cellWidth, this.y - (float)r * cellHeight, cellWidth, cellHeight, r, c);
            }
        }
        this.lastNumOfRows = rows.size();
    }

    private void RenderRowIndex(int index, float x, float y, float width, float height, int row) {
        this.window.Translate().Move(width / 2.0f, -height / 2.0f);
        float padding = height / 8.0f;
        this.window.RenderObjects().SetColor(0.0f);
        this.window.RenderObjects().DrawRect(x, y, width, height, 0.0f);
        if (row % 2 == 0) {
            this.window.RenderObjects().SetColor(255.0f);
        } else {
            this.window.RenderObjects().SetColor(220.0f);
        }
        this.window.RenderObjects().DrawRect(x, y, width - padding, height - padding, 0.0f);
        Text text = new Text(String.valueOf(index));
        text.Align(0, 1);
        text.Color(0);
        text.FontSize(height / 2.0f);
        text.Render(x - width / 2.0f + padding, y);
        this.window.Translate().Move(-width / 2.0f, height / 2.0f);
    }

    private void RenderCell(Cell cell, float x, float y, float width, float height, int row, int column) {
        this.window.Translate().Move(width / 2.0f, -height / 2.0f);
        float padding = height / 8.0f;
        this.window.RenderObjects().SetColor(0.0f);
        this.window.RenderObjects().DrawRect(x, y, width, height, 0.0f);
        if (row % 2 == 0) {
            this.window.RenderObjects().SetColor(255.0f);
        } else {
            this.window.RenderObjects().SetColor(220.0f);
        }
        this.window.RenderObjects().DrawRect(x, y, width - padding, height - padding, 0.0f);
        Text text = new Text(cell.value);
        text.Align(0, 1);
        text.Color(0);
        text.FontSize(height / 2.0f);
        text.Render(x - width / 2.0f + padding, y);
        this.window.Translate().Move(-width / 2.0f, height / 2.0f);
    }

    public Cell[][] CellsToArray() {
        int numOfHorizontalCells = 0;
        for (int r = 0; r < this.cells.size(); ++r) {
            if (this.cells.get(r) == null) continue;
            numOfHorizontalCells = Math.round(Tools.SetSmallest(numOfHorizontalCells, this.LengthOfRow(r)));
        }
        Cell[][] rows = new Cell[this.cells.size()][numOfHorizontalCells];
        for (int r = 0; r < this.cells.size(); ++r) {
            rows[r] = this.ListToArray(this.cells.get(r));
        }
        return rows;
    }

    public Cell[] ListToArray(ArrayList<Cell> cells) {
        Cell[] cel = new Cell[cells.size()];
        for (int o = 0; o < cells.size(); ++o) {
            cel[o] = cells.get(o);
        }
        return cel;
    }

    public boolean HasScrollChange() {
        return this.hasScrollChange;
    }
}

