/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.struc;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.TimeZone;

public class Contact {
    private String image = "com/arizotaz/lotus/resources/contact_default.png";
    private boolean imageIsURL = false;
    private String name;
    private String username;
    private String email;
    private String phone;
    private long birth;
    private HashMap<String, String> links;

    public Contact(String name, String email) {
        this.SetData(name, name, email, "", 0L, new HashMap<String, String>());
    }

    public Contact(String name, String username, String email) {
        this.SetData(name, username, email, "", 0L, new HashMap<String, String>());
    }

    public Contact(String name, String username, String email, String phone) {
        this.SetData(name, username, email, phone, 0L, new HashMap<String, String>());
    }

    public Contact(String name, String username, String email, String phone, long birth) {
        this.SetData(name, username, email, phone, birth, new HashMap<String, String>());
    }

    public Contact(String name, String username, String email, long birth) {
        this.SetData(name, username, email, "", birth, new HashMap<String, String>());
    }

    public Contact(String name, String username, long birth) {
        this.SetData(name, username, "", "", birth, new HashMap<String, String>());
    }

    private void SetData(String name, String username, String email, String phone, long birth, HashMap<String, String> links) {
        this.name = name;
        this.username = username;
        this.email = email;
        this.phone = phone;
        this.birth = birth;
        this.links = links;
    }

    public void AddLink(String url) {
        this.links.put(url, url);
    }

    public void AddLink(String displayText, String url) {
        this.links.put(displayText, url);
    }

    public void SetContactImageLocal(String path) {
        this.imageIsURL = false;
        this.image = path;
    }

    public void SetContactImageUrl(String url) {
        this.imageIsURL = true;
        this.image = url;
    }

    public boolean ContactImageIsUrl() {
        return this.imageIsURL;
    }

    public String ContactImage() {
        return this.image;
    }

    public String Name() {
        return this.name;
    }

    public String Username() {
        return this.username;
    }

    public String Email() {
        return this.email;
    }

    public String Phone() {
        return this.phone;
    }

    public long BirthdayLong() {
        return this.birth;
    }

    public String Birthday() {
        LocalDateTime myDateObj = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.birth), TimeZone.getDefault().toZoneId());
        DateTimeFormatter myFormatObj = DateTimeFormatter.ofPattern("MM-dd-yyyy");
        return myDateObj.format(myFormatObj);
    }

    public long Age() {
        LocalDateTime today = LocalDateTime.now();
        LocalDateTime birthday = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.birth), TimeZone.getDefault().toZoneId());
        return Math.round((float)Duration.between(birthday, today).toDays() / 365.0f);
    }

    public HashMap<String, String> Links() {
        return this.links;
    }

    public boolean IsBirthday() {
        LocalDateTime myDateObj = LocalDateTime.now();
        DateTimeFormatter myFormatObj = DateTimeFormatter.ofPattern("MM-dd-yyyy");
        String today = myDateObj.format(myFormatObj);
        return today.equals(this.Birthday());
    }
}

