/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.struc;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.LotusDebug;

public abstract class Process {
    private boolean run = true;
    private String processName = "";
    private volatile int id;
    private volatile int threadID = -1;
    private volatile long processStarted = 0L;
    private long processEnded = 0L;
    private long processCreated = System.currentTimeMillis();
    private volatile boolean persistent = false;
    private boolean ignoreThreadLimit = false;
    protected Object processReturn = null;

    public void SetProcessName(String name) {
        this.processName = name;
    }

    public String ProcessName() {
        return this.processName;
    }

    public void SetID(int id) {
        this.id = id;
    }

    public long ProcessStarted() {
        return this.processStarted;
    }

    public long ProcessEnded() {
        return this.processEnded;
    }

    public long ProcessTime() {
        if (this.processEnded <= 0L) {
            return System.currentTimeMillis() - this.processStarted;
        }
        return this.processEnded - this.processStarted;
    }

    public int ID() {
        return this.id;
    }

    public int ThreadID() {
        return this.threadID;
    }

    public boolean Running() {
        return this.run;
    }

    public void QuitProcess() {
        this.run = false;
    }

    public void RunThread() {
        Object threadName = "Process:" + this.id;
        if (!this.processName.equals("")) {
            threadName = this.processName;
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Process.this.processStarted = System.currentTimeMillis();
                    Process.this.Start();
                    while (Process.this.Running() && Lotus.singleton.Running()) {
                        Process.this.Update();
                    }
                    Process.this.Exit();
                }
                catch (Exception e) {
                    Process.this.processEnded = System.currentTimeMillis();
                    Process.this.Exception(e);
                }
                catch (Error e) {
                    Process.this.processEnded = System.currentTimeMillis();
                    Process.this.IllegalError(e);
                }
            }
        });
        this.threadID = Lotus.singleton.ThreadManager().Create((String)threadName, t, this.persistent, this.ignoreThreadLimit);
        LotusDebug.Log("[PROCESSMANAGER] Starting Procees (" + this.id + ") thread");
        Lotus.singleton.ThreadManager().Start(this.threadID);
    }

    public abstract void Start();

    public abstract void Update();

    public abstract void Exit();

    public void Exception(Exception e) {
        e.printStackTrace();
    }

    public void IllegalError(Error e) {
        e.printStackTrace();
    }

    public void SetPersistent(boolean val) {
        this.persistent = val;
    }

    public boolean Persistent() {
        return this.persistent;
    }

    public void SetIgnoreThreadLimit(boolean value) {
        this.ignoreThreadLimit = value;
    }

    public boolean GetIgnoreThreadLimit() {
        return this.ignoreThreadLimit;
    }

    public Object ReturnValue() {
        return this.processReturn;
    }
}

