/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.struc;

import com.arizotaz.lotus.struc.Vector2;
import com.arizotaz.lotus.window.Window;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class RenderFrame {
    private Window window;
    private float x;
    private float y;
    private float width;
    private float height;
    private int fwidth;
    private int fheight;
    private int lastfwidth = 0;
    private int lastfheight = 0;
    private Vector2 translate;
    private Vector2 renderOffset;
    private Vector2 canvas;
    int colorTexture;
    int fbo;
    int multisampledColorRenderBuffer;
    int multisampledDepthRenderBuffer;
    int multisampledFbo;
    int samples = 0;

    public RenderFrame(Window window) {
        this.window = window;
        this.translate = new Vector2(0.0, 0.0);
        this.renderOffset = new Vector2(0.0, 0.0);
        this.canvas = new Vector2(0.0, 0.0);
    }

    public void Set(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.fwidth = Math.round(width);
        this.fheight = Math.round(height);
        if (this.lastfwidth != this.fwidth || this.lastfheight != this.fheight) {
            this.lastfwidth = this.fwidth;
            this.lastfheight = this.fheight;
            this.ResizeFBOs();
        }
    }

    public void PushTrans() {
        this.UpdateTranslate();
        this.UpdateRenderOffset();
        this.UpdateCanvas();
        this.window.Translate().Set(0.0, 0.0);
        this.window.RenderOffset().Set(this.x, this.y);
        this.window.SetCanvasSize(new Vector2(this.fwidth, this.fheight));
    }

    public void PopTrans() {
        this.ApplyTranslate();
        this.ApplyRenderOffset();
        this.ApplyCanvas();
    }

    public void Push() {
        this.UpdateTranslate();
        this.UpdateRenderOffset();
        this.UpdateCanvas();
        GL30.glBindFramebuffer(36160, this.multisampledFbo);
        GL11.glClear(this.multisampledFbo);
        GL11.glViewport(0, 0, this.fwidth, this.fheight);
        GL30.glMatrixMode(5889);
        GL30.glLoadIdentity();
        GL30.glOrtho(0.0, this.fwidth, 0.0, this.fheight, 0.0, 1.0);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glTranslatef(this.fwidth / 2, this.fheight / 2, 0.0f);
        this.window.Translate().Set(0.0, 0.0);
        this.window.RenderOffset().Set(0.0, 0.0);
        this.window.SetCanvasSize(new Vector2(this.fwidth, this.fheight));
    }

    public void Pop() {
        GL30.glBindFramebuffer(36160, this.window.MultisampledFbo());
        GL30.glBindFramebuffer(36008, this.multisampledFbo);
        GL30.glBindFramebuffer(36009, this.fbo);
        GL30.glBlitFramebuffer(0, 0, this.fwidth, this.fheight, 0, 0, this.fwidth, this.fheight, 16384, 9728);
        GL30.glBindFramebuffer(36160, this.window.MultisampledFbo());
        GL11.glEnable(3553);
        GL11.glBindTexture(3553, this.colorTexture);
        this.ApplyTranslate();
        this.ApplyRenderOffset();
        this.ApplyCanvas();
        GL11.glViewport(0, 0, (int)this.window.FrameWidth(), (int)this.window.FrameHeight());
        GL30.glMatrixMode(5889);
        GL30.glLoadIdentity();
        GL30.glOrtho(0.0, (int)this.window.FrameWidth(), 0.0, (int)this.window.FrameHeight(), 0.0, 1.0);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glTranslatef(this.window.FrameWidth() / 2.0f, this.window.FrameHeight() / 2.0f, 0.0f);
        float x = this.x;
        float y = this.y;
        Vector2 translate = this.window.Translate();
        Vector2 offset = this.window.RenderOffset();
        x = (float)((double)x + (translate.x() + offset.x()));
        y = (float)((double)y + (translate.y() + offset.y()));
        if (x + this.width / 2.0f < -this.window.CanvasWidth() / 2.0f) {
            return;
        }
        if (x - this.width / 2.0f > this.window.CanvasWidth() / 2.0f) {
            return;
        }
        if (y + this.height / 2.0f < -this.window.CanvasHeight() / 2.0f) {
            return;
        }
        if (y - this.height / 2.0f > this.window.CanvasHeight() / 2.0f) {
            return;
        }
        this.window.RenderObjects().SetColor(255.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef(x, y, 0.0f);
        GL11.glRotatef(0.0f, 0.0f, 0.0f, 1.0f);
        GL11.glBegin(7);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex2f(-this.width / 2.0f, -this.height / 2.0f);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex2f(-this.width / 2.0f, this.height / 2.0f);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex2f(this.width / 2.0f, this.height / 2.0f);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex2f(this.width / 2.0f, -this.height / 2.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float Width() {
        return this.width;
    }

    public float Height() {
        return this.height;
    }

    public void UpdateTranslate() {
        this.translate.Set(this.window.Translate().x(), this.window.Translate().y());
    }

    public void UpdateRenderOffset() {
        this.renderOffset.Set(this.window.RenderOffset().x(), this.window.RenderOffset().y());
    }

    public void UpdateCanvas() {
        this.canvas.Set(this.window.CanvasWidth(), this.window.CanvasHeight());
    }

    public void ApplyTranslate() {
        this.window.Translate().Set(this.translate.x(), this.translate.y());
    }

    public void ApplyRenderOffset() {
        this.window.RenderOffset().Set(this.renderOffset.x(), this.renderOffset.y());
    }

    public void ApplyCanvas() {
        this.window.SetCanvasSize(new Vector2(this.canvas.x(), this.canvas.y()));
    }

    public int MultisampledFbo() {
        return this.multisampledFbo;
    }

    void CreateFBOs() {
        this.multisampledColorRenderBuffer = GL30.glGenRenderbuffers();
        this.multisampledDepthRenderBuffer = GL30.glGenRenderbuffers();
        this.multisampledFbo = GL30.glGenFramebuffers();
        GL30.glBindFramebuffer(36160, this.multisampledFbo);
        GL30.glBindRenderbuffer(36161, this.multisampledColorRenderBuffer);
        GL30.glRenderbufferStorageMultisample(36161, this.samples, 32856, this.fwidth, this.fheight);
        GL30.glFramebufferRenderbuffer(36160, 36064, 36161, this.multisampledColorRenderBuffer);
        GL30.glBindRenderbuffer(36161, this.multisampledDepthRenderBuffer);
        GL30.glRenderbufferStorageMultisample(36161, this.samples, 35056, this.fwidth, this.fheight);
        GL30.glFramebufferRenderbuffer(36160, 36096, 36161, this.multisampledDepthRenderBuffer);
        int fboStatus = GL30.glCheckFramebufferStatus(36160);
        if (fboStatus != 36053) {
            return;
        }
        GL30.glBindRenderbuffer(36161, this.window.MultisampledFbo());
        GL30.glBindFramebuffer(36160, this.window.MultisampledFbo());
        this.colorTexture = GL11.glGenTextures();
        this.fbo = GL30.glGenFramebuffers();
        GL30.glBindFramebuffer(36160, this.fbo);
        GL11.glBindTexture(3553, this.colorTexture);
        GL11.glTexParameteri(3553, 10241, 9728);
        GL11.glTexParameteri(3553, 10240, 9728);
        GL11.glTexImage2D(3553, 0, 32856, this.fwidth, this.fheight, 0, 6408, 5121, (ByteBuffer)null);
        GL30.glFramebufferTexture2D(36160, 36064, 3553, this.colorTexture, 0);
        fboStatus = GL30.glCheckFramebufferStatus(36160);
        if (fboStatus != 36053) {
            return;
        }
        GL30.glBindRenderbuffer(36161, this.window.MultisampledFbo());
        GL30.glBindFramebuffer(36160, this.window.MultisampledFbo());
    }

    void ResizeFBOs() {
        GL30.glDeleteRenderbuffers(this.multisampledDepthRenderBuffer);
        GL30.glDeleteRenderbuffers(this.multisampledColorRenderBuffer);
        GL30.glDeleteFramebuffers(this.multisampledFbo);
        GL11.glDeleteTextures(this.colorTexture);
        GL30.glDeleteFramebuffers(this.fbo);
        this.CreateFBOs();
    }
}

