/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.struc;

public class Version {
    private int major;
    private int minor;
    private int patch;
    private int build = 0;

    public Version(String v) {
        String[] sections = v.split("\\.");
        this.major = Integer.parseInt(sections[0]);
        this.minor = Integer.parseInt(sections[1]);
        this.patch = Integer.parseInt(sections[2]);
        if (sections.length > 3) {
            this.build = Integer.parseInt(sections[3]);
        }
    }

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public Version(int major, int minor, int patch, int build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.build = build;
    }

    public String toString() {
        String text = this.major + "." + this.minor + "." + this.patch + "." + this.build;
        return text;
    }

    public String DisplayName() {
        String text = String.valueOf(this.major) + "." + String.valueOf(this.minor) + "." + String.valueOf(this.patch);
        if (this.build > 0) {
            text = text + " build " + this.build;
        }
        return text;
    }

    public int IMajor() {
        return this.major;
    }

    public int IMinor() {
        return this.minor;
    }

    public int IPatch() {
        return Integer.parseInt(String.valueOf(this.patch).replace(".", ""));
    }

    public float Patch() {
        return this.patch;
    }

    public boolean OlderThan(Version version) {
        if (this.major < version.major) {
            return false;
        }
        if (this.major > version.major) {
            return true;
        }
        if (this.minor < version.minor) {
            return false;
        }
        if (this.minor > version.minor) {
            return true;
        }
        if (this.patch < version.patch) {
            return false;
        }
        if (this.patch > version.patch) {
            return true;
        }
        if (this.build > 0 || version.build > 0) {
            int tbuild = this.build;
            int obuild = version.build;
            if (this.build <= 0) {
                tbuild = obuild + 1;
            }
            if (version.build <= 0) {
                obuild = tbuild + 1;
            }
            return this.build < version.build;
        }
        return false;
    }

    public boolean YoungerThan(Version version) {
        if (this.major > version.major) {
            return false;
        }
        if (this.major < version.major) {
            return true;
        }
        if (this.minor > version.minor) {
            return false;
        }
        if (this.minor < version.minor) {
            return true;
        }
        if (this.patch > version.patch) {
            return false;
        }
        if (this.patch < version.patch) {
            return true;
        }
        if (this.build > 0 || version.build > 0) {
            int tbuild = this.build;
            int obuild = version.build;
            if (this.build <= 0) {
                tbuild = obuild + 1;
            }
            if (version.build <= 0) {
                obuild = tbuild + 1;
            }
            return this.build < version.build;
        }
        return false;
    }

    public boolean OlderThanNoPatch(Version version) {
        if (this.major < version.minor) {
            return false;
        }
        if (this.major > version.minor) {
            return true;
        }
        if (this.minor < version.minor) {
            return false;
        }
        return this.minor > version.minor;
    }

    public boolean YoungerThanNoPatch(Version version) {
        if (this.major > version.minor) {
            return false;
        }
        if (this.major < version.minor) {
            return true;
        }
        if (this.minor > version.minor) {
            return false;
        }
        return this.minor < version.minor;
    }
}

