/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.texture;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.LotusDebug;
import com.arizotaz.lotus.texture.Texture;
import com.arizotaz.lotus.utils.FileDownload;
import com.arizotaz.lotus.utils.Fs;
import com.arizotaz.lotus.window.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;

public class TextureEngine {
    private Lotus lotus;
    private Window window;
    private static boolean showLoadingTexture = false;
    private static int textureIdleTime = 30000;
    private static int urlCacheTime = 0x6DDD00;
    private static boolean shouldExportTextures = false;
    private static File fileCache;
    int loadingQueueThread = -1;
    private volatile ArrayList<Texture> glLoadTexture = new ArrayList();
    private volatile ArrayList<String> queueIDs = new ArrayList();
    private volatile ArrayList<LoadEntry> loadQueue = new ArrayList();
    private Map<String, Texture> textures = new HashMap<String, Texture>();
    private static HashMap<String, LoadEntry> globalTexturesList;

    public static boolean ShowLoadingIndicator() {
        return showLoadingTexture;
    }

    public static void ShouldShowLoadingIndicator(boolean val) {
        showLoadingTexture = val;
    }

    public static void NetTextureCacheTime(int seconds) {
        urlCacheTime = seconds * 1000;
    }

    public static void ShouldExportTextures(boolean val) {
        shouldExportTextures = val;
    }

    public static void SetTextureCacheLocation(File file) {
        fileCache = file;
    }

    public static File GetTextureCacheLocation() {
        return fileCache;
    }

    public TextureEngine(final Lotus lotus, final Window window) {
        LotusDebug.Log("[TEXTUREENGINE] Created texure engine for window:" + window.identifier);
        this.lotus = lotus;
        this.window = window;
        LotusDebug.Log("[TEXTUREENGINE] Loading required textures");
        LotusDebug.Log("[TEXTUREENGINE] INITED");
        this.loadingQueueThread = lotus.ThreadManager().Create(Lotus.singleton.ThreadManager().GetName(Lotus.singleton.ProcessManager().GetProcessByID(window.ParentProcessID()).ThreadID()) + " - Texture Engine Loading Thread", new Thread(new Runnable(){
            final /* synthetic */ TextureEngine this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                while (Lotus.singleton.Running() && lotus.ProcessManager().ProcessAlive(window.ParentProcessID())) {
                    this.this$0.ProcessQueue();
                    if (this.this$0.loadQueue.size() != 0) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }), false, true);
        lotus.ThreadManager().Start(this.loadingQueueThread);
    }

    public void Update() {
        if (this.textures.size() > 1048) {
            Lotus.singleton.Exit(10940301);
        }
        if (this.GetTexture("engine.missing") == null) {
            this.LoadFromGlobalList("engine.missing");
        }
        if (this.GetTexture("engine.loading") == null) {
            this.LoadFromGlobalList("engine.loading");
        }
        if (this.glLoadTexture.size() > 0) {
            Texture tex = this.glLoadTexture.get(0);
            tex.GLGen(tex.PixelBuffer(), tex.Width(), tex.Height(), tex.Filter());
            this.textures.put(tex.ID(), tex);
            this.glLoadTexture.remove(0);
        }
        ArrayList<String> removeList = new ArrayList<String>();
        try {
            for (Map.Entry<String, Texture> t : this.textures.entrySet()) {
                Texture tex = t.getValue();
                if (tex.Persistent() || tex.LastUsed() + (long)textureIdleTime >= System.currentTimeMillis() || !this.window.RenderedOnLastCycle()) continue;
                removeList.add(t.getKey());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        for (int i = 0; i < removeList.size(); ++i) {
            this.textures.get(removeList.get(i)).Destroy();
            this.textures.remove(removeList.get(i));
        }
    }

    public String[] LoadedTextureKeyList() {
        Object[] names = new String[this.textures.size()];
        Arrays.fill(names, "engine.missing");
        try {
            int i = 0;
            for (Map.Entry<String, Texture> me : this.textures.entrySet()) {
                names[i] = me.getKey();
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return names;
    }

    public Texture GetTexture(String textureID) {
        return this.textures.get(textureID);
    }

    public void DestroyTexture(String texID) {
        if (this.textures.get(texID) != null) {
            this.textures.get(texID).Destroy();
            this.textures.remove(texID);
        }
    }

    public boolean TexturesLoading() {
        return this.loadQueue.size() > 0 | this.glLoadTexture.size() > 0 | this.queueIDs.size() > 0;
    }

    public void ProcessQueue() {
        if (this.loadQueue.size() > 0) {
            block3: {
                LoadEntry le = this.loadQueue.get(0);
                try {
                    Texture tex = new Texture(le.id);
                    tex.Init(le.fileLocation, le.outsideJar, le.filter);
                    tex.SetPersistent(le.persistent);
                    this.glLoadTexture.add(tex);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    globalTexturesList.remove(le.id);
                    if (this.textures.get(le.id) == null) break block3;
                    this.textures.remove(le.id);
                }
            }
            this.loadQueue.remove(0);
            this.queueIDs.remove(0);
        }
    }

    public boolean LoadFromGlobalList(String id) {
        if (TextureEngine.InGlobalList(id)) {
            LoadEntry le = globalTexturesList.get(id);
            boolean alreadyInQueue = this.queueIDs.contains(le.id);
            if (!alreadyInQueue) {
                this.queueIDs.add(le.id);
                this.loadQueue.add(new LoadEntry(le.id, le.fileLocation, le.outsideJar, le.filter, le.persistent));
            }
            return true;
        }
        return false;
    }

    public static void AddToGlobalList(String id, String fileLocation) {
        TextureEngine.AddToGlobalList(id, fileLocation, false, false);
    }

    public static void AddToGlobalList(String id, String fileLocation, boolean filter) {
        TextureEngine.AddToGlobalList(id, fileLocation, false, filter);
    }

    public static void AddToGlobalList(String id, String fileLocation, boolean outsideJar, boolean filter) {
        TextureEngine.AddToGlobalList(id, fileLocation, outsideJar, filter, false);
    }

    public static void AddToGlobalList(String id, String fileLocation, boolean outsideJar, boolean filter, boolean persistent) {
        if (fileCache == null) {
            fileCache = Lotus.singleton.FileLocations().TextureCache();
        }
        LotusDebug.Log("[TEXTUREENGINE] Adding Load Entry for " + id);
        if (shouldExportTextures && !outsideJar) {
            File f = new File(fileCache.getAbsolutePath() + "/" + fileLocation.replaceAll("/", "."));
            if (!f.exists()) {
                Fs.ExportIOResource(fileLocation, f.getAbsolutePath());
            }
            fileLocation = f.getAbsolutePath();
            outsideJar = true;
        }
        globalTexturesList.put(id, new LoadEntry(id, fileLocation, outsideJar, filter, persistent));
    }

    public static void AddURLToGlobalList(final String id, final String url, final boolean filter) {
        if (fileCache == null) {
            fileCache = Lotus.singleton.FileLocations().TextureCache();
        }
        final File textureFile = new File(String.valueOf(fileCache.getAbsoluteFile()) + "/tex_" + id);
        final File tmpTextureFile = new File(String.valueOf(fileCache.getAbsoluteFile()) + "/tex_" + id + ".download");
        final File timeFile = new File(String.valueOf(fileCache.getAbsoluteFile()) + "/tex_" + id + ".cache");
        long time = 0L;
        try {
            if (timeFile.exists()) {
                time = Long.parseLong(Fs.ReadText(timeFile));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (System.currentTimeMillis() < time + (long)urlCacheTime) {
            TextureEngine.AddToGlobalList(id, textureFile.getAbsolutePath(), true, filter);
        } else {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            LotusDebug.Log("[TEXTUREENGINE] Downloading URL Texture(" + url + ") for " + id);
                            new FileDownload(url, textureFile, tmpTextureFile).Start();
                            TextureEngine.AddToGlobalList(id, textureFile.getAbsolutePath(), true, filter);
                            Fs.WriteText(timeFile, String.valueOf(System.currentTimeMillis()));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            if (!textureFile.exists()) break block2;
                            TextureEngine.AddToGlobalList(id, textureFile.getAbsolutePath(), true, filter);
                        }
                    }
                }
            });
            t.start();
        }
    }

    public static void RemoveFromGlobalList(String textureMapID) {
        LotusDebug.Log("[TEXTUREENGINE] Removed " + textureMapID + " from global list");
        globalTexturesList.remove(textureMapID);
    }

    public static boolean InGlobalList(String id) {
        return globalTexturesList.containsKey(id);
    }

    public static String[] GlobalListKeys() {
        int n = globalTexturesList.keySet().size();
        String[] arr = new String[n];
        System.arraycopy(globalTexturesList.keySet().toArray(), 0, arr, 0, n);
        return arr;
    }

    public static void GlobalUpdate() {
        ArrayList<String> removeFromGlobalList = new ArrayList<String>();
        try {
            for (Map.Entry<String, LoadEntry> listEntry : globalTexturesList.entrySet()) {
                File f;
                LoadEntry entry = listEntry.getValue();
                if (!entry.outsideJar || (f = new File(entry.fileLocation)).exists()) continue;
                removeFromGlobalList.add(listEntry.getKey());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        for (int i = 0; i < removeFromGlobalList.size(); ++i) {
            globalTexturesList.remove(removeFromGlobalList.get(i));
        }
    }

    static {
        globalTexturesList = new HashMap();
    }

    private static class LoadEntry {
        String id;
        String fileLocation;
        boolean outsideJar;
        boolean filter;
        boolean persistent;

        private LoadEntry(String id, String fileLocation, boolean outsideJar, boolean filter, boolean persistent) {
            this.id = id;
            this.fileLocation = fileLocation;
            this.outsideJar = outsideJar;
            this.filter = filter;
            this.persistent = persistent;
        }

        public String ID() {
            return this.id;
        }

        private String FileLocation() {
            return this.fileLocation;
        }

        private boolean OutsideJar() {
            return this.outsideJar;
        }

        private boolean Filter() {
            return this.filter;
        }

        private boolean Persistent() {
            return this.persistent;
        }
    }
}

