/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.theme.windows98.Demo;

import com.arizotaz.lotus.ApplicationInfo;
import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.Text;
import com.arizotaz.lotus.struc.Process;
import com.arizotaz.lotus.struc.Vector4;
import com.arizotaz.lotus.struc.Version;
import com.arizotaz.lotus.theme.windows98.Windows98Checkbox;
import com.arizotaz.lotus.theme.windows98.Windows98WindowTheme;
import com.arizotaz.lotus.ui.elements.Checkbox;
import com.arizotaz.lotus.ui.elements.DropDown;
import com.arizotaz.lotus.ui.elements.Element;
import com.arizotaz.lotus.ui.elements.ElementRenderer;
import com.arizotaz.lotus.ui.elements.Panel;
import com.arizotaz.lotus.ui.elements.TextDisplay;
import com.arizotaz.lotus.window.Window;

public class Demo
extends Process {
    Window window;
    ElementRenderer elr;
    DropDown dropDown;
    Checkbox cb;
    boolean value = true;

    @Override
    public void Start() {
        this.window = Lotus.singleton.WindowManager().GetWindow(Lotus.singleton.WindowManager().CreateWindow("Demo", 1280, 720, this.ID()));
        this.window.Init();
        this.window.SetTheme(new Windows98WindowTheme(this.window));
        this.window.Process();
        this.window.Render(true);
        this.elr = new ElementRenderer();
        this.dropDown = Element.DropDown();
        this.dropDown.AddField("Test");
        this.dropDown.AddField("Test1");
        this.dropDown.AddField("Test2");
        this.cb = new Windows98Checkbox();
        this.window.IdleFps(60);
        this.window.IdleFps(30);
    }

    @Override
    public void Update() {
        Element.Reset();
        this.window.Process();
        this.window.TextureEngine().Update();
        this.CreatePage();
        this.elr.Update();
        this.elr.Interact();
        this.elr.Render();
        if (this.cb.Clicked()) {
            this.value = !this.value;
        }
        this.window.Render(this.elr.HasChanged());
        if (this.window.WantsToClose()) {
            this.QuitProcess();
        }
    }

    @Override
    public void Exit() {
        this.window.CleanUp();
    }

    public void CreatePage() {
        this.elr.ClearCycle();
        this.elr.AddElement(new Panel(0.0f, 0.0f, this.window.CanvasWidth(), this.window.CanvasHeight(), 0.0f, this.window.GetTheme().Background()));
        this.elr.AddElement(new Panel(-this.window.CanvasWidth() + 100.0f * this.window.RenderScale(), 0.0f, 200.0f * this.window.RenderScale(), this.window.CanvasHeight(), 0.0f, this.window.GetTheme().PrimaryColor_Dark()));
        float boxSize = 0.0f;
        this.DrawGroup(this.elr, 0, boxSize * 2.0f, boxSize, this.window.GetTheme().PrimaryColor_Light(), this.window.GetTheme().PrimaryColor_Dim(), this.window.GetTheme().PrimaryColor_Dark());
        this.DrawGroup(this.elr, 0, boxSize, boxSize, this.window.GetTheme().SecondaryColor_Light(), this.window.GetTheme().SecondaryColor_Dim(), this.window.GetTheme().SecondaryColor_Dark());
        this.DrawGroup(this.elr, 0, 0.0f, boxSize, this.window.GetTheme().TertiaryColor_Light(), this.window.GetTheme().TertiaryColor_Dim(), this.window.GetTheme().TertiaryColor_Dark());
        this.DrawGroup(this.elr, 0, -boxSize, boxSize, this.window.GetTheme().QuaternaryColor_Light(), this.window.GetTheme().QuaternaryColor_Dim(), this.window.GetTheme().QuaternaryColor_Dark());
        this.DrawGroup(this.elr, 0, -boxSize * 2.0f, boxSize, this.window.GetTheme().QuinaryColor_Light(), this.window.GetTheme().QuinaryColor_Dim(), this.window.GetTheme().QuinaryColor_Dark());
        Text text = new Text("W: " + this.window.Width() + "\n" + "H: " + this.window.Height() + "\n" + "FPS: " + this.window.FPS_AVERAGE());
        text.Align(0, 0);
        text.FontSize(18.0f * this.window.RenderScale());
        this.elr.AddElement(new TextDisplay(text, -this.window.CanvasWidth() / 2.0f, this.window.CanvasHeight() / 2.0f));
        this.cb.Set(this.value, "Test Box", 0.0f, 0.0f, 30.0f, 30.0f);
        this.elr.AddElement(this.cb);
    }

    private void DrawGroup(ElementRenderer elr, int x, float y, float boxSize, Vector4 light, Vector4 dim, Vector4 dark) {
        elr.AddElement(new Panel((float)x - boxSize, y, boxSize, boxSize, 0.0f, light));
        elr.AddElement(new Panel((float)x, y, boxSize, boxSize, 0.0f, dim));
        elr.AddElement(new Panel((float)x + boxSize, y, boxSize, boxSize, 0.0f, dark));
    }

    public static void main(String[] args) {
        Lotus lotus = new Lotus(args);
        lotus.Config(new ApplicationInfo("windows98demo", new Version(1, 1, 1), "Windows 98 Demo", null));
        lotus.Setup();
        lotus.Init();
        lotus.AddProcess(new Demo());
        lotus.Start();
    }
}

