/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.theme.windows98;

import com.arizotaz.lotus.ui.elements.Clickable;

public class HorizontalDragBar
extends Clickable {
    public int startX = 0;
    public int startY = 0;
    public int moveByX = 0;
    public int moveByY = 0;
    public float oppositeSideStartX = 0.0f;
    public float currentSideStartX = 0.0f;
    public float winwidth = 0.0f;
    public boolean drag = false;
    private boolean isRightSide = false;

    public HorizontalDragBar(boolean isRightSide) {
        this.changeCursorTo = "resizex";
        this.isRightSide = isRightSide;
        this.changeCursor = true;
    }

    @Override
    public void Interact() {
        super.Interact();
        if (!this.window.Maximized() && this.down && !this.drag) {
            this.drag = true;
            this.startX = (int)this.mouse.rawx();
            this.startY = (int)this.mouse.rawy();
            if (this.isRightSide) {
                this.oppositeSideStartX = (float)this.window.Position().x();
                this.currentSideStartX = (float)(this.window.Position().x() + (double)this.window.Width());
            } else {
                this.oppositeSideStartX = (float)(this.window.Position().x() + (double)this.window.Width());
                this.currentSideStartX = (float)this.window.Position().x();
                this.winwidth = this.window.Width();
            }
        }
        if (this.drag) {
            if (!this.mouse.LeftDown()) {
                this.drag = false;
            }
            this.moveByX = (int)(this.mouse.rawx() - (double)this.startX);
            this.moveByY = -((int)(this.mouse.rawy() - (double)this.startY));
            float w = 0.0f;
            if (this.isRightSide) {
                w = this.currentSideStartX - this.oppositeSideStartX + (float)this.moveByX;
                int x = Math.round(this.oppositeSideStartX + w / 2.0f);
                this.window.SetPosition(Math.round((float)x - w / 2.0f), this.window.Position().IntY());
                this.window.SetWindowSize(Math.round(w), Math.round(this.window.Height()));
            } else {
                w = this.oppositeSideStartX - this.currentSideStartX;
                int x = Math.round(this.oppositeSideStartX - this.window.Width() - (w -= (float)this.moveByX) / 2.0f);
                this.window.SetPosition(Math.round((float)x + w / 2.0f), this.window.Position().IntY());
                this.window.SetWindowSize(Math.round(w), Math.round(this.window.Height()));
            }
        }
    }

    @Override
    public void Render() {
    }
}

