/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.ui;

import com.arizotaz.lotus.ApplicationInfo;
import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.managers.WindowManager;
import com.arizotaz.lotus.struc.Process;
import com.arizotaz.lotus.struc.Version;
import com.arizotaz.lotus.ui.elements.Button;
import com.arizotaz.lotus.ui.elements.DropDown;
import com.arizotaz.lotus.ui.elements.Element;
import com.arizotaz.lotus.ui.elements.ElementRenderer;
import com.arizotaz.lotus.ui.elements.Panel;
import com.arizotaz.lotus.window.Window;

public class Demo
extends Process {
    private Window window;
    private ElementRenderer elr;
    private DropDown dropDown;
    private Button quit;

    @Override
    public void Start() {
        WindowManager wm = Lotus.singleton.WindowManager();
        this.window = wm.GetWindow(wm.CreateWindow(Lotus.singleton.AppInfo().Name(), 940, 530, this.ID()));
        this.window.Init();
        this.window.Render(true);
        this.elr = new ElementRenderer();
        this.window.SetWindowSize(1280, 720);
        Element.CreateWindowParms();
    }

    @Override
    public void Update() {
        Element.Reset();
        this.window.TextureEngine().Update();
        this.window.Process();
        if (this.window.SizeChanged() || this.window.ThemeChanged()) {
            this.CreateElements();
            this.CreatePage();
        }
        this.elr.Update();
        this.elr.Interact();
        this.elr.Render();
        this.window.Render(this.elr.HasChanged());
        if (this.window.WantsToClose()) {
            this.QuitProcess();
        }
    }

    @Override
    public void Exit() {
        this.window.CleanUp();
    }

    public void CreateElements() {
        this.dropDown = new DropDown();
        this.quit = Element.Button();
    }

    public void CreatePage() {
        this.elr.AddElement(new Panel(0.0f, 50.0f, this.window.CanvasWidth(), this.window.CanvasHeight(), 0.0f, this.window.GetTheme().Background()));
        this.dropDown.Set(0.0f, 0.0f, 200.0f, 25.0f);
        this.dropDown.AddField("tmp");
        this.dropDown.AddField("tmp1");
        this.dropDown.AddField("tmp2");
        this.dropDown.AddField("tmp3");
        this.quit.Set(0.0f, -50.0f, 200.0f, 30.0f);
        this.quit.SetTextColor(0, 255, 0);
        this.elr.AddElement(this.quit);
        this.elr.AddElement(this.dropDown);
    }

    public static void main(String[] args) {
        Lotus lotus = new Lotus(args, Demo.class.getName());
        lotus.Config(new ApplicationInfo("com.arizotaz.lotus.ui", new Version("1.0.0"), "Lotus IU Developmental Demo", null));
        lotus.Setup();
        lotus.Init();
        lotus.AddProcess(new Demo());
        lotus.Start();
    }
}

