/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.ui.elements;

import com.arizotaz.lotus.Text;
import com.arizotaz.lotus.struc.Vector2;
import com.arizotaz.lotus.struc.Vector3;
import com.arizotaz.lotus.struc.Vector4;
import com.arizotaz.lotus.ui.elements.Button;
import com.arizotaz.lotus.ui.elements.ButtonEventCallBack;
import com.arizotaz.lotus.ui.elements.Clickable;
import com.arizotaz.lotus.ui.elements.DropDownButton;
import com.arizotaz.lotus.ui.elements.Element;

public class ActionDropDown
extends Clickable {
    protected String text = "Button";
    protected String font = "default";
    protected Vector4 buttonColor = new Vector4(255.0, 255.0, 255.0, 255.0);
    protected Vector4 hoverColor = new Vector4(200.0, 200.0, 200.0, 200.0);
    protected Vector4 textColor = new Vector4(0.0, 0.0, 0.0, 255.0);
    protected float panelWidth;
    protected float panelHeight;
    protected Button buttonObj = new DropDownButton();
    protected Button[] buttons = new Button[0];
    protected String[] buttonTexts = new String[0];
    protected ButtonEventCallBack[] callBack = new ButtonEventCallBack[0];
    protected float buttonHeight = 0.0f;
    protected int showDrop = 0;

    public void Set(String text, float x, float y, float width, float height) {
        this.Set(text, x, y, width, height, 20.0f);
    }

    public void Set(String text, float x, float y, float width, float height, float buttonHeight) {
        this.text = text;
        this.buttonHeight = buttonHeight;
        this.Set(x, y, width, height);
    }

    public void AddField(String text) {
        this.AddField(text, null);
    }

    public void AddField(String text, ButtonEventCallBack cb) {
        try {
            Button[] nb = new Button[this.buttons.length + 1];
            int i = 0;
            while (i < this.buttons.length) {
                nb[i] = this.buttons[i];
                ++i;
            }
            ButtonEventCallBack[] nbc = new ButtonEventCallBack[this.callBack.length + 1];
            int i2 = 0;
            while (i2 < this.callBack.length) {
                nbc[i2] = this.callBack[i2];
                ++i2;
            }
            String[] nbt = new String[this.buttonTexts.length + 1];
            int i3 = 0;
            while (i3 < this.buttonTexts.length) {
                nbt[i3] = this.buttonTexts[i3];
                ++i3;
            }
            nb[nb.length - 1] = (Button)this.buttonObj.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            nbc[nbc.length - 1] = cb;
            nbt[nbt.length - 1] = text;
            this.buttons = nb;
            this.callBack = nbc;
            this.buttonTexts = nbt;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void Update() {
        this.buttonHeight = 20.0f * this.window.RenderScale();
        this.panelWidth = this.width;
        this.panelHeight = this.buttonHeight * (float)this.buttons.length;
        if (this.showDrop > 0) {
            float yIndex = this.y - this.height / 2.0f - this.buttonHeight / 2.0f;
            int i = 0;
            while (i < this.buttons.length) {
                Button button = this.buttons[i];
                button.Set(this.buttonTexts[i], this.x, yIndex, this.width, this.buttonHeight);
                button.Update();
                yIndex -= this.buttonHeight;
                ++i;
            }
        }
    }

    @Override
    public void Interact() {
        Button button;
        int i;
        this.hover = false;
        this.down = false;
        this.clicked = false;
        if (this.showDrop > 0) {
            --this.showDrop;
            i = 0;
            while (i < this.buttons.length) {
                button = this.buttons[i];
                button.Interact();
                if (button.hover) {
                    this.showDrop = 2;
                }
                if (button.Clicked()) {
                    this.showDrop = 0;
                    if (this.callBack[i] != null) {
                        this.callBack[i].CallBack(button);
                    }
                }
                ++i;
            }
        }
        if (!Element.ShouldStopInteract()) {
            if (this.MouseInBounds(this.x, this.y, this.width, this.height)) {
                this.hover = true;
                this.showDrop = 2;
                if (this.changeCursor) {
                    this.mouse.SetCursor(this.changeCursorTo);
                }
                if (this.mouse.LeftClicked()) {
                    this.clicked = true;
                }
                if (this.mouse.LeftDown()) {
                    this.down = true;
                }
                Element.StopInteract();
            }
            if (this.showDrop > 0 && this.MouseInBounds(this.x, this.y - this.height / 2.0f - this.panelHeight / 2.0f, this.panelWidth, this.panelHeight)) {
                this.hover = true;
                this.showDrop = 2;
                if (this.changeCursor) {
                    this.mouse.SetCursor(this.changeCursorTo);
                }
                Element.StopInteract();
            }
        }
        this.objectIdentifier = this.BasicObjectIdentifier() + "_c" + this.clicked + "_h" + this.hover + "_sd" + this.showDrop;
        if (this.showDrop > 0) {
            i = 0;
            while (i < this.buttons.length) {
                button = this.buttons[i];
                this.objectIdentifier = String.valueOf(this.objectIdentifier) + (button.IsHovering() ? 1 : 0);
                ++i;
            }
        }
    }

    @Override
    public void Render() {
        float padding = this.window.RenderScale() * (this.height / 15.0f);
        if (!this.IsHovering()) {
            this.window.RenderObjects().SetColor(this.buttonColor.IntX() - 50, this.buttonColor.IntY() - 50, this.buttonColor.IntZ() - 50, this.buttonColor.IntW());
        } else {
            this.window.RenderObjects().SetColor(this.hoverColor.IntX() - 120, this.hoverColor.IntY() - 120, this.hoverColor.IntZ() - 120, this.hoverColor.IntW());
        }
        this.window.RenderObjects().DrawRoundedRect(this.x, this.y, 0.0, this.width, this.height, this.height / 6.0f, 3);
        if (!this.IsHovering()) {
            this.window.RenderObjects().SetColor(this.buttonColor.IntX(), this.buttonColor.IntY(), this.buttonColor.IntZ(), this.buttonColor.IntW());
        } else {
            this.window.RenderObjects().SetColor(this.hoverColor.IntX(), this.hoverColor.IntY(), this.hoverColor.IntZ(), this.hoverColor.IntW());
        }
        this.window.RenderObjects().DrawRoundedRect(this.x, this.y, 0.0, this.width - padding, this.height - padding, this.height / 8.0f, 3);
        Text text = new Text(this.text);
        text.FontSize(this.height - this.height / 6.0f - padding);
        text.Align(1, 1);
        text.SetFont(this.font);
        text.Color(this.textColor.IntX(), this.textColor.IntY(), this.textColor.IntZ(), this.textColor.IntW());
        text.Render(this.x, this.y);
        if (this.showDrop > 0) {
            this.window.RenderObjects().SetColor(245.0f);
            this.window.RenderObjects().DrawRect(this.x, this.y - this.height / 2.0f - this.panelHeight / 2.0f, this.panelWidth, this.panelHeight, 0.0f);
            int i = 0;
            while (i < this.buttons.length) {
                Button button = this.buttons[i];
                button.Render();
                ++i;
            }
        }
    }

    public void SetFont(String font) {
        this.font = font;
    }

    public void SetTextColor(Vector4 c) {
        this.SetTextColor(c.IntX(), c.IntY(), c.IntZ(), c.IntW());
    }

    public void SetTextColor(Vector3 c) {
        this.SetTextColor(c.IntX(), c.IntY(), c.IntZ());
    }

    public void SetTextColor(Vector2 c) {
        this.SetTextColor(c.IntX(), c.IntY());
    }

    public void SetTextColor(int l) {
        this.SetTextColor(l, 255);
    }

    public void SetTextColor(int l, int a) {
        this.SetTextColor(l, l, l, a);
    }

    public void SetTextColor(int r, int g, int b) {
        this.SetTextColor(r, g, b, 255);
    }

    public void SetTextColor(int r, int g, int b, int a) {
        this.textColor = new Vector4(r, g, b, a);
    }
}

