/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.ui.elements;

import com.arizotaz.lotus.Text;
import com.arizotaz.lotus.texture.TextureEngine;
import com.arizotaz.lotus.ui.elements.Button;

public class Checkbox
extends Button {
    protected boolean value = false;
    protected float twidth = 1.0E8f;

    @Override
    public void Interact() {
        super.Interact();
        this.objectIdentifier = this.BasicObjectIdentifier() + "checked_" + this.value + "t_" + this.text;
    }

    @Override
    public void Render() {
        if (!TextureEngine.InGlobalList("checkbox_checked")) {
            TextureEngine.AddToGlobalList("checkbox_checked", "com/arizotaz/lotus/ui/resources/checkbox_checked.png");
        }
        if (!TextureEngine.InGlobalList("checkbox_unchecked")) {
            TextureEngine.AddToGlobalList("checkbox_unchecked", "com/arizotaz/lotus/ui/resources/checkbox_unchecked.png");
        }
        Text textObj = new Text(this.text);
        textObj.MaxWidth(this.twidth - this.width - this.window.RenderScale() * 5.0f);
        textObj.Align(0, 1);
        textObj.Color(this.textColor.IntX(), this.textColor.IntY(), this.textColor.IntZ(), this.textColor.IntW());
        textObj.FontSize(this.height - this.height / 8.0f);
        textObj.Calculate();
        if (this.value) {
            this.window.RenderObjects().SetColor(120.0f);
        } else {
            this.window.RenderObjects().SetColor(80.0f);
        }
        this.window.RenderObjects().DrawRect(this.x, this.y, this.width, this.width, 0.0f);
        this.window.RenderObjects().SetColor(50.0f);
        this.window.RenderObjects().DrawRect(this.x, this.y, this.width - this.width / 10.0f, this.width - this.width / 10.0f, 0.0f);
        this.window.RenderObjects().SetColor(255.0f);
        if (this.value) {
            this.window.RenderObjects().DrawImage("checkbox_checked", this.x, this.y, this.width - this.width / 8.0f, this.width - this.width / 8.0f, 0.0f);
        } else {
            this.window.RenderObjects().DrawImage("checkbox_unchecked", this.x, this.y, this.width - this.width / 8.0f, this.width - this.width / 8.0f, 0.0f);
        }
        if (this.hover) {
            this.window.RenderObjects().SetColor(255.0f, 255.0f, 255.0f, 100.0f);
            this.window.RenderObjects().DrawRect(this.x, this.y, this.width - this.width / 8.0f, this.width - this.width / 8.0f, 0.0f);
        }
        textObj.Render(this.x + this.width / 2.0f + this.window.RenderScale() * 5.0f, this.y);
    }

    public void SetTotalWidth(float width) {
        this.twidth = width;
    }

    public void Set(boolean val, float x, float y, float width, float height) {
        this.Set(val, this.text, x, y, width, height);
    }

    public void Set(boolean val, String text, float x, float y, float width, float height) {
        this.value = val;
        this.Set(text, x, y, width, height);
    }

    @Override
    public void Set(String text, float x, float y, float width, float height) {
        this.text = text;
        this.Set(x, y, width, height);
    }

    public void SetValue(boolean val) {
        this.value = val;
    }

    public boolean GetValue() {
        return this.value;
    }
}

