/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.ui.elements;

import com.arizotaz.lotus.struc.Vector2;
import com.arizotaz.lotus.ui.elements.Element;
import com.arizotaz.lotus.window.Mouse;

public class Clickable
extends Element {
    protected Mouse mouse = this.window.Mouse();
    protected double interactX = 0.0;
    protected double interactY;
    protected boolean down = false;
    protected boolean hover = false;
    protected boolean clicked = false;
    protected boolean changeCursor = true;
    protected String changeCursorTo = "pointer";

    @Override
    public void Update() {
    }

    @Override
    public void Interact() {
        this.hover = false;
        this.down = false;
        this.clicked = false;
        if (!Element.ShouldStopInteract() && this.MouseInBounds(this.x, this.y, this.width, this.height)) {
            this.hover = true;
            if (this.changeCursor) {
                this.mouse.SetCursor(this.changeCursorTo);
            }
            if (this.mouse.LeftClicked()) {
                this.clicked = true;
            }
            if (this.mouse.LeftDown()) {
                this.down = true;
            }
            Element.StopInteract();
        }
        this.objectIdentifier = this.BasicObjectIdentifier() + "_c" + this.clicked + "_h" + this.hover + "_d" + this.down;
    }

    protected boolean MouseInBounds(float x, float y, float width, float height) {
        this.interactX = x;
        this.interactY = y;
        Vector2 t = new Vector2(this.window.Translate().x(), this.window.Translate().y());
        this.window.Translate().Set(0.0, 0.0);
        boolean value = this.mouse.x() < this.interactX + (double)(width / 2.0f) && this.mouse.x() > this.interactX - (double)(width / 2.0f) && this.mouse.y() > this.interactY - (double)(height / 2.0f) && this.mouse.y() < this.interactY + (double)(height / 2.0f);
        this.window.Translate().Set(t.x(), t.y());
        return value;
    }

    @Override
    public void Render() {
    }

    public boolean IsHovering() {
        return this.hover;
    }

    public boolean Clicked() {
        return this.clicked;
    }

    public boolean IsDown() {
        return this.down;
    }
}

