/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.ui.elements;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.ui.elements.ActionDropDown;
import com.arizotaz.lotus.ui.elements.Button;
import com.arizotaz.lotus.ui.elements.Checkbox;
import com.arizotaz.lotus.ui.elements.DropDown;
import com.arizotaz.lotus.ui.elements.ImageButton;
import com.arizotaz.lotus.ui.elements.InputField;
import com.arizotaz.lotus.window.Window;
import java.util.HashMap;

public abstract class Element {
    private static HashMap<Long, HashMap<String, Object>> windowSpecific = new HashMap();
    protected Window window = Lotus.singleton.WindowManager().GetCurrentWindow();
    protected float x = 0.0f;
    protected float y = 0.0f;
    protected float width = 0.0f;
    protected float height = 0.0f;
    protected float zHeight = 0.0f;
    protected double interactX = 0.0;
    protected double interactY;
    private boolean shouldUpdateScreen = false;
    protected String objectIdentifier = "";

    public static boolean ShouldStopInteract() {
        return (Boolean)windowSpecific.get(Lotus.singleton.WindowManager().GetCurrentWindow().window).get("stopInteract");
    }

    public static void StopInteract() {
        windowSpecific.get(Lotus.singleton.WindowManager().GetCurrentWindow().window).put("stopInteract", true);
    }

    public static void Reset() {
        Element.CreateWindowParms();
        windowSpecific.get(Lotus.singleton.WindowManager().GetCurrentWindow().window).put("stopInteract", false);
    }

    public static void CreateWindowParms() {
        if (windowSpecific.get(Lotus.singleton.WindowManager().GetCurrentWindow().window) == null) {
            HashMap<String, Object> vals = new HashMap<String, Object>();
            vals.put("stopInteract", false);
            vals.put("defaultButton", new Button());
            vals.put("defaultInput", new InputField());
            vals.put("defaultCheckbox", new Checkbox());
            vals.put("defaultDropDown", new DropDown());
            vals.put("defaultActionDropDown", new ActionDropDown());
            vals.put("defaultImageButton", new ImageButton());
            windowSpecific.put(Lotus.singleton.WindowManager().GetCurrentWindow().window, vals);
        }
    }

    public static void SetDefaultButton(Button button) {
        windowSpecific.get(Lotus.singleton.WindowManager().GetCurrentWindow().window).put("defaultButton", button);
    }

    public static void SetDefaultInput(InputField inputField) {
        windowSpecific.get(Lotus.singleton.WindowManager().GetCurrentWindow().window).put("defaultInput", inputField);
    }

    public static void SetDefaultCheckbox(Checkbox checkbox) {
        windowSpecific.get(Lotus.singleton.WindowManager().GetCurrentWindow().window).put("defaultCheckbox", checkbox);
    }

    public static void SetDefaultDropDown(DropDown dropDown) {
        windowSpecific.get(Lotus.singleton.WindowManager().GetCurrentWindow().window).put("defaultDropDown", dropDown);
    }

    public static void SetDefaultActionDropDown(ActionDropDown dropDown) {
        windowSpecific.get(Lotus.singleton.WindowManager().GetCurrentWindow().window).put("defaultActionDropDown", dropDown);
    }

    public static void SetDefaultImageButton(ImageButton imageButton) {
        windowSpecific.get(Lotus.singleton.WindowManager().GetCurrentWindow().window).put("defaultImageButton", imageButton);
    }

    public static Button Button() {
        try {
            return (Button)((Button)windowSpecific.get(Lotus.singleton.WindowManager().GetCurrentWindow().window).get("defaultButton")).getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static InputField InputField() {
        try {
            return (InputField)((InputField)windowSpecific.get(Lotus.singleton.WindowManager().GetCurrentWindow().window).get("defaultInput")).getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Checkbox Checkbox() {
        try {
            return (Checkbox)((Checkbox)windowSpecific.get(Lotus.singleton.WindowManager().GetCurrentWindow().window).get("defaultCheckbox")).getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DropDown DropDown() {
        try {
            return (DropDown)((DropDown)windowSpecific.get(Lotus.singleton.WindowManager().GetCurrentWindow().window).get("defaultDropDown")).getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ActionDropDown ActionDropDown() {
        try {
            return (ActionDropDown)((ActionDropDown)windowSpecific.get(Lotus.singleton.WindowManager().GetCurrentWindow().window).get("defaultActionDropDown")).getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ImageButton ImageButton() {
        try {
            return (ImageButton)((ImageButton)windowSpecific.get(Lotus.singleton.WindowManager().GetCurrentWindow().window).get("defaultImageButton")).getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void Set(float x, float y, float width, float height) {
        this.Set(x, y, width, height, 0.0f);
    }

    public void Set(float x, float y, float width, float height, float zHeight) {
        this.x = (float)((double)x + this.window.Translate().x());
        this.y = (float)((double)y + this.window.Translate().y());
        this.width = width;
        this.height = height;
        this.objectIdentifier = this.BasicObjectIdentifier();
    }

    public abstract void Update();

    public abstract void Interact();

    public abstract void Render();

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float Width() {
        return this.width;
    }

    public float Height() {
        return this.height;
    }

    public float zHeight() {
        return this.zHeight;
    }

    public boolean ShouldUpdateScreen() {
        return this.shouldUpdateScreen;
    }

    public void ForceScreenUpdate() {
        this.shouldUpdateScreen = true;
    }

    public void DoNotUpdateScreen() {
        this.shouldUpdateScreen = false;
    }

    protected String BasicObjectIdentifier() {
        return this.x + "_" + this.y + "_" + this.width + "_" + this.height;
    }

    public String ObjectIdentifier() {
        return this.objectIdentifier;
    }
}

