/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.ui.elements;

import com.arizotaz.lotus.struc.Vector2;
import com.arizotaz.lotus.struc.Vector3;
import com.arizotaz.lotus.struc.Vector4;
import com.arizotaz.lotus.ui.elements.Element;
import com.arizotaz.lotus.window.Mouse;

public class Image
extends Element {
    protected int r;
    protected int g;
    protected int b;
    protected int a;
    protected float rotation = 0.0f;
    protected boolean allowStretch = false;
    protected String image;
    protected Mouse mouse;

    public Image(String imageID, float x, float y, float width, float height, float rotation, int r, int g, int b, int a) {
        this.Set(imageID, x, y, width, height, rotation, r, g, b, a, false);
    }

    public Image(String imageID, float x, float y, float width, float height, float rotation, int r, int a) {
        this.Set(imageID, x, y, width, height, rotation, r, r, r, a, false);
    }

    public Image(String imageID, float x, float y, float width, float height, float rotation, int r, int g, int b) {
        this.Set(imageID, x, y, width, height, rotation, r, g, b, 255, false);
    }

    public Image(String imageID, float x, float y, float width, float height, float rotation, int r) {
        this.Set(imageID, x, y, width, height, rotation, r, r, r, 255, false);
    }

    public Image(String imageID, float x, float y, float width, float height, float rotation, int r, boolean allowStrech) {
        this.Set(imageID, x, y, width, height, rotation, r, r, r, 255, allowStrech);
    }

    public Image(String imageID, float x, float y, float width, float height, float rotation, int r, int a, boolean allowStrech) {
        this.Set(imageID, x, y, width, height, rotation, r, r, r, a, allowStrech);
    }

    public Image(String imageID, float x, float y, float width, float height, float rotation, int r, int g, int b, boolean allowStrech) {
        this.Set(imageID, x, y, width, height, rotation, r, g, b, 255, allowStrech);
    }

    public Image(String imageID, float x, float y, float width, float height, float rotation, int r, int g, int b, int a, boolean allowStrech) {
        this.Set(imageID, x, y, width, height, rotation, r, g, b, a, allowStrech);
    }

    public Image(String imageID, float x, float y, float width, float height, float rotation, Vector2 color, boolean allowStrech) {
        this.Set(imageID, x, y, width, height, rotation, color.IntX(), color.IntX(), color.IntX(), color.IntY(), allowStrech);
    }

    public Image(String imageID, float x, float y, float width, float height, float rotation, Vector3 color, boolean allowStrech) {
        this.Set(imageID, x, y, width, height, rotation, color.IntX(), color.IntY(), color.IntZ(), 255, allowStrech);
    }

    public Image(String imageID, float x, float y, float width, float height, float rotation, Vector4 color, boolean allowStrech) {
        this.Set(imageID, x, y, width, height, rotation, color.IntX(), color.IntY(), color.IntZ(), color.IntW(), allowStrech);
    }

    public Image(String imageID, float x, float y, float width, float height, float rotation, Vector2 color) {
        this.Set(imageID, x, y, width, height, rotation, color.IntX(), color.IntX(), color.IntX(), color.IntY(), false);
    }

    public Image(String imageID, float x, float y, float width, float height, float rotation, Vector3 color) {
        this.Set(imageID, x, y, width, height, rotation, color.IntX(), color.IntY(), color.IntZ(), 255, false);
    }

    public Image(String imageID, float x, float y, float width, float height, float rotation, Vector4 color) {
        this.Set(imageID, x, y, width, height, rotation, color.IntX(), color.IntY(), color.IntZ(), color.IntW(), false);
    }

    private void Set(String imageID, float x, float y, float width, float height, float rotation, int r, int g, int b, int a, boolean stretch) {
        this.mouse = this.window.Mouse();
        this.image = imageID;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.rotation = rotation;
        this.allowStretch = stretch;
        this.Set(x, y, width, height);
    }

    @Override
    public void Update() {
    }

    @Override
    public void Interact() {
        if (!Element.ShouldStopInteract() && this.mouse.x() < (double)(this.x + this.width / 2.0f) && this.mouse.x() > (double)(this.x - this.width / 2.0f) && this.mouse.y() > (double)(this.y - this.height / 2.0f) && this.mouse.y() < (double)(this.y + this.height / 2.0f)) {
            Element.StopInteract();
        }
        if (this.window.TextureEngine().GetTexture(this.image) == null || !this.window.TextureEngine().GetTexture(this.image).GLCreated()) {
            this.ForceScreenUpdate();
        }
        this.objectIdentifier = this.BasicObjectIdentifier() + "rot_" + this.rotation + "id_" + this.image;
    }

    @Override
    public void Render() {
        this.window.RenderObjects().SetColor(this.r, this.g, this.b, this.a);
        this.window.RenderObjects().DrawImage(this.image, this.x, this.y, this.width, this.height, this.rotation, this.allowStretch);
    }
}

