/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.ui.elements;

import com.arizotaz.lotus.Text;
import com.arizotaz.lotus.struc.Vector2;
import com.arizotaz.lotus.ui.elements.Clickable;

public class InputField
extends Clickable {
    protected String placeHolder = "";
    protected String value = "";
    protected String font = "default";
    protected boolean selected = false;

    public InputField() {
        this.changeCursorTo = "ibeam";
    }

    @Override
    public void Set(float x, float y, float width, float height) {
        super.Set(x, y, width, height);
    }

    @Override
    public void Interact() {
        super.Interact();
        Vector2 t = new Vector2(this.window.Translate().x(), this.window.Translate().y());
        this.window.Translate().Set(0.0, 0.0);
        if (this.clicked) {
            this.selected = true;
        }
        if (!(!this.mouse.LeftClicked() || this.mouse.x() < this.interactX + (double)(this.width / 2.0f) && this.mouse.x() > this.interactX - (double)(this.width / 2.0f) && this.mouse.y() > this.interactY - (double)(this.height / 2.0f) && this.mouse.y() < this.interactY + (double)(this.height / 2.0f))) {
            this.selected = false;
        }
        if (this.selected) {
            this.value = String.valueOf(this.value) + this.window.KeyboardTextInput().Value();
            if (this.window.KeyboardInput().IsPressed(261)) {
                this.selected = false;
            }
            if (this.value.length() > 0 && this.window.KeyboardInput().IsPressed(259)) {
                this.value = this.value.substring(0, this.value.length() - 1);
            }
        }
        this.objectIdentifier = this.BasicObjectIdentifier() + "l_" + this.value.length() + "s_" + this.selected;
        this.window.Translate().Set(t.x(), t.y());
    }

    @Override
    public void Render() {
        float padding = this.window.RenderScale() * (this.height / 6.0f);
        if (!this.selected) {
            this.window.RenderObjects().SetColor(240.0f);
        } else {
            this.window.RenderObjects().SetColor(100.0f);
        }
        this.window.RenderObjects().DrawRect(this.x, this.y, this.width, this.height, 0.0f);
        if (!this.selected) {
            this.window.RenderObjects().SetColor(100.0f);
        } else {
            this.window.RenderObjects().SetColor(240.0f);
        }
        this.window.RenderObjects().DrawRect(this.x + padding / 2.0f / 2.0f, this.y - padding / 2.0f / 2.0f, this.width - padding / 2.0f, this.height - padding / 2.0f, 0.0f);
        if (!this.selected) {
            this.window.RenderObjects().SetColor(255.0f);
        } else {
            this.window.RenderObjects().SetColor(192.0f);
        }
        this.window.RenderObjects().DrawRect(this.x, this.y, this.width - padding, this.height - padding, 0.0f);
        this.window.RenderObjects().SetColor(255.0f);
        this.window.RenderObjects().DrawRect(this.x, this.y, this.width - padding, this.height - padding, 0.0f);
        float fontSize = this.height - this.height / 6.0f - padding;
        Text text = new Text(this.value);
        if (this.value.length() <= 0) {
            text = new Text(this.placeHolder);
        }
        if (this.value.length() <= 0) {
            text.Color(150);
        }
        text.FontSize(fontSize);
        text.Align(0, 1);
        text.MaxWidth(this.width - padding * 2.0f);
        text.AllowWrap(false);
        text.SetSpaceWidth(0.5f);
        text.SetFont(this.font);
        text.Render(this.x - this.width / 2.0f + padding, this.y);
    }

    public void SetFont(String font) {
        this.font = font;
    }

    public String GetPlaceHolder() {
        return this.placeHolder;
    }

    public void SetPlaceHolder(String val) {
        this.placeHolder = val;
    }

    public String Value() {
        return this.value;
    }

    public String GetValue() {
        return this.Value();
    }

    public void SetValue(String val) {
        this.value = val;
    }
}

