/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.ui.elements;

import com.arizotaz.lotus.struc.Vector2;
import com.arizotaz.lotus.struc.Vector3;
import com.arizotaz.lotus.struc.Vector4;
import com.arizotaz.lotus.ui.elements.Element;
import com.arizotaz.lotus.window.Mouse;

public class Panel
extends Element {
    protected int r;
    protected int g;
    protected int b;
    protected int a;
    protected float rotation = 0.0f;
    protected Mouse mouse;
    protected boolean mouseInBounds = false;
    protected boolean hover = false;

    public Panel(float x, float y, float width, float height, float rotation, Vector4 color) {
        this.Set(x, y, width, height, rotation, color.IntX(), color.IntY(), color.IntZ(), color.IntW());
    }

    public Panel(float x, float y, float width, float height, float rotation, Vector3 color) {
        this.Set(x, y, width, height, rotation, color.IntX(), color.IntY(), color.IntZ(), 255);
    }

    public Panel(float x, float y, float width, float height, float rotation, Vector2 color) {
        this.Set(x, y, width, height, rotation, color.IntX(), color.IntX(), color.IntX(), color.IntY());
    }

    public Panel(float x, float y, float width, float height, float rotation, int r, int g, int b, int a) {
        this.Set(x, y, width, height, rotation, r, g, b, a);
    }

    public Panel(float x, float y, float width, float height, float rotation, int r, int a) {
        this.Set(x, y, width, height, rotation, r, r, r, a);
    }

    public Panel(float x, float y, float width, float height, float rotation, int r, int g, int b) {
        this.Set(x, y, width, height, rotation, r, g, b, 255);
    }

    public Panel(float x, float y, float width, float height, float rotation, int r) {
        this.Set(x, y, width, height, rotation, r, r, r, 255);
    }

    private void Set(float x, float y, float width, float height, float rotation, int r, int g, int b, int a) {
        this.mouse = this.window.Mouse();
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.rotation = rotation;
        this.Set(x, y, width, height);
        this.interactX = this.window.Translate().x() + (double)this.x;
        this.interactY = this.window.Translate().y() + (double)this.y;
        this.objectIdentifier = this.BasicObjectIdentifier() + "rot_" + this.rotation;
    }

    @Override
    public void Update() {
    }

    @Override
    public void Interact() {
        this.interactX = this.x;
        this.interactY = this.y;
        Vector2 t = new Vector2(this.window.Translate().x(), this.window.Translate().y());
        this.window.Translate().Set(0.0, 0.0);
        this.hover = false;
        this.mouseInBounds = false;
        if (!Element.ShouldStopInteract() && this.mouse.x() < this.interactX + (double)(this.width / 2.0f) && this.mouse.x() > this.interactX - (double)(this.width / 2.0f) && this.mouse.y() > this.interactY - (double)(this.height / 2.0f) && this.mouse.y() < this.interactY + (double)(this.height / 2.0f)) {
            this.hover = true;
            Element.StopInteract();
        }
        if (this.mouse.x() < this.interactX + (double)(this.width / 2.0f) && this.mouse.x() > this.interactX - (double)(this.width / 2.0f) && this.mouse.y() > this.interactY - (double)(this.height / 2.0f) && this.mouse.y() < this.interactY + (double)(this.height / 2.0f)) {
            this.mouseInBounds = true;
        }
        this.window.Translate().Set(t.x(), t.y());
    }

    @Override
    public void Render() {
        this.window.RenderObjects().SetColor(this.r, this.g, this.b, this.a);
        this.window.RenderObjects().DrawRect(this.x, this.y, this.width, this.height, this.rotation);
    }

    public boolean MouseInBounds() {
        return this.mouseInBounds;
    }

    public boolean Hover() {
        return this.hover;
    }
}

