/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.lwjgl.BufferUtils;

public class BufferUtilities {
    public static String loadResource(String fileName) throws Exception {
        String result;
        try (InputStream in = BufferUtilities.class.getResourceAsStream(fileName);
             Scanner scanner = new Scanner(in, StandardCharsets.UTF_8.name());){
            result = scanner.useDelimiter("\\A").next();
        }
        return result;
    }

    public static List<String> readAllLines(String fileName) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Class.forName(BufferUtilities.class.getName()).getResourceAsStream(fileName)));){
            String line;
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
        }
        return list;
    }

    public static int[] listIntToArray(List<Integer> list) {
        int[] result = list.stream().mapToInt(v -> v).toArray();
        return result;
    }

    public static float[] listToArray(List<Float> list) {
        int size = list != null ? list.size() : 0;
        float[] floatArr = new float[size];
        for (int i = 0; i < size; ++i) {
            floatArr[i] = list.get(i).floatValue();
        }
        return floatArr;
    }

    public static boolean existsResourceFile(String fileName) {
        boolean result;
        try (InputStream is = BufferUtilities.class.getResourceAsStream(fileName);){
            result = is != null;
        }
        catch (Exception excp) {
            result = false;
        }
        return result;
    }

    public static ByteBuffer ioResourceToByteBuffer(String resource, int bufferSize) throws IOException {
        ByteBuffer buffer;
        Path path = Paths.get(resource, new String[0]);
        if (Files.isReadable(path)) {
            try (SeekableByteChannel fc = Files.newByteChannel(path, new OpenOption[0]);){
                buffer = BufferUtils.createByteBuffer((int)fc.size() + 1);
                while (fc.read(buffer) != -1) {
                }
            }
        }
        try (InputStream source = BufferUtilities.class.getResourceAsStream(resource);
             ReadableByteChannel rbc = Channels.newChannel(source);){
            int bytes;
            buffer = BufferUtils.createByteBuffer(bufferSize);
            while ((bytes = rbc.read(buffer)) != -1) {
                if (buffer.remaining() != 0) continue;
                buffer = BufferUtilities.resizeBuffer(buffer, buffer.capacity() * 2);
            }
        }
        buffer.flip();
        return buffer;
    }

    public static ByteBuffer resizeBuffer(ByteBuffer buffer, int newCapacity) {
        ByteBuffer newBuffer = BufferUtils.createByteBuffer(newCapacity);
        buffer.flip();
        newBuffer.put(buffer);
        return newBuffer;
    }
}

