/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.utils;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.utils.Fs;
import com.arizotaz.lotus.utils.Tools;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

public class FileDownload {
    protected float totalSize = 100.0f;
    protected float downloadedBytes = 0.0f;
    protected float progress = 0.0f;
    protected File location;
    protected File tempFile;
    protected String url;
    protected boolean done = false;
    protected boolean useTempFile = true;
    protected final int BufferSize = 2048;
    private File macOSBundle = null;
    private File macOSInfo_plist = null;
    private String macOSDL = null;
    private String macOSDLID = null;

    public FileDownload(String url, File location) {
        this.tempFile = null;
        this.location = location.getAbsoluteFile();
        this.url = url;
    }

    public FileDownload(String url, File location, File tempFile) {
        this.tempFile = tempFile.getAbsoluteFile();
        this.location = location.getAbsoluteFile();
        this.url = url;
    }

    public void Start() throws IOException {
        try {
            this.Download(this.useTempFile);
            if (this.useTempFile) {
                this.MoveContent(this.tempFile, this.location);
            }
            this.done = true;
        }
        catch (Exception e) {
            if (this.tempFile != null && this.tempFile.exists()) {
                this.tempFile.delete();
            }
            throw e;
        }
    }

    public void UseTempFile(boolean use) {
        this.useTempFile = use;
    }

    protected void Download(boolean useTempFile) throws IOException {
        int numBytesRead;
        float fileSize;
        if (this.url.toLowerCase().startsWith("smb://")) {
            this.LocalFileDownload();
            return;
        }
        URL url = new URL(this.url);
        URLConnection con = url.openConnection();
        HttpURLConnection http = (HttpURLConnection)con;
        http.setRequestMethod("GET");
        http.setDoOutput(true);
        http.connect();
        if (useTempFile) {
            if (!Lotus.singleton.Platform().IsMac()) {
                this.CreateTempFile();
            } else {
                this.CreateMacOSBundle();
            }
        } else {
            this.tempFile = new File(this.location.getAbsolutePath());
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(http.getInputStream());
        FileOutputStream fileOutputStream = new FileOutputStream(this.tempFile);
        this.totalSize = fileSize = (float)http.getContentLength();
        byte[] bucket = new byte[2048];
        while ((numBytesRead = bufferedInputStream.read(bucket, 0, bucket.length)) != -1) {
            fileOutputStream.write(bucket, 0, numBytesRead);
            this.downloadedBytes += (float)numBytesRead;
            if (this.macOSBundle == null) continue;
            this.WriteMacOSBundle();
        }
        fileOutputStream.close();
        bufferedInputStream.close();
    }

    protected void LocalFileDownload() throws IOException {
        File file = new File(this.url.substring("smb://".length()));
        this.CreateTempFile();
        FileInputStream fin = new FileInputStream(file);
        FileOutputStream fout = new FileOutputStream(this.tempFile);
        this.totalSize = file.length();
        this.downloadedBytes = 0.0f;
        int r = 0;
        byte[] b = new byte[2048];
        while ((r = fin.read(b)) != -1) {
            this.downloadedBytes += (float)r;
            fout.write(b, 0, r);
        }
        fin.close();
        fout.close();
    }

    protected void MoveContent(File from, File to) throws IOException {
        Path fileToMovePath = Paths.get(from.getAbsolutePath(), new String[0]);
        Path targetPath = Paths.get(to.getAbsolutePath(), new String[0]);
        Files.move(fileToMovePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
        if (this.macOSBundle != null) {
            Fs.RemoveFolder(this.macOSBundle);
        }
    }

    protected void CreateTempFile() throws IOException {
        if (this.tempFile == null) {
            do {
                this.tempFile = new File(Lotus.singleton.FileLocations().LocalStorage().getAbsolutePath() + "/dl/" + System.currentTimeMillis() + Tools.RandomSafeChars(8) + ".download");
            } while (this.tempFile.exists());
            this.tempFile.deleteOnExit();
        }
        if (!this.tempFile.getParentFile().exists()) {
            this.tempFile.getParentFile().mkdir();
        }
    }

    private void CreateMacOSBundle() {
        if (this.tempFile == null) {
            File baseLocation = Fs.FileUnite(Lotus.singleton.FileLocations().LocalStorage(), "dl");
            File downloadsFolder = Fs.FileUnite(Lotus.singleton.FileLocations().UserHome(), "Downloads");
            if (downloadsFolder.exists()) {
                baseLocation = downloadsFolder;
            }
            do {
                this.tempFile = Fs.FileUnite(baseLocation, System.currentTimeMillis() + Tools.RandomSafeChars(8) + ".download");
            } while (this.tempFile.exists());
            this.tempFile.deleteOnExit();
        }
        if (!this.tempFile.getParentFile().exists()) {
            this.tempFile.getParentFile().mkdir();
        }
        this.tempFile.mkdir();
        this.macOSBundle = this.tempFile;
        this.macOSDL = this.location.getName();
        this.macOSInfo_plist = Fs.FileUnite(this.macOSBundle, "Info.plist");
        this.tempFile = Fs.FileUnite(this.macOSBundle, this.macOSDL);
        this.macOSDLID = Tools.RandomSafeChars(16);
        this.WriteMacOSBundle();
    }

    private void WriteMacOSBundle() {
        if (this.macOSInfo_plist != null) {
            Fs.WriteText(this.macOSInfo_plist, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\"\n   \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">\n<dict>\n    <key>URL</key>\n    <string>" + this.url + "</string>\n    <key>DownloadEntryIdentifier</key>\n    <string>" + Lotus.singleton.AppInfo().ID() + "." + this.macOSDLID + "</string>\n    <key>Path</key>\n    <string>" + this.macOSDL + "</string>\n    <key>Progress</key>\n    <real>" + Math.round(this.Progress() * 100.0f) / 100 + "</real> <!-- Value between 0.0 and 1.0 -->\n</dict>\n</plist>");
        }
    }

    public String URL() {
        return this.url;
    }

    public File TempLocation() {
        return this.tempFile;
    }

    public File Location() {
        return this.location;
    }

    public Boolean IsDone() {
        return this.done;
    }

    public float TotalSize() {
        return this.totalSize;
    }

    public float CurrentSize() {
        return this.downloadedBytes;
    }

    public float Progress() {
        if (!this.IsDone().booleanValue()) {
            return this.CurrentSize() / this.TotalSize();
        }
        return 1.0f;
    }

    public int Precentage() {
        return Math.round(this.Progress() * 100.0f);
    }
}

