/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

public class OldDownload {
    private float requireBytes = 0.0f;
    private float totalBytes = 0.0f;
    private boolean done = false;
    private String downloadURL;
    private File file;

    public OldDownload(String downloadURL, File file, boolean ManualStart) throws IOException {
        this.downloadURL = downloadURL;
        this.file = file;
        if (!ManualStart) {
            this.Start();
        }
    }

    public OldDownload(String downloadURL, File file) throws IOException {
        this.downloadURL = downloadURL;
        this.file = file;
        this.Start();
    }

    public void Start() throws IOException {
        String gHandle = this.downloadURL.toLowerCase();
        if (gHandle.startsWith("https://") || gHandle.startsWith("http://")) {
            this.URLDownload();
        }
        if (gHandle.startsWith("smb://")) {
            File file = new File(this.downloadURL.substring("smb://".length()));
            FileInputStream fin = null;
            FileOutputStream fout = null;
            this.requireBytes = file.length();
            this.totalBytes = 0.0f;
            int r = 0;
            byte[] b = new byte[1024];
            fin = new FileInputStream(file);
            fout = new FileOutputStream(this.file);
            while ((r = fin.read(b)) != -1) {
                this.totalBytes += (float)r;
                fout.write(b, 0, r);
            }
            fin.close();
            fout.close();
        }
    }

    private void URLDownload() throws IOException {
        int numBytesRead;
        URL url = new URL(this.downloadURL);
        URLConnection con = url.openConnection();
        HttpURLConnection http = (HttpURLConnection)con;
        http.setRequestMethod("GET");
        http.setDoOutput(true);
        http.connect();
        String fileID = String.valueOf((int)Math.round(Math.random() * 1000000.0));
        String tempLocation = this.file.getAbsolutePath() + ".dl";
        while (new File(tempLocation).exists()) {
            fileID = String.valueOf((int)Math.round(Math.random() * 1000000.0));
            tempLocation = this.file.getAbsolutePath() + fileID + ".dl";
        }
        new File(tempLocation).createNewFile();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(http.getInputStream());
        FileOutputStream fileOutputStream = new FileOutputStream(tempLocation);
        float fileSize = http.getContentLength();
        this.requireBytes += fileSize;
        byte[] bucket = new byte[2048];
        while ((numBytesRead = bufferedInputStream.read(bucket, 0, bucket.length)) != -1) {
            fileOutputStream.write(bucket, 0, numBytesRead);
            this.totalBytes += (float)numBytesRead;
        }
        fileOutputStream.close();
        bufferedInputStream.close();
        Path fileToMovePath = Paths.get(tempLocation, new String[0]);
        Path targetPath = Paths.get(this.file.getAbsolutePath(), new String[0]);
        Files.move(fileToMovePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
        this.done = true;
    }

    public float Progress() {
        return this.totalBytes / this.requireBytes;
    }

    public float TotalSize() {
        return this.requireBytes;
    }

    public float CurrentSize() {
        return this.totalBytes;
    }

    public boolean IsDone() {
        return this.done;
    }

    public String URL() {
        return this.downloadURL;
    }

    public File File() {
        return this.file;
    }
}

