/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.window;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.window.Window;
import java.util.TreeMap;
import org.lwjgl.glfw.GLFW;

public class Mouse {
    private double x = 0.0;
    private double y = 0.0;
    private int leftState;
    private int lastLeftState = 0;
    private int rightState;
    private int lastRightState = 0;
    private boolean leftClicked = false;
    private boolean rightClicked = false;
    private boolean inWindow = false;
    private boolean inRenderCanvas = false;
    private boolean left = false;
    private boolean right = false;
    float mouseScrollX = 0.0f;
    float mouseScrollY = 0.0f;
    TreeMap<String, Long> cursors;
    private String cursorID = "cursor";
    private String lastCursorID = "";
    public static final String cursor = "cursor";
    public static final String pointer = "pointer";
    public static final String ibeam = "ibeam";
    public static final String resizex = "resizex";
    public static final String resizey = "resizey";
    Window win;

    public Mouse(Lotus singleton, Window window) {
        this.win = window;
        this.cursors = new TreeMap();
        this.cursors.put(cursor, GLFW.glfwCreateStandardCursor(221185));
        this.cursors.put(pointer, GLFW.glfwCreateStandardCursor(221188));
        this.cursors.put(ibeam, GLFW.glfwCreateStandardCursor(221186));
        this.cursors.put(resizex, GLFW.glfwCreateStandardCursor(221189));
        this.cursors.put(resizey, GLFW.glfwCreateStandardCursor(221190));
    }

    public void Tick(double x, double y, int left, int right) {
        this.leftClicked = false;
        this.rightClicked = false;
        this.leftState = left;
        this.rightState = right;
        this.left = this.leftState > 0;
        this.right = this.rightState > 0;
        this.x = x;
        this.y = y;
        if (this.leftState == 0 && this.lastLeftState == 1) {
            this.leftClicked = true;
        }
        if (this.rightState == 0 && this.lastRightState == 1) {
            this.rightClicked = true;
        }
        if (this.win.KeyboardInput().IsPressed(266)) {
            this.mouseScrollY = 1.0f;
        }
        if (this.win.KeyboardInput().IsPressed(267)) {
            this.mouseScrollY = -1.0f;
        }
        if (this.win.KeyboardInput().IsPressed(268)) {
            this.mouseScrollY = 1000000.0f;
        }
        if (this.win.KeyboardInput().IsPressed(269)) {
            this.mouseScrollY = -1000000.0f;
        }
        this.lastLeftState = this.leftState;
        this.lastRightState = this.rightState;
    }

    public void Set(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void Update() {
        this.mouseScrollX = 0.0f;
        this.mouseScrollY = 0.0f;
        if (this.lastCursorID != this.cursorID) {
            switch (this.cursorID) {
                case "none": {
                    GLFW.glfwSetInputMode(this.win.window, 208897, 212994);
                    break;
                }
                case "show": {
                    this.cursorID = cursor;
                }
                default: {
                    GLFW.glfwSetInputMode(this.win.window, 208897, 212993);
                    GLFW.glfwSetCursor(this.win.window, this.cursors.get(this.cursorID));
                }
            }
            this.lastCursorID = this.cursorID;
        }
        this.cursorID = cursor;
    }

    public double rawx() {
        return this.x + this.win.Position().x();
    }

    public double rawy() {
        return this.y + this.win.Position().y();
    }

    public double x() {
        return this.x - (double)(this.win.FrameWidth() / 2.0f) - this.win.Translate().x() - this.win.RenderOffset().x();
    }

    public double y() {
        return (double)(this.win.FrameHeight() / 2.0f) - this.y - this.win.Translate().y() - this.win.RenderOffset().y();
    }

    public boolean LeftDown() {
        return this.left;
    }

    public boolean RightDown() {
        return this.right;
    }

    public boolean LeftClicked() {
        return this.leftClicked;
    }

    public boolean RightClicked() {
        return this.rightClicked;
    }

    public float ScrollX() {
        return this.mouseScrollX;
    }

    public float ScrollY() {
        return this.mouseScrollY;
    }

    public void SetCursor(String id) {
        this.cursorID = id;
    }

    public String GetCursor() {
        return this.cursorID;
    }

    public void CheckIfInWindow() {
        this.inWindow = this.x() < (double)(this.win.Width() / 2.0f) && this.x() > (double)(-this.win.Width() / 2.0f) && this.y() > (double)(-this.win.Height() / 2.0f) && this.y() < (double)(this.win.Height() / 2.0f);
    }

    public void CheckIfInRenderCanvas() {
        this.inRenderCanvas = this.x() < (double)(this.win.CanvasWidth() / 2.0f) && this.x() > (double)(-this.win.CanvasWidth() / 2.0f) && this.y() > (double)(-this.win.CanvasHeight() / 2.0f) && this.y() < (double)(this.win.CanvasHeight() / 2.0f);
    }

    public boolean InsideOfWindow() {
        return this.inWindow;
    }

    public boolean InsideOfRenderCanvas() {
        return this.inRenderCanvas;
    }
}

