/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.window.diologs;

import com.arizotaz.lotus.ApplicationInfo;
import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.Text;
import com.arizotaz.lotus.resources.ICON;
import com.arizotaz.lotus.struc.Process;
import com.arizotaz.lotus.struc.Version;
import com.arizotaz.lotus.ui.elements.Button;
import com.arizotaz.lotus.ui.elements.Element;
import com.arizotaz.lotus.ui.elements.ElementRenderer;
import com.arizotaz.lotus.ui.elements.Panel;
import com.arizotaz.lotus.ui.elements.TextDisplay;
import com.arizotaz.lotus.window.StandardWindowTheme;
import com.arizotaz.lotus.window.Window;
import com.arizotaz.lotus.window.diologs.WindowDiolog;

public class Demo
extends Process {
    Window window;
    ElementRenderer elr;
    Button button;

    @Override
    public void Start() {
        this.window = Lotus.singleton.WindowManager().GetWindow(Lotus.singleton.WindowManager().CreateWindow("Demo", 1280, 720, this.ID()));
        this.window.Init();
        Element.CreateWindowParms();
        this.elr = new ElementRenderer();
        this.window.IdleFps(60);
        this.window.IdleFps(30);
        this.button = Element.Button();
        this.CreatePage();
    }

    @Override
    public void Update() {
        Element.Reset();
        this.window.Process();
        this.window.TextureEngine().Update();
        if (this.window.SizeChanged() || this.window.ThemeChanged()) {
            this.CreatePage();
        }
        this.elr.Update();
        this.elr.Interact();
        this.elr.Render();
        if (this.button.Clicked()) {
            WindowDiolog.Message("Value", WindowDiolog.Input("Enter Text", "Sample Text", "Enter Text for the next message", new StandardWindowTheme(null)), ICON.Texture("icon.warn"), new StandardWindowTheme(null));
        }
        this.window.Render(this.elr.HasChanged());
        if (this.window.WantsToClose()) {
            this.QuitProcess();
        }
    }

    @Override
    public void Exit() {
        this.window.CleanUp();
    }

    public void CreatePage() {
        this.elr.ClearCycle();
        this.button = Element.Button();
        this.elr.AddElement(new Panel(0.0f, 0.0f, this.window.CanvasWidth(), this.window.CanvasHeight(), 0.0f, this.window.GetTheme().Background()));
        Text text = new Text("W: " + this.window.Width() + "\nH: " + this.window.Height() + "\nFPS: %fps%");
        text.Align(0, 0);
        text.FontSize(18.0f * this.window.RenderScale());
        this.elr.AddElement(new TextDisplay(text, -this.window.CanvasWidth() / 2.0f, this.window.CanvasHeight() / 2.0f));
        this.button.Set(0.0f, 0.0f, 200.0f, 50.0f);
        this.elr.AddElement(this.button);
    }

    public static void main(String[] args) {
        Lotus lotus = new Lotus(args);
        lotus.Config(new ApplicationInfo("abyssWindowDemo", new Version(1, 1, 1), "Windows 98 Demo", null));
        lotus.Setup();
        lotus.Init();
        lotus.AddProcess(new Demo());
        lotus.Start();
    }
}

