/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.window.diologs;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.struc.Process;
import com.arizotaz.lotus.ui.elements.Button;
import com.arizotaz.lotus.ui.elements.Element;
import com.arizotaz.lotus.ui.elements.ElementRenderer;
import com.arizotaz.lotus.ui.elements.InputField;
import com.arizotaz.lotus.ui.elements.Panel;
import com.arizotaz.lotus.window.StandardWindowTheme;
import com.arizotaz.lotus.window.Window;
import com.arizotaz.lotus.window.WindowTheme;
import java.lang.reflect.InvocationTargetException;

public class InputBox
extends Process {
    private Window window;
    private WindowTheme theme = null;
    private String title = "";
    private String placeHolder = "";
    private String message = "";
    private ElementRenderer elm;
    private InputField input;
    private Button done;

    public InputBox(String title, String placeHolder, String message, WindowTheme theme) {
        this.title = title;
        this.placeHolder = placeHolder;
        this.message = message;
        this.theme = theme;
    }

    @Override
    public void Start() {
        this.window = Lotus.singleton.WindowManager().GetWindow(Lotus.singleton.WindowManager().CreateWindow(this.title, 600, 200, this.ID()));
        this.window.Init();
        this.window.Process();
        this.window.Render(true);
        this.processReturn = "";
        Element.CreateWindowParms();
        if (this.theme == null) {
            this.theme = new StandardWindowTheme(this.window);
        }
        try {
            this.window.SetTheme((WindowTheme)this.theme.getClass().getDeclaredConstructor(Window.class).newInstance(this.window));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        this.window.SetResizable(false);
        this.elm = new ElementRenderer();
        this.CreateElements();
        this.CreatePage();
    }

    @Override
    public void Update() {
        Element.Reset();
        this.window.TextureEngine().Update();
        this.window.Process();
        if (this.window.SizeChanged() || this.window.ThemeChanged()) {
            this.CreateElements();
            this.CreatePage();
        }
        this.elm.Update();
        this.elm.Interact();
        if (this.elm.HasChanged() || this.window.RenderedOnLastCycle()) {
            this.elm.Render();
        }
        if (this.done.Clicked() || this.window.KeyboardInput().IsPressed(257)) {
            this.processReturn = this.input.GetValue();
            this.QuitProcess();
        }
        this.window.Render(this.elm.HasChanged());
        if (this.window.WantsToClose()) {
            this.processReturn = "";
            this.QuitProcess();
        }
    }

    @Override
    public void Exit() {
        this.window.CleanUp();
    }

    public void CreateElements() {
        this.input = Element.InputField();
        this.input.SetPlaceHolder(this.placeHolder);
        this.input.SetValue(this.message);
        this.done = Element.Button();
    }

    public void CreatePage() {
        this.elm.ClearCycle();
        float padding = 20.0f * this.window.RenderScale();
        float buttonWidth = 100.0f * this.window.RenderScale();
        float buttonHeight = 25.0f * this.window.RenderScale();
        this.elm.AddElement(new Panel(0.0f, 0.0f, this.window.CanvasWidth(), this.window.CanvasHeight(), 0.0f, this.window.GetTheme().Background()));
        this.done.Set("Done", this.window.CanvasWidth() / 2.0f - padding / 2.0f - buttonWidth / 2.0f, -this.window.CanvasHeight() / 2.0f + padding / 2.0f + buttonHeight / 2.0f, buttonWidth, buttonHeight);
        this.elm.AddElement(this.done);
        this.input.Set(0.0f, 0.0f, this.window.CanvasWidth() - 100.0f * this.window.RenderScale(), 26.0f * this.window.RenderScale());
        this.elm.AddElement(this.input);
    }
}

