/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.window.diologs;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.Text;
import com.arizotaz.lotus.struc.Process;
import com.arizotaz.lotus.ui.elements.Button;
import com.arizotaz.lotus.ui.elements.Element;
import com.arizotaz.lotus.ui.elements.ElementRenderer;
import com.arizotaz.lotus.ui.elements.Image;
import com.arizotaz.lotus.ui.elements.Panel;
import com.arizotaz.lotus.ui.elements.TextDisplay;
import com.arizotaz.lotus.window.StandardWindowTheme;
import com.arizotaz.lotus.window.Window;
import com.arizotaz.lotus.window.WindowTheme;
import java.lang.reflect.InvocationTargetException;

public class OkWindowDiolog
extends Process {
    private Window window;
    private WindowTheme theme = null;
    private String title = "";
    private String message = "";
    private ElementRenderer elm;
    private Button done;
    private String image = "";
    private boolean resizedLastFrame = false;

    public OkWindowDiolog(String title, String message) {
        this.title = title;
        this.message = message;
    }

    public OkWindowDiolog(String title, String message, String texture, WindowTheme theme) {
        this.title = title;
        this.message = message;
        this.image = texture;
        this.theme = theme;
    }

    @Override
    public void Start() {
        this.window = Lotus.singleton.WindowManager().GetWindow(Lotus.singleton.WindowManager().CreateWindow(this.title, 100, 100, this.ID()));
        this.window.Init();
        this.window.Process();
        this.window.Render(true);
        Element.CreateWindowParms();
        if (this.theme == null) {
            this.theme = new StandardWindowTheme(this.window);
        }
        try {
            this.window.SetTheme((WindowTheme)this.theme.getClass().getDeclaredConstructor(Window.class).newInstance(this.window));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        this.window.SetResizable(false);
        this.window.Process();
        this.window.Render(true);
        this.window.SetWindowSize((int)(500.0f * this.window.RenderScale()), (int)(100.0f * this.window.RenderScale()));
        this.elm = new ElementRenderer();
        this.CreateElements();
        this.CreatePage();
    }

    @Override
    public void Update() {
        Element.Reset();
        this.window.TextureEngine().Update();
        this.window.Process();
        if (this.window.SizeChanged() || this.window.ThemeChanged()) {
            this.CreateElements();
            this.CreatePage();
        }
        this.elm.Update();
        this.elm.Interact();
        if (this.elm.HasChanged() || this.window.RenderedOnLastCycle()) {
            this.elm.Render();
        }
        if (this.done.Clicked()) {
            this.QuitProcess();
        }
        this.window.Render(this.elm.HasChanged());
        if (this.window.WantsToClose()) {
            this.QuitProcess();
        }
    }

    @Override
    public void Exit() {
        this.window.CleanUp();
    }

    public void CreateElements() {
        this.done = Element.Button();
    }

    public void CreatePage() {
        boolean heightTooSmall;
        this.elm.ClearCycle();
        float padding = 20.0f * this.window.RenderScale();
        float buttonWidth = 100.0f * this.window.RenderScale();
        float buttonHeight = 25.0f * this.window.RenderScale();
        this.elm.AddElement(new Panel(0.0f, 0.0f, this.window.CanvasWidth(), this.window.CanvasHeight(), 0.0f, this.window.GetTheme().Background()));
        this.done.Set("Ok", this.window.CanvasWidth() / 2.0f - padding - buttonWidth / 2.0f, -this.window.CanvasHeight() / 2.0f + padding + buttonHeight / 2.0f, buttonWidth, buttonHeight);
        this.elm.AddElement(this.done);
        float iconSize = 50.0f * this.window.RenderScale();
        padding = 40.0f * this.window.RenderScale();
        float fontSize = iconSize / 3.0f;
        float xIndex = -this.window.CanvasWidth() / 2.0f + padding;
        float yIndex = 0.0f;
        Text text = new Text(this.message);
        text.MaxWidth(this.window.CanvasWidth() - padding * 2.0f);
        if (!this.image.equals("")) {
            this.elm.AddElement(new Image(this.image, xIndex += iconSize / 2.0f, yIndex, iconSize, iconSize, 0.0f, 255, true));
            text.MaxWidth(this.window.CanvasWidth() - padding * 2.0f - iconSize - padding * 2.0f);
            xIndex += iconSize / 2.0f + iconSize / 8.0f;
        }
        text.SetSpaceWidth(0.5f);
        text.TabSize(6);
        text.Align(0, 0);
        text.SetFont(this.window.GetTheme().Font());
        text.SetSpaceWidth(0.5f);
        text.FontSize(fontSize);
        text.Calculate();
        this.elm.AddElement(new TextDisplay(text, xIndex, yIndex += text.Height() / 2.0f));
        float textX = xIndex + this.window.CanvasWidth() / 2.0f;
        float textY = yIndex + this.window.CanvasHeight() / 2.0f;
        boolean widthTooSmall = textX + text.Width() + padding > this.window.Width();
        boolean bl = heightTooSmall = textY - text.Height() < padding / 2.0f;
        if (widthTooSmall || heightTooSmall) {
            float cw = this.window.Width();
            float ch = this.window.Height();
            if (widthTooSmall) {
                float diff = textX + text.Width() + padding - this.window.Width();
                cw += diff;
            } else if (heightTooSmall) {
                float diff = padding / 2.0f - (textY - text.Height());
                ch += diff;
            }
            this.window.SetWindowSize((int)Math.ceil(cw), (int)Math.ceil(ch));
        }
    }
}

