/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.window.diologs;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.Text;
import com.arizotaz.lotus.struc.Process;
import com.arizotaz.lotus.ui.elements.Element;
import com.arizotaz.lotus.ui.elements.ElementRenderer;
import com.arizotaz.lotus.ui.elements.Panel;
import com.arizotaz.lotus.ui.elements.TextDisplay;
import com.arizotaz.lotus.utils.Tools;
import com.arizotaz.lotus.window.Mouse;
import com.arizotaz.lotus.window.StandardWindowTheme;
import com.arizotaz.lotus.window.Window;
import com.arizotaz.lotus.window.WindowTheme;
import java.lang.reflect.InvocationTargetException;

public class TextView
extends Process {
    private Window window;
    private WindowTheme theme = null;
    private Mouse mouse;
    private String title = "";
    private String message = "";
    private float textSize = 0.0f;
    private float scroll = 0.0f;
    private ElementRenderer elm;

    public TextView(String title, String message, WindowTheme theme) {
        this.title = title;
        this.message = message;
        this.theme = theme;
    }

    @Override
    public void Start() {
        this.window = Lotus.singleton.WindowManager().GetWindow(Lotus.singleton.WindowManager().CreateWindow(this.title, 800, 600, this.ID()));
        this.window.Init();
        this.window.Process();
        this.window.Render(true);
        Element.CreateWindowParms();
        if (this.theme == null) {
            this.theme = new StandardWindowTheme(this.window);
        }
        try {
            this.window.SetTheme((WindowTheme)this.theme.getClass().getDeclaredConstructor(Window.class).newInstance(this.window));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        this.window.SetResizable(false);
        this.elm = new ElementRenderer();
        this.mouse = this.window.Mouse();
        this.CreatePage();
    }

    @Override
    public void Update() {
        Element.Reset();
        this.window.TextureEngine().Update();
        this.window.Process();
        this.scroll -= this.mouse.ScrollY() * (10.0f * this.window.RenderScale());
        this.scroll = Tools.ClampVar(this.scroll, 0.0f, this.textSize - (this.window.CanvasHeight() - 20.0f * this.window.RenderScale()));
        if (this.window.SizeChanged() || this.window.ThemeChanged() || this.mouse.ScrollY() != 0.0f) {
            this.CreatePage();
        }
        this.elm.Update();
        this.elm.Interact();
        if (this.elm.HasChanged() || this.window.RenderedOnLastCycle()) {
            this.elm.Render();
        }
        this.window.Render(this.elm.HasChanged());
        if (this.window.WantsToClose()) {
            this.QuitProcess();
        }
    }

    @Override
    public void Exit() {
        this.window.CleanUp();
    }

    public void CreatePage() {
        this.elm.ClearCycle();
        float padding = 20.0f * this.window.RenderScale();
        this.elm.AddElement(new Panel(0.0f, 0.0f, this.window.CanvasWidth(), this.window.CanvasHeight(), 0.0f, this.window.GetTheme().Background()));
        float fontSize = 20.0f * this.window.RenderScale();
        float xIndex = -this.window.CanvasWidth() / 2.0f + padding;
        float yIndex = this.window.CanvasHeight() / 2.0f - padding + this.scroll;
        Text text = new Text(this.message);
        text.MaxWidth(this.window.CanvasWidth() - padding * 2.0f);
        text.SetSpaceWidth(0.5f);
        text.TabSize(6);
        text.Align(0, 0);
        text.SetFont(this.window.GetTheme().Font());
        text.SetSpaceWidth(0.5f);
        text.FontSize(fontSize);
        text.Calculate();
        this.elm.AddElement(new TextDisplay(text, xIndex, yIndex));
        this.textSize = text.Height();
    }
}

