/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.window.diologs;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.utils.Fs;
import com.arizotaz.lotus.window.WindowTheme;
import com.arizotaz.lotus.window.diologs.Diolog2ButtonBox;
import com.arizotaz.lotus.window.diologs.Diolog3ButtonBox;
import com.arizotaz.lotus.window.diologs.InputBox;
import com.arizotaz.lotus.window.diologs.OkWindowDiolog;
import com.arizotaz.lotus.window.diologs.TextView;
import java.io.File;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class WindowDiolog {
    private static String GetAlertType(String textureID) {
        if (textureID.equals("icon.message")) {
            return "info";
        }
        if (textureID.equals("icon.warn")) {
            return "warning";
        }
        if (textureID.equals("icon.error")) {
            return "error";
        }
        if (textureID.equals("icon.internet")) {
            return "question";
        }
        return "info";
    }

    public static void Message(String t, String m) {
        WindowDiolog.Message(t, m, "");
    }

    public static void Message(String t, String m, String texture) {
        WindowDiolog.Message(t, m, texture, null);
    }

    public static void Message(String t, String m, WindowTheme theme) {
        WindowDiolog.Message(t, m, "", theme);
    }

    public static void Message(String t, String m, String texture, WindowTheme theme) {
        if (Lotus.singleton.Platform().IsMac()) {
            TinyFileDialogs.tinyfd_messageBox(t, m, "ok", WindowDiolog.GetAlertType(texture), true);
            return;
        }
        Lotus.singleton.ProcessManager().StartReturnProcess(new OkWindowDiolog(t, m, texture, theme));
    }

    public static String Input(String t, WindowTheme theme) {
        return WindowDiolog.Input(t, "", theme);
    }

    public static String Input(String t, String p, WindowTheme theme) {
        return WindowDiolog.Input(t, p, "", theme);
    }

    public static String Input(String t, String p, String m, WindowTheme theme) {
        if (Lotus.singleton.Platform().IsMac()) {
            return TinyFileDialogs.tinyfd_inputBox(t, m, p);
        }
        return (String)Lotus.singleton.ProcessManager().StartReturnProcess(new InputBox(t, p, m, theme));
    }

    public static boolean Confirm(String t, String m) {
        return WindowDiolog.Confirm(t, m, "");
    }

    public static boolean Confirm(String t, String m, String texture) {
        return WindowDiolog.Confirm(t, m, texture, null);
    }

    public static boolean Confirm(String t, String m, WindowTheme theme) {
        return WindowDiolog.Confirm(t, m, "", theme);
    }

    public static boolean Confirm(String t, String m, String texture, WindowTheme theme) {
        return WindowDiolog.Confirm(t, m, texture, theme, "Yes", "No");
    }

    public static boolean Confirm(String t, String m, String texture, WindowTheme theme, String option1, String option2) {
        if (Lotus.singleton.Platform().IsMac()) {
            boolean response = TinyFileDialogs.tinyfd_messageBox(t, m, "yesno", WindowDiolog.GetAlertType(texture), true);
            return response;
        }
        return (Integer)Lotus.singleton.ProcessManager().StartReturnProcess(new Diolog2ButtonBox(t, m, texture, theme, option1, option2)) == 1;
    }

    public static int YNC(String t, String m) {
        return WindowDiolog.YNC(t, m, "");
    }

    public static int YNC(String t, String m, String texture) {
        return WindowDiolog.YNC(t, m, texture, null);
    }

    public static int YNC(String t, String m, WindowTheme theme) {
        return WindowDiolog.YNC(t, m, "", theme);
    }

    public static int YNC(String t, String m, String texture, WindowTheme theme) {
        return WindowDiolog.YNC(t, m, texture, theme, "Yes", "No", "Cancel");
    }

    public static int YNC(String t, String m, String texture, WindowTheme theme, String option1, String option2, String option3) {
        return (Integer)Lotus.singleton.ProcessManager().StartReturnProcess(new Diolog3ButtonBox(t, m, texture, theme, option1, option2, option3));
    }

    public static void OpenTextFile(File file, WindowTheme theme) {
        String text = Fs.ReadText(file);
        WindowDiolog.OpenText(file.getName(), text, theme);
    }

    public static void OpenText(String t, String m, WindowTheme theme) {
        Lotus.singleton.ProcessManager().AddProcess(new TextView(t, m, theme));
    }

    public static void OpenTextFileSync(File file, WindowTheme theme) {
        String text = Fs.ReadText(file);
        WindowDiolog.OpenTextSync(file.getName(), text, theme);
    }

    public static void OpenTextSync(String t, String m, WindowTheme theme) {
        if (Lotus.singleton.Platform().IsMac()) {
            WindowDiolog.Message(t, m, "info", theme);
            return;
        }
        Lotus.singleton.ProcessManager().StartReturnProcess(new TextView(t, m, theme));
    }

    public static String[] SelectFile(String title) {
        return WindowDiolog.SelectFile(title, Lotus.singleton.FileLocations().UserHome());
    }

    public static String[] SelectFile(String title, boolean multi) {
        return WindowDiolog.SelectFile(title, Lotus.singleton.FileLocations().UserHome(), multi);
    }

    public static String[] SelectFile(String title, File defaultLocation) {
        return WindowDiolog.SelectFile(title, defaultLocation, new String[0]);
    }

    public static String[] SelectFile(String title, String[] types) {
        return WindowDiolog.SelectFile(title, Lotus.singleton.FileLocations().UserHome(), types);
    }

    public static String[] SelectFile(String title, File defaultLocation, String[] types) {
        return WindowDiolog.SelectFile(title, defaultLocation, types, false, null);
    }

    public static String[] SelectFile(String title, File defaultLocation, boolean multi) {
        return WindowDiolog.SelectFile(title, defaultLocation, new String[0], multi, null);
    }

    public static String[] SelectFile(String title, File location, String[] types, boolean multipleFiles, WindowTheme theme) {
        return WindowDiolog.SystemSelectFile(title, location, types, multipleFiles, theme);
    }

    public static String[] SystemSelectFile(String title) {
        return WindowDiolog.SystemSelectFile(title, Lotus.singleton.FileLocations().UserHome());
    }

    public static String[] SystemSelectFile(String title, boolean multi) {
        return WindowDiolog.SystemSelectFile(title, Lotus.singleton.FileLocations().UserHome(), multi);
    }

    public static String[] SystemSelectFile(String title, File defaultLocation) {
        return WindowDiolog.SystemSelectFile(title, defaultLocation, new String[0]);
    }

    public static String[] SystemSelectFile(String title, String[] types) {
        return WindowDiolog.SystemSelectFile(title, Lotus.singleton.FileLocations().UserHome(), types);
    }

    public static String[] SystemSelectFile(String title, File defaultLocation, String[] types) {
        return WindowDiolog.SystemSelectFile(title, defaultLocation, types, false, null);
    }

    public static String[] SystemSelectFile(String title, File defaultLocation, boolean multi) {
        return WindowDiolog.SystemSelectFile(title, defaultLocation, new String[0], multi, null);
    }

    public static String[] SystemSelectFile(String title, File location, String[] types, boolean multipleFiles, WindowTheme theme) {
        String rdata;
        block11: {
            rdata = "";
            if (types.length > 0) {
                Throwable throwable = null;
                Object var7_8 = null;
                try (MemoryStack stack = MemoryStack.stackPush();){
                    PointerBuffer aFilterPatterns = stack.mallocPointer(2);
                    int i = 0;
                    while (i < types.length) {
                        aFilterPatterns.put(stack.UTF8(types[i]));
                        ++i;
                    }
                    aFilterPatterns.flip();
                    rdata = TinyFileDialogs.tinyfd_openFileDialog(title, location.getAbsolutePath(), aFilterPatterns, null, multipleFiles);
                    break block11;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            rdata = TinyFileDialogs.tinyfd_openFileDialog(title, location.getAbsolutePath().replace("\\", "/") + "/", null, null, multipleFiles);
        }
        String[] data = rdata != null ? rdata.split("\\|") : new String[]{};
        return data;
    }

    public static String SystemOpenFolder(String title) {
        return WindowDiolog.SystemOpenFolder(title, Lotus.singleton.FileLocations().UserHome().getAbsolutePath());
    }

    public static String SystemOpenFolder(String title, String location) {
        return TinyFileDialogs.tinyfd_selectFolderDialog(title, location);
    }

    public static String[] SaveFile(String title) {
        return WindowDiolog.SaveFile(title, Lotus.singleton.FileLocations().UserHome());
    }

    public static String[] SaveFile(String title, String desc) {
        return WindowDiolog.SaveFile(title, Lotus.singleton.FileLocations().UserHome(), desc);
    }

    public static String[] SaveFile(String title, File defaultLocation) {
        return WindowDiolog.SaveFile(title, defaultLocation, new String[0]);
    }

    public static String[] SaveFile(String title, String[] types) {
        return WindowDiolog.SaveFile(title, Lotus.singleton.FileLocations().UserHome(), types);
    }

    public static String[] SaveFile(String title, File defaultLocation, String[] types) {
        return WindowDiolog.SaveFile(title, defaultLocation, types, "", null);
    }

    public static String[] SaveFile(String title, File defaultLocation, String desc) {
        return WindowDiolog.SaveFile(title, defaultLocation, new String[0], desc, null);
    }

    public static String[] SaveFile(String title, File location, String[] types, String desc, WindowTheme theme) {
        return WindowDiolog.SystemSaveFile(title, location, types, desc);
    }

    public static String[] SystemSaveFile(String title) {
        return WindowDiolog.SystemSaveFile(title, Lotus.singleton.FileLocations().UserHome());
    }

    public static String[] SystemSaveFile(String title, String desc) {
        return WindowDiolog.SystemSaveFile(title, Lotus.singleton.FileLocations().UserHome(), desc);
    }

    public static String[] SystemSaveFile(String title, File defaultLocation) {
        return WindowDiolog.SystemSaveFile(title, defaultLocation, new String[0]);
    }

    public static String[] SystemSaveFile(String title, String[] types) {
        return WindowDiolog.SystemSaveFile(title, Lotus.singleton.FileLocations().UserHome(), types);
    }

    public static String[] SystemSaveFile(String title, File defaultLocation, String[] types) {
        return WindowDiolog.SystemSaveFile(title, defaultLocation, types, "");
    }

    public static String[] SystemSaveFile(String title, File defaultLocation, String description) {
        return WindowDiolog.SystemSaveFile(title, defaultLocation, new String[0], description);
    }

    public static String[] SystemSaveFile(String title, File location, String[] types, String description) {
        String rdata;
        block11: {
            rdata = "";
            if (types.length > 0) {
                Throwable throwable = null;
                Object var6_7 = null;
                try (MemoryStack stack = MemoryStack.stackPush();){
                    PointerBuffer aFilterPatterns = stack.mallocPointer(2);
                    int i = 0;
                    while (i < types.length) {
                        aFilterPatterns.put(stack.UTF8(types[i]));
                        ++i;
                    }
                    aFilterPatterns.flip();
                    rdata = TinyFileDialogs.tinyfd_saveFileDialog(title, location.getAbsolutePath(), aFilterPatterns, description);
                    break block11;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            rdata = TinyFileDialogs.tinyfd_saveFileDialog(title, location.getAbsolutePath().replace("\\", "/") + "/", null, description);
        }
        String[] data = rdata != null ? rdata.split("\\|") : new String[]{};
        return data;
    }
}

