/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.window.theme.abyss;

import com.arizotaz.lotus.Text;
import com.arizotaz.lotus.struc.Vector4;
import com.arizotaz.lotus.ui.elements.InputField;

public class AbyssInputBox
extends InputField {
    public AbyssInputBox() {
        this.changeCursorTo = "ibeam";
    }

    @Override
    public void Render() {
        int segs = 5;
        int r = Math.round(this.height / 4.0f);
        float padding = this.window.RenderScale() * (this.height / 6.0f);
        if (!this.IsHovering()) {
            this.window.RenderObjects().SetColor(60.0f);
        } else {
            this.window.RenderObjects().SetColor(40.0f);
        }
        this.window.RenderObjects().DrawRoundedRect(this.x, this.y, 0.0, this.width, this.height, r, segs);
        if (!this.IsHovering()) {
            this.window.RenderObjects().SetColor(40.0f);
        } else {
            this.window.RenderObjects().SetColor(60.0f);
        }
        this.window.RenderObjects().DrawRoundedRect(this.x + padding / 2.0f / 2.0f, this.y - padding / 2.0f / 2.0f, 0.0, this.width - padding / 2.0f, this.height - padding / 2.0f, r, segs);
        if (!this.IsHovering()) {
            this.window.RenderObjects().SetColor(80.0f);
        } else {
            this.window.RenderObjects().SetColor(100.0f);
        }
        this.window.RenderObjects().DrawRoundedRect(this.x, this.y, 0.0, this.width - padding, this.height - padding, r / 2, segs);
        Vector4 textColor = new Vector4(255.0, 255.0, 255.0, 255.0);
        String renderValue = this.value;
        if (renderValue.length() <= 0) {
            renderValue = this.placeHolder;
            textColor.Move(-60.0, -60.0, -60.0, 0.0);
        }
        Text sizeText = new Text(renderValue);
        sizeText.Calculate();
        while (sizeText.Width() > this.width - padding * 2.0f) {
            renderValue = renderValue.substring(1);
            sizeText = new Text(renderValue);
            sizeText.Calculate();
        }
        float fontSize = this.height - this.height / 6.0f - padding;
        Text text = new Text(renderValue);
        text.FontSize(fontSize);
        text.Align(0, 1);
        text.MaxWidth(this.width - padding * 2.0f);
        text.AllowWrap(false);
        text.SetSpaceWidth(0.5f);
        text.SetFont(this.font);
        text.Color(textColor);
        text.Render(this.x - this.width / 2.0f + padding, this.y);
    }
}

