/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.window.theme.abyss;

import com.arizotaz.lotus.Text;
import com.arizotaz.lotus.struc.Vector2;
import com.arizotaz.lotus.struc.Vector4;
import com.arizotaz.lotus.texture.Texture;
import com.arizotaz.lotus.texture.TextureEngine;
import com.arizotaz.lotus.ui.elements.Button;
import com.arizotaz.lotus.ui.elements.Element;
import com.arizotaz.lotus.ui.elements.ElementRenderer;
import com.arizotaz.lotus.ui.elements.Image;
import com.arizotaz.lotus.ui.elements.Panel;
import com.arizotaz.lotus.ui.elements.TextDisplay;
import com.arizotaz.lotus.window.Window;
import com.arizotaz.lotus.window.WindowTheme;
import com.arizotaz.lotus.window.theme.abyss.AbyssButton;
import com.arizotaz.lotus.window.theme.abyss.AbyssHeader;
import com.arizotaz.lotus.window.theme.abyss.AbyssInputBox;
import com.arizotaz.lotus.window.theme.abyss.HorizontalDragBar;
import com.arizotaz.lotus.window.theme.abyss.VerticalDragBar;

public class AbyssWindowTheme
extends WindowTheme {
    private AbyssHeader winHeader;
    private Vector2 canvas;
    private Vector2 translate;
    private ElementRenderer headerRenderer;
    private HorizontalDragBar leftSide;
    private HorizontalDragBar rightSide;
    private VerticalDragBar topSide;
    private VerticalDragBar bottomSide;
    private boolean lastDragState = false;
    private String lastIconPath = "";
    private Button close;
    private Button maximize;
    private Button minimize;
    int iconLoadFrames = 0;
    float padding;
    float renderScale;
    float headerWidth;
    float headerHeight;
    float headerX = 0.0f;
    float headerY;

    public AbyssWindowTheme(Window window) {
        super(window);
    }

    @Override
    public void Init() {
        this.window.Border(false);
        this.headerRenderer = new ElementRenderer();
        this.winHeader = new AbyssHeader();
        this.leftSide = new HorizontalDragBar(false);
        this.rightSide = new HorizontalDragBar(true);
        this.bottomSide = new VerticalDragBar(true);
        this.topSide = new VerticalDragBar(false);
        this.SetPrimaryColor(new Vector4(25.0, 25.0, 25.0, 255.0), new Vector4(150.0, 150.0, 150.0, 255.0), new Vector4(255.0, 255.0, 255.0, 255.0));
        this.SetSecondaryColor(new Vector4(120.0, 120.0, 120.0, 255.0), new Vector4(200.0, 200.0, 200.0, 255.0), new Vector4(255.0, 255.0, 255.0, 255.0));
        this.SetTertiaryColor(new Vector4(255.0, 255.0, 255.0, 255.0), new Vector4(255.0, 255.0, 255.0, 255.0), new Vector4(255.0, 255.0, 255.0, 255.0));
        this.SetQuaternaryColor(new Vector4(255.0, 255.0, 255.0, 255.0), new Vector4(255.0, 255.0, 255.0, 255.0), new Vector4(255.0, 255.0, 255.0, 255.0));
        this.SetQuinaryColor(new Vector4(255.0, 255.0, 255.0, 255.0), new Vector4(255.0, 255.0, 255.0, 255.0), new Vector4(255.0, 255.0, 255.0, 255.0));
        this.background = new Vector4(50.0, 50.0, 50.0, 255.0);
        this.textColor = new Vector4(255.0, 255.0, 255.0, 255.0);
        Text.dr = this.textColor.IntX();
        Text.dg = this.textColor.IntY();
        Text.db = this.textColor.IntZ();
        Text.da = this.textColor.IntW();
        Element.CreateWindowParms();
        Element.SetDefaultButton(new AbyssButton());
        Element.SetDefaultInput(new AbyssInputBox());
        this.CreateElements();
    }

    @Override
    public void SetupSpace() {
        if (this.window.Border()) {
            this.window.Border(false);
        }
        Element.Reset();
        if (this.window.SizeChanged()) {
            this.CreateElements();
        }
        if (!this.window.IconPath().equals(this.lastIconPath)) {
            this.lastIconPath = this.window.IconPath();
            this.window.TextureEngine().DestroyTexture("window.theme.abyss_" + this.window.window + ".icon");
            TextureEngine.RemoveFromGlobalList("window.theme.abyss_" + this.window.window + ".icon");
            TextureEngine.AddToGlobalList("window.theme.98.abyss_" + this.window.window + ".icon", this.lastIconPath, false, true);
            this.CreateElements();
        }
        --this.iconLoadFrames;
        Texture tex = this.window.TextureEngine().GetTexture("window.theme.abyss_" + this.window.window + ".icon");
        if (tex == null) {
            this.iconLoadFrames = 60;
        } else if (!tex.GLCreated()) {
            this.iconLoadFrames = 60;
        }
        if (this.iconLoadFrames > 0) {
            --this.iconLoadFrames;
            this.CreateElements();
        }
        if (this.winHeader != null && this.lastDragState != this.winHeader.Drag()) {
            this.lastDragState = this.winHeader.Drag();
            this.CreateElements();
        }
        this.window.RenderOffset().Set(0.0, 0.0);
        this.canvas = new Vector2(this.window.Width(), this.window.Height());
        if (!this.window.NotWindowed()) {
            this.window.RenderOffset().Move(0.0, -this.window.Height() / 2.0f);
            this.window.SetCanvasSize(new Vector2(this.headerWidth, this.headerY - this.padding - this.headerHeight / 2.0f + this.window.Height() / 2.0f));
            this.window.RenderOffset().Move(0.0, this.window.CanvasHeight() / 2.0f + this.padding);
            this.window.SetRenderUnitScale(this.renderScale);
            this.window.Translate().Set(0.0, 0.0);
        }
    }

    @Override
    public void RenderBackground() {
        this.window.RenderObjects().SetColor(255.0f, 0.0f, 0.0f, 255.0f);
        this.window.RenderObjects().DrawRect(0.0f, 0.0f, this.window.CanvasWidth(), this.window.CanvasHeight(), 0.0f);
    }

    @Override
    public void Restore() {
        Element.Reset();
        try {
            this.window.SetCanvasSize(this.canvas);
            this.window.Translate().Set(0.0, 0.0);
            this.window.RenderOffset().Set(0.0, 0.0);
            float renderScale = this.window.RawRenderUnitScale();
            this.window.SetRenderUnitScale(1.0f);
            this.headerRenderer.Update();
            this.headerRenderer.Interact();
            if (this.headerRenderer.HasChanged() || this.window.RenderedOnLastCycle()) {
                this.headerRenderer.Render();
            }
            if (this.headerRenderer.HasChanged()) {
                this.window.ForceWindowDraw();
            }
            if (this.close.Clicked()) {
                this.window.ShouldClose(true);
            }
            if (this.maximize.Clicked()) {
                if (this.window.Maximized()) {
                    this.window.RestoreWindow();
                } else {
                    this.window.Maximize();
                }
            }
            if (this.minimize.Clicked()) {
                this.window.Minimize();
            }
            this.window.SetRenderUnitScale(renderScale);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void RenderForeground() {
    }

    public void CreateElements() {
        int gray = 25;
        this.renderScale = this.window.RawRenderUnitScale();
        this.window.RenderOffset().Set(0.0, 0.0);
        this.headerRenderer.ClearCycle();
        this.window.SetRenderUnitScale(1.0f);
        this.padding = this.window.RenderScale() * 4.0f;
        this.headerRenderer.AddElement(new Panel(0.0f, -this.window.Height() / 2.0f + this.padding / 2.0f, this.window.Width(), this.padding, 0.0f, gray));
        this.headerRenderer.AddElement(new Panel(this.window.Width() / 2.0f - this.padding / 2.0f, 0.0f, this.padding, this.window.Height(), 0.0f, gray));
        this.headerRenderer.AddElement(new Panel(0.0f, this.window.Height() / 2.0f - this.padding / 2.0f, this.window.Width(), this.padding, 0.0f, gray));
        this.headerRenderer.AddElement(new Panel(-this.window.Width() / 2.0f + this.padding / 2.0f, 0.0f, this.padding, this.window.Height(), 0.0f, gray));
        this.headerRenderer.AddElement(new Panel(0.0f, -this.window.Height() / 2.0f, this.window.Width(), this.padding, 0.0f, gray));
        this.headerRenderer.AddElement(new Panel(this.window.Width() / 2.0f, 0.0f, this.padding, this.window.Height(), 0.0f, gray));
        this.headerRenderer.AddElement(new Panel(0.0f, this.window.Height() / 2.0f, this.window.Width(), this.padding, 0.0f, gray));
        this.headerRenderer.AddElement(new Panel(-this.window.Width() / 2.0f, 0.0f, this.padding, this.window.Height(), 0.0f, gray));
        this.headerWidth = this.window.Width() - this.padding * 2.0f;
        this.headerHeight = 25.0f * this.window.RenderScale();
        this.headerX = 0.0f;
        this.headerY = this.window.Height() / 2.0f - this.padding - this.headerHeight / 2.0f;
        if (!this.window.NotWindowed()) {
            this.winHeader.Set(this.headerX, this.headerY, this.headerWidth, this.headerHeight);
            this.headerRenderer.AddElement(this.winHeader);
            if (!this.window.Maximized() && this.window.Resizable() && !this.winHeader.Drag()) {
                this.leftSide.Set(-this.window.CanvasWidth() / 2.0f + 5.0f, 0.0f, 10.0f, this.window.CanvasHeight());
                this.headerRenderer.AddElement(this.leftSide);
                this.rightSide.Set(this.window.CanvasWidth() / 2.0f - 5.0f, 0.0f, 10.0f, this.window.CanvasHeight());
                this.headerRenderer.AddElement(this.rightSide);
                this.topSide.Set(0.0f, this.window.CanvasHeight() / 2.0f - 5.0f, this.window.CanvasWidth(), 10.0f);
                this.headerRenderer.AddElement(this.topSide);
                this.bottomSide.Set(0.0f, -this.window.CanvasHeight() / 2.0f + 5.0f, this.window.CanvasWidth(), 10.0f);
                this.headerRenderer.AddElement(this.bottomSide);
            }
            float imageSize = this.headerHeight - this.padding;
            float imageX = this.headerX - this.headerWidth / 2.0f;
            if (this.window.TextureEngine().GetTexture("window.theme.abyss_" + this.window.window + ".icon") != null) {
                this.headerRenderer.AddElement(new Image("window.theme.abyss_" + this.window.window + ".icon", imageX += this.padding + imageSize / 2.0f, this.headerY, imageSize, imageSize, 0.0f, 255, true));
                imageX += imageSize / 2.0f;
            } else {
                String texID = "window.theme.abyss_" + this.window.window + ".icon";
                if (this.window.TextureEngine().GetTexture(texID) != null) {
                    this.window.TextureEngine().LoadFromGlobalList(texID);
                }
                this.window.RenderObjects().DrawImage(texID, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
            }
            Text headerTitle = new Text(this.window.GetTitle());
            headerTitle.Color(255);
            headerTitle.Align(0, 1);
            headerTitle.FontSize(this.headerHeight - this.padding * 2.0f);
            headerTitle.SetFont(this.Font());
            this.headerRenderer.AddElement(new TextDisplay(headerTitle, imageX + this.padding, this.headerY));
            float buttonSize = this.headerHeight - this.padding;
            this.close = new AbyssButton();
            this.close.Set("X", this.headerX + this.headerWidth / 2.0f - this.padding - buttonSize / 2.0f, this.headerY, buttonSize, buttonSize);
            this.close.SetFont(this.Font());
            this.headerRenderer.AddElement(this.close);
            this.maximize = new AbyssButton();
            this.maximize.Set("O", this.headerX + this.headerWidth / 2.0f - this.padding - buttonSize / 2.0f - buttonSize - this.padding, this.headerY, buttonSize, buttonSize);
            this.maximize.SetFont(this.Font());
            this.headerRenderer.AddElement(this.maximize);
            this.minimize = new AbyssButton();
            this.minimize.Set("-", this.headerX + this.headerWidth / 2.0f - this.padding - buttonSize / 2.0f + (-buttonSize - this.padding) * 2.0f, this.headerY, buttonSize, buttonSize);
            this.minimize.SetFont(this.Font());
            this.headerRenderer.AddElement(this.minimize);
        }
    }
}

