/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.tablebases.processors;

import com.arizotaz.tablebases.containers.Cell;
import com.arizotaz.tablebases.containers.DataBase;
import com.arizotaz.tablebases.containers.Table;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class XLSXReader {
    private File location;

    public XLSXReader(File location) {
        this.location = location;
    }

    public DataBase Read() throws EncryptedDocumentException, IOException {
        FileInputStream inp = new FileInputStream(this.location);
        Workbook wb = WorkbookFactory.create((InputStream)inp);
        int sheets = wb.getNumberOfSheets();
        DataBase db = new DataBase(this.location.getName(), sheets);
        int w = 0;
        while (w < sheets) {
            Sheet sheet = wb.getSheetAt(w);
            db.CreateTable(w, sheet.getSheetName());
            Table table = db.GetTable(w);
            Row row = sheet.getRow(0);
            if (row != null) {
                Cell[] headerCells = this.GetCellsList(row);
                String[] headers = new String[headerCells.length];
                int i = 0;
                while (i < headers.length) {
                    headers[i] = headerCells[i].toString();
                    ++i;
                }
                table.SetHeaders(headers);
            } else {
                String[] headers = new String[]{"no header data"};
                table.SetHeaders(headers);
            }
            int r = 1;
            int rows = sheet.getPhysicalNumberOfRows();
            while (r < rows) {
                Row row2 = sheet.getRow(r);
                if (row2 != null) {
                    table.AddRow(this.GetCellsList(row2));
                }
                ++r;
            }
            ++w;
        }
        return db;
    }

    private Cell[] GetCellsList(Row row) {
        short length = row.getLastCellNum();
        Cell[] tableCells = new Cell[length];
        int i = 0;
        while (i < tableCells.length) {
            tableCells[i] = this.GetCell(row.getCell(i));
            ++i;
        }
        return tableCells;
    }

    private Cell GetCell(org.apache.poi.ss.usermodel.Cell cell) {
        if (cell == null) {
            return new Cell("");
        }
        if (cell.getCellType().equals((Object)CellType.STRING)) {
            return new Cell(cell.toString());
        }
        if (cell.getCellType().equals((Object)CellType.NUMERIC)) {
            return new Cell(cell.getNumericCellValue());
        }
        if (cell.getCellType().equals((Object)CellType.NUMERIC) && DateUtil.isCellDateFormatted((org.apache.poi.ss.usermodel.Cell)cell)) {
            Date date = cell.getDateCellValue();
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
            return new Cell(dateFormat.format(date));
        }
        if (cell.getCellType().equals((Object)CellType.BOOLEAN)) {
            return new Cell(cell.getBooleanCellValue());
        }
        return new Cell(cell.toString());
    }
}

