/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.tasks;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.graalvm.buildtools.gradle.internal.GraalVMReachabilityMetadataService;
import org.graalvm.reachability.DirectoryConfiguration;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public abstract class CollectReachabilityMetadata
extends DefaultTask {
    public void setClasspath(Configuration classpath) {
        this.getRootComponent().set(classpath.getIncoming().getResolutionResult().getRootComponent());
    }

    @Input
    @Optional
    protected abstract Property<ResolvedComponentResult> getRootComponent();

    @Internal
    public abstract Property<GraalVMReachabilityMetadataService> getMetadataService();

    @Input
    @Optional
    public abstract Property<URI> getUri();

    @Input
    @Optional
    public abstract Property<String> getVersion();

    @Input
    @Optional
    public abstract SetProperty<String> getExcludedModules();

    @Input
    @Optional
    public abstract MapProperty<String, String> getModuleToConfigVersion();

    @OutputDirectory
    @Optional
    public abstract DirectoryProperty getInto();

    @TaskAction
    void copyReachabilityMetadata() throws IOException {
        if (this.getRootComponent().isPresent()) {
            GraalVMReachabilityMetadataService service = (GraalVMReachabilityMetadataService)this.getMetadataService().get();
            Set excludedModules = (Set)this.getExcludedModules().getOrElse(Collections.emptySet());
            Map forcedVersions = (Map)this.getModuleToConfigVersion().getOrElse(Collections.emptyMap());
            this.visit((ResolvedComponentResult)this.getRootComponent().get(), service, excludedModules, forcedVersions, new HashSet<ResolvedComponentResult>());
        }
    }

    private void visit(ResolvedComponentResult component, GraalVMReachabilityMetadataService service, Set<String> excludedModules, Map<String, String> forcedVersions, Set<ResolvedComponentResult> visited) throws IOException {
        if (visited.add(component)) {
            ModuleVersionIdentifier moduleVersion = component.getModuleVersion();
            Set<DirectoryConfiguration> configurations = service.findConfigurationsFor(excludedModules, forcedVersions, moduleVersion);
            DirectoryConfiguration.copy(configurations, ((Directory)this.getInto().get()).getAsFile().toPath());
            for (DependencyResult dependency : component.getDependencies()) {
                if (!(dependency instanceof ResolvedDependencyResult)) continue;
                this.visit(((ResolvedDependencyResult)dependency).getSelected(), service, excludedModules, forcedVersions, visited);
            }
        }
    }
}

