/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.bgfx.BGFXEncoderStats;
import org.lwjgl.bgfx.BGFXViewStats;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_stats_t")
public class BGFXStats
extends Struct<BGFXStats> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CPUTIMEFRAME;
    public static final int CPUTIMEBEGIN;
    public static final int CPUTIMEEND;
    public static final int CPUTIMERFREQ;
    public static final int GPUTIMEBEGIN;
    public static final int GPUTIMEEND;
    public static final int GPUTIMERFREQ;
    public static final int WAITRENDER;
    public static final int WAITSUBMIT;
    public static final int NUMDRAW;
    public static final int NUMCOMPUTE;
    public static final int NUMBLIT;
    public static final int MAXGPULATENCY;
    public static final int GPUFRAMENUM;
    public static final int NUMDYNAMICINDEXBUFFERS;
    public static final int NUMDYNAMICVERTEXBUFFERS;
    public static final int NUMFRAMEBUFFERS;
    public static final int NUMINDEXBUFFERS;
    public static final int NUMOCCLUSIONQUERIES;
    public static final int NUMPROGRAMS;
    public static final int NUMSHADERS;
    public static final int NUMTEXTURES;
    public static final int NUMUNIFORMS;
    public static final int NUMVERTEXBUFFERS;
    public static final int NUMVERTEXLAYOUTS;
    public static final int TEXTUREMEMORYUSED;
    public static final int RTMEMORYUSED;
    public static final int TRANSIENTVBUSED;
    public static final int TRANSIENTIBUSED;
    public static final int NUMPRIMS;
    public static final int GPUMEMORYMAX;
    public static final int GPUMEMORYUSED;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int TEXTWIDTH;
    public static final int TEXTHEIGHT;
    public static final int NUMVIEWS;
    public static final int VIEWSTATS;
    public static final int NUMENCODERS;
    public static final int ENCODERSTATS;

    protected BGFXStats(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected BGFXStats create(long address, @Nullable ByteBuffer container) {
        return new BGFXStats(address, container);
    }

    public BGFXStats(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), BGFXStats.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int64_t")
    public long cpuTimeFrame() {
        return BGFXStats.ncpuTimeFrame(this.address());
    }

    @NativeType(value="int64_t")
    public long cpuTimeBegin() {
        return BGFXStats.ncpuTimeBegin(this.address());
    }

    @NativeType(value="int64_t")
    public long cpuTimeEnd() {
        return BGFXStats.ncpuTimeEnd(this.address());
    }

    @NativeType(value="int64_t")
    public long cpuTimerFreq() {
        return BGFXStats.ncpuTimerFreq(this.address());
    }

    @NativeType(value="int64_t")
    public long gpuTimeBegin() {
        return BGFXStats.ngpuTimeBegin(this.address());
    }

    @NativeType(value="int64_t")
    public long gpuTimeEnd() {
        return BGFXStats.ngpuTimeEnd(this.address());
    }

    @NativeType(value="int64_t")
    public long gpuTimerFreq() {
        return BGFXStats.ngpuTimerFreq(this.address());
    }

    @NativeType(value="int64_t")
    public long waitRender() {
        return BGFXStats.nwaitRender(this.address());
    }

    @NativeType(value="int64_t")
    public long waitSubmit() {
        return BGFXStats.nwaitSubmit(this.address());
    }

    @NativeType(value="uint32_t")
    public int numDraw() {
        return BGFXStats.nnumDraw(this.address());
    }

    @NativeType(value="uint32_t")
    public int numCompute() {
        return BGFXStats.nnumCompute(this.address());
    }

    @NativeType(value="uint32_t")
    public int numBlit() {
        return BGFXStats.nnumBlit(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxGpuLatency() {
        return BGFXStats.nmaxGpuLatency(this.address());
    }

    @NativeType(value="uint32_t")
    public int gpuFrameNum() {
        return BGFXStats.ngpuFrameNum(this.address());
    }

    @NativeType(value="uint16_t")
    public short numDynamicIndexBuffers() {
        return BGFXStats.nnumDynamicIndexBuffers(this.address());
    }

    @NativeType(value="uint16_t")
    public short numDynamicVertexBuffers() {
        return BGFXStats.nnumDynamicVertexBuffers(this.address());
    }

    @NativeType(value="uint16_t")
    public short numFrameBuffers() {
        return BGFXStats.nnumFrameBuffers(this.address());
    }

    @NativeType(value="uint16_t")
    public short numIndexBuffers() {
        return BGFXStats.nnumIndexBuffers(this.address());
    }

    @NativeType(value="uint16_t")
    public short numOcclusionQueries() {
        return BGFXStats.nnumOcclusionQueries(this.address());
    }

    @NativeType(value="uint16_t")
    public short numPrograms() {
        return BGFXStats.nnumPrograms(this.address());
    }

    @NativeType(value="uint16_t")
    public short numShaders() {
        return BGFXStats.nnumShaders(this.address());
    }

    @NativeType(value="uint16_t")
    public short numTextures() {
        return BGFXStats.nnumTextures(this.address());
    }

    @NativeType(value="uint16_t")
    public short numUniforms() {
        return BGFXStats.nnumUniforms(this.address());
    }

    @NativeType(value="uint16_t")
    public short numVertexBuffers() {
        return BGFXStats.nnumVertexBuffers(this.address());
    }

    @NativeType(value="uint16_t")
    public short numVertexLayouts() {
        return BGFXStats.nnumVertexLayouts(this.address());
    }

    @NativeType(value="int64_t")
    public long textureMemoryUsed() {
        return BGFXStats.ntextureMemoryUsed(this.address());
    }

    @NativeType(value="int64_t")
    public long rtMemoryUsed() {
        return BGFXStats.nrtMemoryUsed(this.address());
    }

    @NativeType(value="int32_t")
    public int transientVbUsed() {
        return BGFXStats.ntransientVbUsed(this.address());
    }

    @NativeType(value="int32_t")
    public int transientIbUsed() {
        return BGFXStats.ntransientIbUsed(this.address());
    }

    @NativeType(value="uint32_t[BGFX_TOPOLOGY_COUNT]")
    public IntBuffer numPrims() {
        return BGFXStats.nnumPrims(this.address());
    }

    @NativeType(value="uint32_t")
    public int numPrims(int index) {
        return BGFXStats.nnumPrims(this.address(), index);
    }

    @NativeType(value="int64_t")
    public long gpuMemoryMax() {
        return BGFXStats.ngpuMemoryMax(this.address());
    }

    @NativeType(value="int64_t")
    public long gpuMemoryUsed() {
        return BGFXStats.ngpuMemoryUsed(this.address());
    }

    @NativeType(value="uint16_t")
    public short width() {
        return BGFXStats.nwidth(this.address());
    }

    @NativeType(value="uint16_t")
    public short height() {
        return BGFXStats.nheight(this.address());
    }

    @NativeType(value="uint16_t")
    public short textWidth() {
        return BGFXStats.ntextWidth(this.address());
    }

    @NativeType(value="uint16_t")
    public short textHeight() {
        return BGFXStats.ntextHeight(this.address());
    }

    @NativeType(value="uint16_t")
    public short numViews() {
        return BGFXStats.nnumViews(this.address());
    }

    @NativeType(value="bgfx_view_stats_t *")
    public BGFXViewStats.Buffer viewStats() {
        return BGFXStats.nviewStats(this.address());
    }

    @NativeType(value="uint16_t")
    public short numEncoders() {
        return BGFXStats.nnumEncoders(this.address());
    }

    @NativeType(value="bgfx_encoder_stats_t *")
    public BGFXEncoderStats.Buffer encoderStats() {
        return BGFXStats.nencoderStats(this.address());
    }

    public static BGFXStats create(long address) {
        return new BGFXStats(address, null);
    }

    public static @Nullable BGFXStats createSafe(long address) {
        return address == 0L ? null : new BGFXStats(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static long ncpuTimeFrame(long struct) {
        return MemoryUtil.memGetLong(struct + (long)CPUTIMEFRAME);
    }

    public static long ncpuTimeBegin(long struct) {
        return MemoryUtil.memGetLong(struct + (long)CPUTIMEBEGIN);
    }

    public static long ncpuTimeEnd(long struct) {
        return MemoryUtil.memGetLong(struct + (long)CPUTIMEEND);
    }

    public static long ncpuTimerFreq(long struct) {
        return MemoryUtil.memGetLong(struct + (long)CPUTIMERFREQ);
    }

    public static long ngpuTimeBegin(long struct) {
        return MemoryUtil.memGetLong(struct + (long)GPUTIMEBEGIN);
    }

    public static long ngpuTimeEnd(long struct) {
        return MemoryUtil.memGetLong(struct + (long)GPUTIMEEND);
    }

    public static long ngpuTimerFreq(long struct) {
        return MemoryUtil.memGetLong(struct + (long)GPUTIMERFREQ);
    }

    public static long nwaitRender(long struct) {
        return MemoryUtil.memGetLong(struct + (long)WAITRENDER);
    }

    public static long nwaitSubmit(long struct) {
        return MemoryUtil.memGetLong(struct + (long)WAITSUBMIT);
    }

    public static int nnumDraw(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUMDRAW);
    }

    public static int nnumCompute(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUMCOMPUTE);
    }

    public static int nnumBlit(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUMBLIT);
    }

    public static int nmaxGpuLatency(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXGPULATENCY);
    }

    public static int ngpuFrameNum(long struct) {
        return MemoryUtil.memGetInt(struct + (long)GPUFRAMENUM);
    }

    public static short nnumDynamicIndexBuffers(long struct) {
        return MemoryUtil.memGetShort(struct + (long)NUMDYNAMICINDEXBUFFERS);
    }

    public static short nnumDynamicVertexBuffers(long struct) {
        return MemoryUtil.memGetShort(struct + (long)NUMDYNAMICVERTEXBUFFERS);
    }

    public static short nnumFrameBuffers(long struct) {
        return MemoryUtil.memGetShort(struct + (long)NUMFRAMEBUFFERS);
    }

    public static short nnumIndexBuffers(long struct) {
        return MemoryUtil.memGetShort(struct + (long)NUMINDEXBUFFERS);
    }

    public static short nnumOcclusionQueries(long struct) {
        return MemoryUtil.memGetShort(struct + (long)NUMOCCLUSIONQUERIES);
    }

    public static short nnumPrograms(long struct) {
        return MemoryUtil.memGetShort(struct + (long)NUMPROGRAMS);
    }

    public static short nnumShaders(long struct) {
        return MemoryUtil.memGetShort(struct + (long)NUMSHADERS);
    }

    public static short nnumTextures(long struct) {
        return MemoryUtil.memGetShort(struct + (long)NUMTEXTURES);
    }

    public static short nnumUniforms(long struct) {
        return MemoryUtil.memGetShort(struct + (long)NUMUNIFORMS);
    }

    public static short nnumVertexBuffers(long struct) {
        return MemoryUtil.memGetShort(struct + (long)NUMVERTEXBUFFERS);
    }

    public static short nnumVertexLayouts(long struct) {
        return MemoryUtil.memGetShort(struct + (long)NUMVERTEXLAYOUTS);
    }

    public static long ntextureMemoryUsed(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TEXTUREMEMORYUSED);
    }

    public static long nrtMemoryUsed(long struct) {
        return MemoryUtil.memGetLong(struct + (long)RTMEMORYUSED);
    }

    public static int ntransientVbUsed(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TRANSIENTVBUSED);
    }

    public static int ntransientIbUsed(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TRANSIENTIBUSED);
    }

    public static IntBuffer nnumPrims(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)NUMPRIMS, 5);
    }

    public static int nnumPrims(long struct, int index) {
        return MemoryUtil.memGetInt(struct + (long)NUMPRIMS + Checks.check(index, 5) * 4L);
    }

    public static long ngpuMemoryMax(long struct) {
        return MemoryUtil.memGetLong(struct + (long)GPUMEMORYMAX);
    }

    public static long ngpuMemoryUsed(long struct) {
        return MemoryUtil.memGetLong(struct + (long)GPUMEMORYUSED);
    }

    public static short nwidth(long struct) {
        return MemoryUtil.memGetShort(struct + (long)WIDTH);
    }

    public static short nheight(long struct) {
        return MemoryUtil.memGetShort(struct + (long)HEIGHT);
    }

    public static short ntextWidth(long struct) {
        return MemoryUtil.memGetShort(struct + (long)TEXTWIDTH);
    }

    public static short ntextHeight(long struct) {
        return MemoryUtil.memGetShort(struct + (long)TEXTHEIGHT);
    }

    public static short nnumViews(long struct) {
        return MemoryUtil.memGetShort(struct + (long)NUMVIEWS);
    }

    public static BGFXViewStats.Buffer nviewStats(long struct) {
        return BGFXViewStats.create(MemoryUtil.memGetAddress(struct + (long)VIEWSTATS), Short.toUnsignedInt(BGFXStats.nnumViews(struct)));
    }

    public static short nnumEncoders(long struct) {
        return MemoryUtil.memGetShort(struct + (long)NUMENCODERS);
    }

    public static BGFXEncoderStats.Buffer nencoderStats(long struct) {
        return BGFXEncoderStats.create(MemoryUtil.memGetAddress(struct + (long)ENCODERSTATS), Short.toUnsignedInt(BGFXStats.nnumEncoders(struct)));
    }

    static {
        Struct.Layout layout = BGFXStats.__struct(BGFXStats.__member(8), BGFXStats.__member(8), BGFXStats.__member(8), BGFXStats.__member(8), BGFXStats.__member(8), BGFXStats.__member(8), BGFXStats.__member(8), BGFXStats.__member(8), BGFXStats.__member(8), BGFXStats.__member(4), BGFXStats.__member(4), BGFXStats.__member(4), BGFXStats.__member(4), BGFXStats.__member(4), BGFXStats.__member(2), BGFXStats.__member(2), BGFXStats.__member(2), BGFXStats.__member(2), BGFXStats.__member(2), BGFXStats.__member(2), BGFXStats.__member(2), BGFXStats.__member(2), BGFXStats.__member(2), BGFXStats.__member(2), BGFXStats.__member(2), BGFXStats.__member(8), BGFXStats.__member(8), BGFXStats.__member(4), BGFXStats.__member(4), BGFXStats.__array(4, 5), BGFXStats.__member(8), BGFXStats.__member(8), BGFXStats.__member(2), BGFXStats.__member(2), BGFXStats.__member(2), BGFXStats.__member(2), BGFXStats.__member(2), BGFXStats.__member(POINTER_SIZE), BGFXStats.__member(2), BGFXStats.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CPUTIMEFRAME = layout.offsetof(0);
        CPUTIMEBEGIN = layout.offsetof(1);
        CPUTIMEEND = layout.offsetof(2);
        CPUTIMERFREQ = layout.offsetof(3);
        GPUTIMEBEGIN = layout.offsetof(4);
        GPUTIMEEND = layout.offsetof(5);
        GPUTIMERFREQ = layout.offsetof(6);
        WAITRENDER = layout.offsetof(7);
        WAITSUBMIT = layout.offsetof(8);
        NUMDRAW = layout.offsetof(9);
        NUMCOMPUTE = layout.offsetof(10);
        NUMBLIT = layout.offsetof(11);
        MAXGPULATENCY = layout.offsetof(12);
        GPUFRAMENUM = layout.offsetof(13);
        NUMDYNAMICINDEXBUFFERS = layout.offsetof(14);
        NUMDYNAMICVERTEXBUFFERS = layout.offsetof(15);
        NUMFRAMEBUFFERS = layout.offsetof(16);
        NUMINDEXBUFFERS = layout.offsetof(17);
        NUMOCCLUSIONQUERIES = layout.offsetof(18);
        NUMPROGRAMS = layout.offsetof(19);
        NUMSHADERS = layout.offsetof(20);
        NUMTEXTURES = layout.offsetof(21);
        NUMUNIFORMS = layout.offsetof(22);
        NUMVERTEXBUFFERS = layout.offsetof(23);
        NUMVERTEXLAYOUTS = layout.offsetof(24);
        TEXTUREMEMORYUSED = layout.offsetof(25);
        RTMEMORYUSED = layout.offsetof(26);
        TRANSIENTVBUSED = layout.offsetof(27);
        TRANSIENTIBUSED = layout.offsetof(28);
        NUMPRIMS = layout.offsetof(29);
        GPUMEMORYMAX = layout.offsetof(30);
        GPUMEMORYUSED = layout.offsetof(31);
        WIDTH = layout.offsetof(32);
        HEIGHT = layout.offsetof(33);
        TEXTWIDTH = layout.offsetof(34);
        TEXTHEIGHT = layout.offsetof(35);
        NUMVIEWS = layout.offsetof(36);
        VIEWSTATS = layout.offsetof(37);
        NUMENCODERS = layout.offsetof(38);
        ENCODERSTATS = layout.offsetof(39);
    }

    public static class Buffer
    extends StructBuffer<BGFXStats, Buffer> {
        private static final BGFXStats ELEMENT_FACTORY = BGFXStats.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected BGFXStats getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int64_t")
        public long cpuTimeFrame() {
            return BGFXStats.ncpuTimeFrame(this.address());
        }

        @NativeType(value="int64_t")
        public long cpuTimeBegin() {
            return BGFXStats.ncpuTimeBegin(this.address());
        }

        @NativeType(value="int64_t")
        public long cpuTimeEnd() {
            return BGFXStats.ncpuTimeEnd(this.address());
        }

        @NativeType(value="int64_t")
        public long cpuTimerFreq() {
            return BGFXStats.ncpuTimerFreq(this.address());
        }

        @NativeType(value="int64_t")
        public long gpuTimeBegin() {
            return BGFXStats.ngpuTimeBegin(this.address());
        }

        @NativeType(value="int64_t")
        public long gpuTimeEnd() {
            return BGFXStats.ngpuTimeEnd(this.address());
        }

        @NativeType(value="int64_t")
        public long gpuTimerFreq() {
            return BGFXStats.ngpuTimerFreq(this.address());
        }

        @NativeType(value="int64_t")
        public long waitRender() {
            return BGFXStats.nwaitRender(this.address());
        }

        @NativeType(value="int64_t")
        public long waitSubmit() {
            return BGFXStats.nwaitSubmit(this.address());
        }

        @NativeType(value="uint32_t")
        public int numDraw() {
            return BGFXStats.nnumDraw(this.address());
        }

        @NativeType(value="uint32_t")
        public int numCompute() {
            return BGFXStats.nnumCompute(this.address());
        }

        @NativeType(value="uint32_t")
        public int numBlit() {
            return BGFXStats.nnumBlit(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxGpuLatency() {
            return BGFXStats.nmaxGpuLatency(this.address());
        }

        @NativeType(value="uint32_t")
        public int gpuFrameNum() {
            return BGFXStats.ngpuFrameNum(this.address());
        }

        @NativeType(value="uint16_t")
        public short numDynamicIndexBuffers() {
            return BGFXStats.nnumDynamicIndexBuffers(this.address());
        }

        @NativeType(value="uint16_t")
        public short numDynamicVertexBuffers() {
            return BGFXStats.nnumDynamicVertexBuffers(this.address());
        }

        @NativeType(value="uint16_t")
        public short numFrameBuffers() {
            return BGFXStats.nnumFrameBuffers(this.address());
        }

        @NativeType(value="uint16_t")
        public short numIndexBuffers() {
            return BGFXStats.nnumIndexBuffers(this.address());
        }

        @NativeType(value="uint16_t")
        public short numOcclusionQueries() {
            return BGFXStats.nnumOcclusionQueries(this.address());
        }

        @NativeType(value="uint16_t")
        public short numPrograms() {
            return BGFXStats.nnumPrograms(this.address());
        }

        @NativeType(value="uint16_t")
        public short numShaders() {
            return BGFXStats.nnumShaders(this.address());
        }

        @NativeType(value="uint16_t")
        public short numTextures() {
            return BGFXStats.nnumTextures(this.address());
        }

        @NativeType(value="uint16_t")
        public short numUniforms() {
            return BGFXStats.nnumUniforms(this.address());
        }

        @NativeType(value="uint16_t")
        public short numVertexBuffers() {
            return BGFXStats.nnumVertexBuffers(this.address());
        }

        @NativeType(value="uint16_t")
        public short numVertexLayouts() {
            return BGFXStats.nnumVertexLayouts(this.address());
        }

        @NativeType(value="int64_t")
        public long textureMemoryUsed() {
            return BGFXStats.ntextureMemoryUsed(this.address());
        }

        @NativeType(value="int64_t")
        public long rtMemoryUsed() {
            return BGFXStats.nrtMemoryUsed(this.address());
        }

        @NativeType(value="int32_t")
        public int transientVbUsed() {
            return BGFXStats.ntransientVbUsed(this.address());
        }

        @NativeType(value="int32_t")
        public int transientIbUsed() {
            return BGFXStats.ntransientIbUsed(this.address());
        }

        @NativeType(value="uint32_t[BGFX_TOPOLOGY_COUNT]")
        public IntBuffer numPrims() {
            return BGFXStats.nnumPrims(this.address());
        }

        @NativeType(value="uint32_t")
        public int numPrims(int index) {
            return BGFXStats.nnumPrims(this.address(), index);
        }

        @NativeType(value="int64_t")
        public long gpuMemoryMax() {
            return BGFXStats.ngpuMemoryMax(this.address());
        }

        @NativeType(value="int64_t")
        public long gpuMemoryUsed() {
            return BGFXStats.ngpuMemoryUsed(this.address());
        }

        @NativeType(value="uint16_t")
        public short width() {
            return BGFXStats.nwidth(this.address());
        }

        @NativeType(value="uint16_t")
        public short height() {
            return BGFXStats.nheight(this.address());
        }

        @NativeType(value="uint16_t")
        public short textWidth() {
            return BGFXStats.ntextWidth(this.address());
        }

        @NativeType(value="uint16_t")
        public short textHeight() {
            return BGFXStats.ntextHeight(this.address());
        }

        @NativeType(value="uint16_t")
        public short numViews() {
            return BGFXStats.nnumViews(this.address());
        }

        @NativeType(value="bgfx_view_stats_t *")
        public BGFXViewStats.Buffer viewStats() {
            return BGFXStats.nviewStats(this.address());
        }

        @NativeType(value="uint16_t")
        public short numEncoders() {
            return BGFXStats.nnumEncoders(this.address());
        }

        @NativeType(value="bgfx_encoder_stats_t *")
        public BGFXEncoderStats.Buffer encoderStats() {
            return BGFXStats.nencoderStats(this.address());
        }
    }
}

