/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_transient_index_buffer_t")
public class BGFXTransientIndexBuffer
extends Struct<BGFXTransientIndexBuffer>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int SIZE;
    public static final int STARTINDEX;
    public static final int HANDLE;
    public static final int ISINDEX16;

    protected BGFXTransientIndexBuffer(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected BGFXTransientIndexBuffer create(long address, @Nullable ByteBuffer container) {
        return new BGFXTransientIndexBuffer(address, container);
    }

    public BGFXTransientIndexBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), BGFXTransientIndexBuffer.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t *")
    public ByteBuffer data() {
        return BGFXTransientIndexBuffer.ndata(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return BGFXTransientIndexBuffer.nsize(this.address());
    }

    @NativeType(value="uint32_t")
    public int startIndex() {
        return BGFXTransientIndexBuffer.nstartIndex(this.address());
    }

    @NativeType(value="bgfx_index_buffer_handle_t")
    public short handle() {
        return BGFXTransientIndexBuffer.nhandle(this.address());
    }

    @NativeType(value="bool")
    public boolean isIndex16() {
        return BGFXTransientIndexBuffer.nisIndex16(this.address());
    }

    public BGFXTransientIndexBuffer data(@NativeType(value="uint8_t *") ByteBuffer value) {
        BGFXTransientIndexBuffer.ndata(this.address(), value);
        return this;
    }

    public BGFXTransientIndexBuffer startIndex(@NativeType(value="uint32_t") int value) {
        BGFXTransientIndexBuffer.nstartIndex(this.address(), value);
        return this;
    }

    public BGFXTransientIndexBuffer handle(@NativeType(value="bgfx_index_buffer_handle_t") short value) {
        BGFXTransientIndexBuffer.nhandle(this.address(), value);
        return this;
    }

    public BGFXTransientIndexBuffer isIndex16(@NativeType(value="bool") boolean value) {
        BGFXTransientIndexBuffer.nisIndex16(this.address(), value);
        return this;
    }

    public BGFXTransientIndexBuffer set(ByteBuffer data, int startIndex, short handle, boolean isIndex16) {
        this.data(data);
        this.startIndex(startIndex);
        this.handle(handle);
        this.isIndex16(isIndex16);
        return this;
    }

    public BGFXTransientIndexBuffer set(BGFXTransientIndexBuffer src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXTransientIndexBuffer malloc() {
        return new BGFXTransientIndexBuffer(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static BGFXTransientIndexBuffer calloc() {
        return new BGFXTransientIndexBuffer(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static BGFXTransientIndexBuffer create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new BGFXTransientIndexBuffer(MemoryUtil.memAddress(container), container);
    }

    public static BGFXTransientIndexBuffer create(long address) {
        return new BGFXTransientIndexBuffer(address, null);
    }

    public static @Nullable BGFXTransientIndexBuffer createSafe(long address) {
        return address == 0L ? null : new BGFXTransientIndexBuffer(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(BGFXTransientIndexBuffer.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = BGFXTransientIndexBuffer.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static BGFXTransientIndexBuffer mallocStack() {
        return BGFXTransientIndexBuffer.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXTransientIndexBuffer callocStack() {
        return BGFXTransientIndexBuffer.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXTransientIndexBuffer mallocStack(MemoryStack stack) {
        return BGFXTransientIndexBuffer.malloc(stack);
    }

    @Deprecated
    public static BGFXTransientIndexBuffer callocStack(MemoryStack stack) {
        return BGFXTransientIndexBuffer.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return BGFXTransientIndexBuffer.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return BGFXTransientIndexBuffer.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXTransientIndexBuffer.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXTransientIndexBuffer.calloc(capacity, stack);
    }

    public static BGFXTransientIndexBuffer malloc(MemoryStack stack) {
        return new BGFXTransientIndexBuffer(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static BGFXTransientIndexBuffer calloc(MemoryStack stack) {
        return new BGFXTransientIndexBuffer(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)DATA), BGFXTransientIndexBuffer.nsize(struct));
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SIZE);
    }

    public static int nstartIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STARTINDEX);
    }

    public static short nhandle(long struct) {
        return MemoryUtil.memGetShort(struct + (long)HANDLE);
    }

    public static boolean nisIndex16(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ISINDEX16) != 0;
    }

    public static void ndata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)DATA, MemoryUtil.memAddress(value));
        BGFXTransientIndexBuffer.nsize(struct, value.remaining());
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SIZE, value);
    }

    public static void nstartIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STARTINDEX, value);
    }

    public static void nhandle(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)HANDLE, value);
    }

    public static void nisIndex16(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)ISINDEX16, value ? (byte)1 : 0);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DATA));
    }

    static {
        Struct.Layout layout = BGFXTransientIndexBuffer.__struct(BGFXTransientIndexBuffer.__member(POINTER_SIZE), BGFXTransientIndexBuffer.__member(4), BGFXTransientIndexBuffer.__member(4), BGFXTransientIndexBuffer.__member(2), BGFXTransientIndexBuffer.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        STARTINDEX = layout.offsetof(2);
        HANDLE = layout.offsetof(3);
        ISINDEX16 = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<BGFXTransientIndexBuffer, Buffer>
    implements NativeResource {
        private static final BGFXTransientIndexBuffer ELEMENT_FACTORY = BGFXTransientIndexBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected BGFXTransientIndexBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t *")
        public ByteBuffer data() {
            return BGFXTransientIndexBuffer.ndata(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return BGFXTransientIndexBuffer.nsize(this.address());
        }

        @NativeType(value="uint32_t")
        public int startIndex() {
            return BGFXTransientIndexBuffer.nstartIndex(this.address());
        }

        @NativeType(value="bgfx_index_buffer_handle_t")
        public short handle() {
            return BGFXTransientIndexBuffer.nhandle(this.address());
        }

        @NativeType(value="bool")
        public boolean isIndex16() {
            return BGFXTransientIndexBuffer.nisIndex16(this.address());
        }

        public Buffer data(@NativeType(value="uint8_t *") ByteBuffer value) {
            BGFXTransientIndexBuffer.ndata(this.address(), value);
            return this;
        }

        public Buffer startIndex(@NativeType(value="uint32_t") int value) {
            BGFXTransientIndexBuffer.nstartIndex(this.address(), value);
            return this;
        }

        public Buffer handle(@NativeType(value="bgfx_index_buffer_handle_t") short value) {
            BGFXTransientIndexBuffer.nhandle(this.address(), value);
            return this;
        }

        public Buffer isIndex16(@NativeType(value="bool") boolean value) {
            BGFXTransientIndexBuffer.nisIndex16(this.address(), value);
            return this;
        }
    }
}

