/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_transient_vertex_buffer_t")
public class BGFXTransientVertexBuffer
extends Struct<BGFXTransientVertexBuffer>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int SIZE;
    public static final int STARTVERTEX;
    public static final int STRIDE;
    public static final int HANDLE;
    public static final int LAYOUTHANDLE;

    protected BGFXTransientVertexBuffer(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected BGFXTransientVertexBuffer create(long address, @Nullable ByteBuffer container) {
        return new BGFXTransientVertexBuffer(address, container);
    }

    public BGFXTransientVertexBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), BGFXTransientVertexBuffer.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t *")
    public ByteBuffer data() {
        return BGFXTransientVertexBuffer.ndata(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return BGFXTransientVertexBuffer.nsize(this.address());
    }

    @NativeType(value="uint32_t")
    public int startVertex() {
        return BGFXTransientVertexBuffer.nstartVertex(this.address());
    }

    @NativeType(value="uint16_t")
    public short stride() {
        return BGFXTransientVertexBuffer.nstride(this.address());
    }

    @NativeType(value="bgfx_vertex_buffer_handle_t")
    public short handle() {
        return BGFXTransientVertexBuffer.nhandle(this.address());
    }

    @NativeType(value="bgfx_vertex_layout_handle_t")
    public short layoutHandle() {
        return BGFXTransientVertexBuffer.nlayoutHandle(this.address());
    }

    public BGFXTransientVertexBuffer data(@NativeType(value="uint8_t *") ByteBuffer value) {
        BGFXTransientVertexBuffer.ndata(this.address(), value);
        return this;
    }

    public BGFXTransientVertexBuffer startVertex(@NativeType(value="uint32_t") int value) {
        BGFXTransientVertexBuffer.nstartVertex(this.address(), value);
        return this;
    }

    public BGFXTransientVertexBuffer stride(@NativeType(value="uint16_t") short value) {
        BGFXTransientVertexBuffer.nstride(this.address(), value);
        return this;
    }

    public BGFXTransientVertexBuffer handle(@NativeType(value="bgfx_vertex_buffer_handle_t") short value) {
        BGFXTransientVertexBuffer.nhandle(this.address(), value);
        return this;
    }

    public BGFXTransientVertexBuffer layoutHandle(@NativeType(value="bgfx_vertex_layout_handle_t") short value) {
        BGFXTransientVertexBuffer.nlayoutHandle(this.address(), value);
        return this;
    }

    public BGFXTransientVertexBuffer set(ByteBuffer data, int startVertex, short stride, short handle, short layoutHandle) {
        this.data(data);
        this.startVertex(startVertex);
        this.stride(stride);
        this.handle(handle);
        this.layoutHandle(layoutHandle);
        return this;
    }

    public BGFXTransientVertexBuffer set(BGFXTransientVertexBuffer src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXTransientVertexBuffer malloc() {
        return new BGFXTransientVertexBuffer(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static BGFXTransientVertexBuffer calloc() {
        return new BGFXTransientVertexBuffer(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static BGFXTransientVertexBuffer create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new BGFXTransientVertexBuffer(MemoryUtil.memAddress(container), container);
    }

    public static BGFXTransientVertexBuffer create(long address) {
        return new BGFXTransientVertexBuffer(address, null);
    }

    public static @Nullable BGFXTransientVertexBuffer createSafe(long address) {
        return address == 0L ? null : new BGFXTransientVertexBuffer(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(BGFXTransientVertexBuffer.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = BGFXTransientVertexBuffer.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static BGFXTransientVertexBuffer mallocStack() {
        return BGFXTransientVertexBuffer.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXTransientVertexBuffer callocStack() {
        return BGFXTransientVertexBuffer.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXTransientVertexBuffer mallocStack(MemoryStack stack) {
        return BGFXTransientVertexBuffer.malloc(stack);
    }

    @Deprecated
    public static BGFXTransientVertexBuffer callocStack(MemoryStack stack) {
        return BGFXTransientVertexBuffer.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return BGFXTransientVertexBuffer.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return BGFXTransientVertexBuffer.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXTransientVertexBuffer.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXTransientVertexBuffer.calloc(capacity, stack);
    }

    public static BGFXTransientVertexBuffer malloc(MemoryStack stack) {
        return new BGFXTransientVertexBuffer(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static BGFXTransientVertexBuffer calloc(MemoryStack stack) {
        return new BGFXTransientVertexBuffer(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)DATA), BGFXTransientVertexBuffer.nsize(struct));
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SIZE);
    }

    public static int nstartVertex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STARTVERTEX);
    }

    public static short nstride(long struct) {
        return MemoryUtil.memGetShort(struct + (long)STRIDE);
    }

    public static short nhandle(long struct) {
        return MemoryUtil.memGetShort(struct + (long)HANDLE);
    }

    public static short nlayoutHandle(long struct) {
        return MemoryUtil.memGetShort(struct + (long)LAYOUTHANDLE);
    }

    public static void ndata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)DATA, MemoryUtil.memAddress(value));
        BGFXTransientVertexBuffer.nsize(struct, value.remaining());
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SIZE, value);
    }

    public static void nstartVertex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STARTVERTEX, value);
    }

    public static void nstride(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)STRIDE, value);
    }

    public static void nhandle(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)HANDLE, value);
    }

    public static void nlayoutHandle(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)LAYOUTHANDLE, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DATA));
    }

    static {
        Struct.Layout layout = BGFXTransientVertexBuffer.__struct(BGFXTransientVertexBuffer.__member(POINTER_SIZE), BGFXTransientVertexBuffer.__member(4), BGFXTransientVertexBuffer.__member(4), BGFXTransientVertexBuffer.__member(2), BGFXTransientVertexBuffer.__member(2), BGFXTransientVertexBuffer.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        STARTVERTEX = layout.offsetof(2);
        STRIDE = layout.offsetof(3);
        HANDLE = layout.offsetof(4);
        LAYOUTHANDLE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<BGFXTransientVertexBuffer, Buffer>
    implements NativeResource {
        private static final BGFXTransientVertexBuffer ELEMENT_FACTORY = BGFXTransientVertexBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected BGFXTransientVertexBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t *")
        public ByteBuffer data() {
            return BGFXTransientVertexBuffer.ndata(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return BGFXTransientVertexBuffer.nsize(this.address());
        }

        @NativeType(value="uint32_t")
        public int startVertex() {
            return BGFXTransientVertexBuffer.nstartVertex(this.address());
        }

        @NativeType(value="uint16_t")
        public short stride() {
            return BGFXTransientVertexBuffer.nstride(this.address());
        }

        @NativeType(value="bgfx_vertex_buffer_handle_t")
        public short handle() {
            return BGFXTransientVertexBuffer.nhandle(this.address());
        }

        @NativeType(value="bgfx_vertex_layout_handle_t")
        public short layoutHandle() {
            return BGFXTransientVertexBuffer.nlayoutHandle(this.address());
        }

        public Buffer data(@NativeType(value="uint8_t *") ByteBuffer value) {
            BGFXTransientVertexBuffer.ndata(this.address(), value);
            return this;
        }

        public Buffer startVertex(@NativeType(value="uint32_t") int value) {
            BGFXTransientVertexBuffer.nstartVertex(this.address(), value);
            return this;
        }

        public Buffer stride(@NativeType(value="uint16_t") short value) {
            BGFXTransientVertexBuffer.nstride(this.address(), value);
            return this;
        }

        public Buffer handle(@NativeType(value="bgfx_vertex_buffer_handle_t") short value) {
            BGFXTransientVertexBuffer.nhandle(this.address(), value);
            return this;
        }

        public Buffer layoutHandle(@NativeType(value="bgfx_vertex_layout_handle_t") short value) {
            BGFXTransientVertexBuffer.nlayoutHandle(this.address(), value);
            return this;
        }
    }
}

