/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_uniform_info_t")
public class BGFXUniformInfo
extends Struct<BGFXUniformInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int TYPE;
    public static final int NUM;

    protected BGFXUniformInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected BGFXUniformInfo create(long address, @Nullable ByteBuffer container) {
        return new BGFXUniformInfo(address, container);
    }

    public BGFXUniformInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), BGFXUniformInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[256]")
    public ByteBuffer name() {
        return BGFXUniformInfo.nname(this.address());
    }

    @NativeType(value="char[256]")
    public String nameString() {
        return BGFXUniformInfo.nnameString(this.address());
    }

    @NativeType(value="bgfx_uniform_type_t")
    public int type() {
        return BGFXUniformInfo.ntype(this.address());
    }

    @NativeType(value="uint16_t")
    public short num() {
        return BGFXUniformInfo.nnum(this.address());
    }

    public BGFXUniformInfo name(@NativeType(value="char[256]") ByteBuffer value) {
        BGFXUniformInfo.nname(this.address(), value);
        return this;
    }

    public BGFXUniformInfo type(@NativeType(value="bgfx_uniform_type_t") int value) {
        BGFXUniformInfo.ntype(this.address(), value);
        return this;
    }

    public BGFXUniformInfo num(@NativeType(value="uint16_t") short value) {
        BGFXUniformInfo.nnum(this.address(), value);
        return this;
    }

    public BGFXUniformInfo set(ByteBuffer name, int type, short num) {
        this.name(name);
        this.type(type);
        this.num(num);
        return this;
    }

    public BGFXUniformInfo set(BGFXUniformInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXUniformInfo malloc() {
        return new BGFXUniformInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static BGFXUniformInfo calloc() {
        return new BGFXUniformInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static BGFXUniformInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new BGFXUniformInfo(MemoryUtil.memAddress(container), container);
    }

    public static BGFXUniformInfo create(long address) {
        return new BGFXUniformInfo(address, null);
    }

    public static @Nullable BGFXUniformInfo createSafe(long address) {
        return address == 0L ? null : new BGFXUniformInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(BGFXUniformInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = BGFXUniformInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static BGFXUniformInfo mallocStack() {
        return BGFXUniformInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXUniformInfo callocStack() {
        return BGFXUniformInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXUniformInfo mallocStack(MemoryStack stack) {
        return BGFXUniformInfo.malloc(stack);
    }

    @Deprecated
    public static BGFXUniformInfo callocStack(MemoryStack stack) {
        return BGFXUniformInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return BGFXUniformInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return BGFXUniformInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXUniformInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXUniformInfo.calloc(capacity, stack);
    }

    public static BGFXUniformInfo malloc(MemoryStack stack) {
        return new BGFXUniformInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static BGFXUniformInfo calloc(MemoryStack stack) {
        return new BGFXUniformInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)NAME, 256);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memASCII(struct + (long)NAME);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static short nnum(long struct) {
        return MemoryUtil.memGetShort(struct + (long)NUM);
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 256);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)NAME, value.remaining());
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnum(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)NUM, value);
    }

    static {
        Struct.Layout layout = BGFXUniformInfo.__struct(BGFXUniformInfo.__array(1, 256), BGFXUniformInfo.__member(4), BGFXUniformInfo.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        TYPE = layout.offsetof(1);
        NUM = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<BGFXUniformInfo, Buffer>
    implements NativeResource {
        private static final BGFXUniformInfo ELEMENT_FACTORY = BGFXUniformInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected BGFXUniformInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[256]")
        public ByteBuffer name() {
            return BGFXUniformInfo.nname(this.address());
        }

        @NativeType(value="char[256]")
        public String nameString() {
            return BGFXUniformInfo.nnameString(this.address());
        }

        @NativeType(value="bgfx_uniform_type_t")
        public int type() {
            return BGFXUniformInfo.ntype(this.address());
        }

        @NativeType(value="uint16_t")
        public short num() {
            return BGFXUniformInfo.nnum(this.address());
        }

        public Buffer name(@NativeType(value="char[256]") ByteBuffer value) {
            BGFXUniformInfo.nname(this.address(), value);
            return this;
        }

        public Buffer type(@NativeType(value="bgfx_uniform_type_t") int value) {
            BGFXUniformInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer num(@NativeType(value="uint16_t") short value) {
            BGFXUniformInfo.nnum(this.address(), value);
            return this;
        }
    }
}

