/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.lwjgl.cuda.CU;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Library;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;

public final class CUDA {
    private static final String TOOLKIT_DEFAULT_ROOT;
    private static final String TOOLKIT_PREFIX;
    private static final Pattern TOOLKIT_REGEX;

    private CUDA() {
    }

    public static boolean isPerThreadDefaultStreamSupported() {
        try (SharedLibrary lib = Library.loadNative(CU.class, "org.lwjgl.cuda", Configuration.CUDA_LIBRARY_NAME, "nvcuda");){
            boolean bl = lib.getFunctionAddress("cuLaunchKernel_ptsz") != 0L;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Path getToolkitPath() {
        Path toolkit;
        String toolkitPath = Configuration.CUDA_TOOLKIT_PATH.get();
        if (toolkitPath != null) {
            return Paths.get(toolkitPath, new String[0]);
        }
        String version = Configuration.CUDA_TOOLKIT_VERSION.get();
        if (version != null && Files.isDirectory(toolkit = Paths.get(TOOLKIT_DEFAULT_ROOT + TOOLKIT_PREFIX + version, new String[0]), new LinkOption[0])) {
            return toolkit;
        }
        Path root = Paths.get(TOOLKIT_DEFAULT_ROOT, new String[0]);
        if (!Files.isDirectory(root, new LinkOption[0])) {
            throw new IllegalStateException("Failed to find CUDA Toolkit root path.");
        }
        try (Stream<Path> directories = Files.find(root, 1, (path, basicFileAttributes) -> basicFileAttributes.isDirectory() && TOOLKIT_REGEX.matcher(path.getFileName().toString()).matches(), new FileVisitOption[0]);){
            Path path2 = directories.max(Comparator.comparing(path -> {
                Matcher m = TOOLKIT_REGEX.matcher(path.getFileName().toString());
                if (!m.find()) {
                    throw new IllegalStateException();
                }
                return APIUtil.apiParseVersion(m.group(1));
            })).orElseThrow(() -> new IllegalStateException("Failed to find CUDA Toolkit path."));
            return path2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getToolkitLibrary(String name) {
        Path toolkit = CUDA.getToolkitPath();
        switch (Platform.get()) {
            case FREEBSD: 
            case LINUX: 
            case MACOSX: {
                toolkit = toolkit.resolve("lib");
                break;
            }
            case WINDOWS: {
                toolkit = toolkit.resolve("bin");
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (!Files.isDirectory(toolkit, new LinkOption[0])) {
            throw new IllegalStateException();
        }
        try (Stream<Path> files = Files.find(toolkit, 1, (path, basicFileAttributes) -> {
            if (basicFileAttributes.isRegularFile()) {
                String fileName = path.getFileName().toString();
                switch (Platform.get()) {
                    case FREEBSD: 
                    case LINUX: {
                        if (!fileName.startsWith("lib" + name) || !fileName.endsWith(".so")) break;
                        return true;
                    }
                    case MACOSX: {
                        if (!fileName.startsWith("lib" + name) || !fileName.endsWith(".dylib")) break;
                        return true;
                    }
                    case WINDOWS: {
                        if (!fileName.startsWith(name + "64") || !fileName.endsWith(".dll")) break;
                        return true;
                    }
                }
            }
            return false;
        }, new FileVisitOption[0]);){
            String string = files.findAny().map(path -> path.toAbsolutePath().toString()).orElseThrow(IllegalStateException::new);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static SharedLibrary getToolkitLibrary(Class<?> context, Configuration<String> option, String name) {
        return Library.loadNative(context, "org.lwjgl.cuda", option, () -> Library.loadNative(context, "org.lwjgl.cuda", CUDA.getToolkitLibrary(name)), name);
    }

    static String __CUDA_API_PTDS(String api) {
        return Configuration.CUDA_API_PER_THREAD_DEFAULT_STREAM.get(false) != false ? api + "_ptds" : api;
    }

    static String __CUDA_API_PTSZ(String api) {
        return Configuration.CUDA_API_PER_THREAD_DEFAULT_STREAM.get(false) != false ? api + "_ptsz" : api;
    }

    static String __CUDA_API_VERSION(String api, int version) {
        SharedLibrary CUDA2 = CU.getLibrary();
        for (int i = version; 1 < i; --i) {
            String functionName = api + "_v" + i;
            if (CUDA2.getFunctionAddress(functionName) == 0L) continue;
            return functionName;
        }
        return api;
    }

    static {
        switch (Platform.get()) {
            case FREEBSD: 
            case LINUX: {
                TOOLKIT_DEFAULT_ROOT = "/usr/local/";
                TOOLKIT_PREFIX = "cuda-";
                break;
            }
            case MACOSX: {
                TOOLKIT_DEFAULT_ROOT = "/Developer/NVIDIA/";
                TOOLKIT_PREFIX = "CUDA-";
                break;
            }
            case WINDOWS: {
                TOOLKIT_DEFAULT_ROOT = "C:/Program Files/NVIDIA GPU Computing Toolkit/CUDA/";
                TOOLKIT_PREFIX = "v";
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        TOOLKIT_REGEX = Pattern.compile("^" + TOOLKIT_PREFIX + "(\\d+\\.\\d+)$");
    }
}

