/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_EXTERNAL_MEMORY_HANDLE_DESC
extends Struct<CUDA_EXTERNAL_MEMORY_HANDLE_DESC>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int HANDLE;
    public static final int HANDLE_FD;
    public static final int HANDLE_WIN32;
    public static final int HANDLE_WIN32_HANDLE;
    public static final int HANDLE_WIN32_NAME;
    public static final int HANDLE_NVSCIBUFOBJECT;
    public static final int SIZE;
    public static final int FLAGS;
    public static final int RESERVED;

    protected CUDA_EXTERNAL_MEMORY_HANDLE_DESC(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CUDA_EXTERNAL_MEMORY_HANDLE_DESC create(long address, @Nullable ByteBuffer container) {
        return new CUDA_EXTERNAL_MEMORY_HANDLE_DESC(address, container);
    }

    public CUDA_EXTERNAL_MEMORY_HANDLE_DESC(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUDA_EXTERNAL_MEMORY_HANDLE_DESC.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUexternalMemoryHandleType")
    public int type() {
        return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.ntype(this.address());
    }

    public int handle_fd() {
        return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nhandle_fd(this.address());
    }

    @NativeType(value="void *")
    public long handle_win32_handle() {
        return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nhandle_win32_handle(this.address());
    }

    @NativeType(value="void const *")
    public long handle_win32_name() {
        return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nhandle_win32_name(this.address());
    }

    @NativeType(value="void const *")
    public long handle_nvSciBufObject() {
        return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nhandle_nvSciBufObject(this.address());
    }

    @NativeType(value="unsigned long long")
    public long size() {
        return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nsize(this.address());
    }

    @NativeType(value="unsigned int")
    public int flags() {
        return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nflags(this.address());
    }

    @NativeType(value="unsigned int[16]")
    public IntBuffer reserved() {
        return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nreserved(this.address());
    }

    @NativeType(value="unsigned int")
    public int reserved(int index) {
        return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nreserved(this.address(), index);
    }

    public CUDA_EXTERNAL_MEMORY_HANDLE_DESC type(@NativeType(value="CUexternalMemoryHandleType") int value) {
        CUDA_EXTERNAL_MEMORY_HANDLE_DESC.ntype(this.address(), value);
        return this;
    }

    public CUDA_EXTERNAL_MEMORY_HANDLE_DESC handle_fd(int value) {
        CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nhandle_fd(this.address(), value);
        return this;
    }

    public CUDA_EXTERNAL_MEMORY_HANDLE_DESC handle_win32_handle(@NativeType(value="void *") long value) {
        CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nhandle_win32_handle(this.address(), value);
        return this;
    }

    public CUDA_EXTERNAL_MEMORY_HANDLE_DESC handle_win32_name(@NativeType(value="void const *") long value) {
        CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nhandle_win32_name(this.address(), value);
        return this;
    }

    public CUDA_EXTERNAL_MEMORY_HANDLE_DESC handle_nvSciBufObject(@NativeType(value="void const *") long value) {
        CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nhandle_nvSciBufObject(this.address(), value);
        return this;
    }

    public CUDA_EXTERNAL_MEMORY_HANDLE_DESC size(@NativeType(value="unsigned long long") long value) {
        CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nsize(this.address(), value);
        return this;
    }

    public CUDA_EXTERNAL_MEMORY_HANDLE_DESC flags(@NativeType(value="unsigned int") int value) {
        CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nflags(this.address(), value);
        return this;
    }

    public CUDA_EXTERNAL_MEMORY_HANDLE_DESC reserved(@NativeType(value="unsigned int[16]") IntBuffer value) {
        CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nreserved(this.address(), value);
        return this;
    }

    public CUDA_EXTERNAL_MEMORY_HANDLE_DESC reserved(int index, @NativeType(value="unsigned int") int value) {
        CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nreserved(this.address(), index, value);
        return this;
    }

    public CUDA_EXTERNAL_MEMORY_HANDLE_DESC set(CUDA_EXTERNAL_MEMORY_HANDLE_DESC src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUDA_EXTERNAL_MEMORY_HANDLE_DESC malloc() {
        return new CUDA_EXTERNAL_MEMORY_HANDLE_DESC(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CUDA_EXTERNAL_MEMORY_HANDLE_DESC calloc() {
        return new CUDA_EXTERNAL_MEMORY_HANDLE_DESC(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CUDA_EXTERNAL_MEMORY_HANDLE_DESC create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CUDA_EXTERNAL_MEMORY_HANDLE_DESC(MemoryUtil.memAddress(container), container);
    }

    public static CUDA_EXTERNAL_MEMORY_HANDLE_DESC create(long address) {
        return new CUDA_EXTERNAL_MEMORY_HANDLE_DESC(address, null);
    }

    public static @Nullable CUDA_EXTERNAL_MEMORY_HANDLE_DESC createSafe(long address) {
        return address == 0L ? null : new CUDA_EXTERNAL_MEMORY_HANDLE_DESC(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CUDA_EXTERNAL_MEMORY_HANDLE_DESC.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_EXTERNAL_MEMORY_HANDLE_DESC.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CUDA_EXTERNAL_MEMORY_HANDLE_DESC mallocStack() {
        return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_EXTERNAL_MEMORY_HANDLE_DESC callocStack() {
        return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_EXTERNAL_MEMORY_HANDLE_DESC mallocStack(MemoryStack stack) {
        return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.malloc(stack);
    }

    @Deprecated
    public static CUDA_EXTERNAL_MEMORY_HANDLE_DESC callocStack(MemoryStack stack) {
        return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.calloc(capacity, stack);
    }

    public static CUDA_EXTERNAL_MEMORY_HANDLE_DESC malloc(MemoryStack stack) {
        return new CUDA_EXTERNAL_MEMORY_HANDLE_DESC(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUDA_EXTERNAL_MEMORY_HANDLE_DESC calloc(MemoryStack stack) {
        return new CUDA_EXTERNAL_MEMORY_HANDLE_DESC(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int nhandle_fd(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HANDLE_FD);
    }

    public static long nhandle_win32_handle(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HANDLE_WIN32_HANDLE);
    }

    public static long nhandle_win32_name(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HANDLE_WIN32_NAME);
    }

    public static long nhandle_nvSciBufObject(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HANDLE_NVSCIBUFOBJECT);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SIZE);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static IntBuffer nreserved(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)RESERVED, 16);
    }

    public static int nreserved(long struct, int index) {
        return MemoryUtil.memGetInt(struct + (long)RESERVED + Checks.check(index, 16) * 4L);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nhandle_fd(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HANDLE_FD, value);
    }

    public static void nhandle_win32_handle(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HANDLE_WIN32_HANDLE, value);
    }

    public static void nhandle_win32_name(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HANDLE_WIN32_NAME, value);
    }

    public static void nhandle_nvSciBufObject(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HANDLE_NVSCIBUFOBJECT, value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SIZE, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nreserved(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 16);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RESERVED, value.remaining() * 4);
    }

    public static void nreserved(long struct, int index, int value) {
        MemoryUtil.memPutInt(struct + (long)RESERVED + Checks.check(index, 16) * 4L, value);
    }

    static {
        Struct.Layout layout = CUDA_EXTERNAL_MEMORY_HANDLE_DESC.__struct(CUDA_EXTERNAL_MEMORY_HANDLE_DESC.__member(4), CUDA_EXTERNAL_MEMORY_HANDLE_DESC.__union(CUDA_EXTERNAL_MEMORY_HANDLE_DESC.__member(4), CUDA_EXTERNAL_MEMORY_HANDLE_DESC.__struct(CUDA_EXTERNAL_MEMORY_HANDLE_DESC.__member(POINTER_SIZE), CUDA_EXTERNAL_MEMORY_HANDLE_DESC.__member(POINTER_SIZE)), CUDA_EXTERNAL_MEMORY_HANDLE_DESC.__member(POINTER_SIZE)), CUDA_EXTERNAL_MEMORY_HANDLE_DESC.__member(8), CUDA_EXTERNAL_MEMORY_HANDLE_DESC.__member(4), CUDA_EXTERNAL_MEMORY_HANDLE_DESC.__array(4, 16));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        HANDLE = layout.offsetof(1);
        HANDLE_FD = layout.offsetof(2);
        HANDLE_WIN32 = layout.offsetof(3);
        HANDLE_WIN32_HANDLE = layout.offsetof(4);
        HANDLE_WIN32_NAME = layout.offsetof(5);
        HANDLE_NVSCIBUFOBJECT = layout.offsetof(6);
        SIZE = layout.offsetof(7);
        FLAGS = layout.offsetof(8);
        RESERVED = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<CUDA_EXTERNAL_MEMORY_HANDLE_DESC, Buffer>
    implements NativeResource {
        private static final CUDA_EXTERNAL_MEMORY_HANDLE_DESC ELEMENT_FACTORY = CUDA_EXTERNAL_MEMORY_HANDLE_DESC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CUDA_EXTERNAL_MEMORY_HANDLE_DESC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUexternalMemoryHandleType")
        public int type() {
            return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.ntype(this.address());
        }

        public int handle_fd() {
            return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nhandle_fd(this.address());
        }

        @NativeType(value="void *")
        public long handle_win32_handle() {
            return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nhandle_win32_handle(this.address());
        }

        @NativeType(value="void const *")
        public long handle_win32_name() {
            return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nhandle_win32_name(this.address());
        }

        @NativeType(value="void const *")
        public long handle_nvSciBufObject() {
            return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nhandle_nvSciBufObject(this.address());
        }

        @NativeType(value="unsigned long long")
        public long size() {
            return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nsize(this.address());
        }

        @NativeType(value="unsigned int")
        public int flags() {
            return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nflags(this.address());
        }

        @NativeType(value="unsigned int[16]")
        public IntBuffer reserved() {
            return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nreserved(this.address());
        }

        @NativeType(value="unsigned int")
        public int reserved(int index) {
            return CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nreserved(this.address(), index);
        }

        public Buffer type(@NativeType(value="CUexternalMemoryHandleType") int value) {
            CUDA_EXTERNAL_MEMORY_HANDLE_DESC.ntype(this.address(), value);
            return this;
        }

        public Buffer handle_fd(int value) {
            CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nhandle_fd(this.address(), value);
            return this;
        }

        public Buffer handle_win32_handle(@NativeType(value="void *") long value) {
            CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nhandle_win32_handle(this.address(), value);
            return this;
        }

        public Buffer handle_win32_name(@NativeType(value="void const *") long value) {
            CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nhandle_win32_name(this.address(), value);
            return this;
        }

        public Buffer handle_nvSciBufObject(@NativeType(value="void const *") long value) {
            CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nhandle_nvSciBufObject(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="unsigned long long") long value) {
            CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nsize(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="unsigned int") int value) {
            CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nflags(this.address(), value);
            return this;
        }

        public Buffer reserved(@NativeType(value="unsigned int[16]") IntBuffer value) {
            CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nreserved(this.address(), value);
            return this;
        }

        public Buffer reserved(int index, @NativeType(value="unsigned int") int value) {
            CUDA_EXTERNAL_MEMORY_HANDLE_DESC.nreserved(this.address(), index, value);
            return this;
        }
    }
}

