/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_KERNEL_NODE_PARAMS
extends Struct<CUDA_KERNEL_NODE_PARAMS>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FUNC;
    public static final int GRIDDIMX;
    public static final int GRIDDIMY;
    public static final int GRIDDIMZ;
    public static final int BLOCKDIMX;
    public static final int BLOCKDIMY;
    public static final int BLOCKDIMZ;
    public static final int SHAREDMEMBYTES;
    public static final int KERNELPARAMS;
    public static final int EXTRA;

    protected CUDA_KERNEL_NODE_PARAMS(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CUDA_KERNEL_NODE_PARAMS create(long address, @Nullable ByteBuffer container) {
        return new CUDA_KERNEL_NODE_PARAMS(address, container);
    }

    public CUDA_KERNEL_NODE_PARAMS(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUDA_KERNEL_NODE_PARAMS.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUfunction")
    public long func() {
        return CUDA_KERNEL_NODE_PARAMS.nfunc(this.address());
    }

    @NativeType(value="unsigned int")
    public int gridDimX() {
        return CUDA_KERNEL_NODE_PARAMS.ngridDimX(this.address());
    }

    @NativeType(value="unsigned int")
    public int gridDimY() {
        return CUDA_KERNEL_NODE_PARAMS.ngridDimY(this.address());
    }

    @NativeType(value="unsigned int")
    public int gridDimZ() {
        return CUDA_KERNEL_NODE_PARAMS.ngridDimZ(this.address());
    }

    @NativeType(value="unsigned int")
    public int blockDimX() {
        return CUDA_KERNEL_NODE_PARAMS.nblockDimX(this.address());
    }

    @NativeType(value="unsigned int")
    public int blockDimY() {
        return CUDA_KERNEL_NODE_PARAMS.nblockDimY(this.address());
    }

    @NativeType(value="unsigned int")
    public int blockDimZ() {
        return CUDA_KERNEL_NODE_PARAMS.nblockDimZ(this.address());
    }

    @NativeType(value="unsigned int")
    public int sharedMemBytes() {
        return CUDA_KERNEL_NODE_PARAMS.nsharedMemBytes(this.address());
    }

    @NativeType(value="void **")
    public @Nullable PointerBuffer kernelParams(int capacity) {
        return CUDA_KERNEL_NODE_PARAMS.nkernelParams(this.address(), capacity);
    }

    @NativeType(value="void **")
    public @Nullable PointerBuffer extra(int capacity) {
        return CUDA_KERNEL_NODE_PARAMS.nextra(this.address(), capacity);
    }

    public CUDA_KERNEL_NODE_PARAMS func(@NativeType(value="CUfunction") long value) {
        CUDA_KERNEL_NODE_PARAMS.nfunc(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS gridDimX(@NativeType(value="unsigned int") int value) {
        CUDA_KERNEL_NODE_PARAMS.ngridDimX(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS gridDimY(@NativeType(value="unsigned int") int value) {
        CUDA_KERNEL_NODE_PARAMS.ngridDimY(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS gridDimZ(@NativeType(value="unsigned int") int value) {
        CUDA_KERNEL_NODE_PARAMS.ngridDimZ(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS blockDimX(@NativeType(value="unsigned int") int value) {
        CUDA_KERNEL_NODE_PARAMS.nblockDimX(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS blockDimY(@NativeType(value="unsigned int") int value) {
        CUDA_KERNEL_NODE_PARAMS.nblockDimY(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS blockDimZ(@NativeType(value="unsigned int") int value) {
        CUDA_KERNEL_NODE_PARAMS.nblockDimZ(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS sharedMemBytes(@NativeType(value="unsigned int") int value) {
        CUDA_KERNEL_NODE_PARAMS.nsharedMemBytes(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS kernelParams(@NativeType(value="void **") @Nullable PointerBuffer value) {
        CUDA_KERNEL_NODE_PARAMS.nkernelParams(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS extra(@NativeType(value="void **") @Nullable PointerBuffer value) {
        CUDA_KERNEL_NODE_PARAMS.nextra(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS set(long func, int gridDimX, int gridDimY, int gridDimZ, int blockDimX, int blockDimY, int blockDimZ, int sharedMemBytes, @Nullable PointerBuffer kernelParams, @Nullable PointerBuffer extra) {
        this.func(func);
        this.gridDimX(gridDimX);
        this.gridDimY(gridDimY);
        this.gridDimZ(gridDimZ);
        this.blockDimX(blockDimX);
        this.blockDimY(blockDimY);
        this.blockDimZ(blockDimZ);
        this.sharedMemBytes(sharedMemBytes);
        this.kernelParams(kernelParams);
        this.extra(extra);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS set(CUDA_KERNEL_NODE_PARAMS src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUDA_KERNEL_NODE_PARAMS malloc() {
        return new CUDA_KERNEL_NODE_PARAMS(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CUDA_KERNEL_NODE_PARAMS calloc() {
        return new CUDA_KERNEL_NODE_PARAMS(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CUDA_KERNEL_NODE_PARAMS create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CUDA_KERNEL_NODE_PARAMS(MemoryUtil.memAddress(container), container);
    }

    public static CUDA_KERNEL_NODE_PARAMS create(long address) {
        return new CUDA_KERNEL_NODE_PARAMS(address, null);
    }

    public static @Nullable CUDA_KERNEL_NODE_PARAMS createSafe(long address) {
        return address == 0L ? null : new CUDA_KERNEL_NODE_PARAMS(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CUDA_KERNEL_NODE_PARAMS.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_KERNEL_NODE_PARAMS.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CUDA_KERNEL_NODE_PARAMS mallocStack() {
        return CUDA_KERNEL_NODE_PARAMS.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_KERNEL_NODE_PARAMS callocStack() {
        return CUDA_KERNEL_NODE_PARAMS.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_KERNEL_NODE_PARAMS mallocStack(MemoryStack stack) {
        return CUDA_KERNEL_NODE_PARAMS.malloc(stack);
    }

    @Deprecated
    public static CUDA_KERNEL_NODE_PARAMS callocStack(MemoryStack stack) {
        return CUDA_KERNEL_NODE_PARAMS.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CUDA_KERNEL_NODE_PARAMS.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CUDA_KERNEL_NODE_PARAMS.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CUDA_KERNEL_NODE_PARAMS.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CUDA_KERNEL_NODE_PARAMS.calloc(capacity, stack);
    }

    public static CUDA_KERNEL_NODE_PARAMS malloc(MemoryStack stack) {
        return new CUDA_KERNEL_NODE_PARAMS(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUDA_KERNEL_NODE_PARAMS calloc(MemoryStack stack) {
        return new CUDA_KERNEL_NODE_PARAMS(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nfunc(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)FUNC);
    }

    public static int ngridDimX(long struct) {
        return MemoryUtil.memGetInt(struct + (long)GRIDDIMX);
    }

    public static int ngridDimY(long struct) {
        return MemoryUtil.memGetInt(struct + (long)GRIDDIMY);
    }

    public static int ngridDimZ(long struct) {
        return MemoryUtil.memGetInt(struct + (long)GRIDDIMZ);
    }

    public static int nblockDimX(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BLOCKDIMX);
    }

    public static int nblockDimY(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BLOCKDIMY);
    }

    public static int nblockDimZ(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BLOCKDIMZ);
    }

    public static int nsharedMemBytes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHAREDMEMBYTES);
    }

    public static @Nullable PointerBuffer nkernelParams(long struct, int capacity) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)KERNELPARAMS), capacity);
    }

    public static @Nullable PointerBuffer nextra(long struct, int capacity) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)EXTRA), capacity);
    }

    public static void nfunc(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)FUNC, value);
    }

    public static void ngridDimX(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)GRIDDIMX, value);
    }

    public static void ngridDimY(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)GRIDDIMY, value);
    }

    public static void ngridDimZ(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)GRIDDIMZ, value);
    }

    public static void nblockDimX(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BLOCKDIMX, value);
    }

    public static void nblockDimY(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BLOCKDIMY, value);
    }

    public static void nblockDimZ(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BLOCKDIMZ, value);
    }

    public static void nsharedMemBytes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHAREDMEMBYTES, value);
    }

    public static void nkernelParams(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)KERNELPARAMS, MemoryUtil.memAddressSafe(value));
    }

    public static void nextra(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)EXTRA, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = CUDA_KERNEL_NODE_PARAMS.__struct(CUDA_KERNEL_NODE_PARAMS.__member(POINTER_SIZE), CUDA_KERNEL_NODE_PARAMS.__member(4), CUDA_KERNEL_NODE_PARAMS.__member(4), CUDA_KERNEL_NODE_PARAMS.__member(4), CUDA_KERNEL_NODE_PARAMS.__member(4), CUDA_KERNEL_NODE_PARAMS.__member(4), CUDA_KERNEL_NODE_PARAMS.__member(4), CUDA_KERNEL_NODE_PARAMS.__member(4), CUDA_KERNEL_NODE_PARAMS.__member(POINTER_SIZE), CUDA_KERNEL_NODE_PARAMS.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FUNC = layout.offsetof(0);
        GRIDDIMX = layout.offsetof(1);
        GRIDDIMY = layout.offsetof(2);
        GRIDDIMZ = layout.offsetof(3);
        BLOCKDIMX = layout.offsetof(4);
        BLOCKDIMY = layout.offsetof(5);
        BLOCKDIMZ = layout.offsetof(6);
        SHAREDMEMBYTES = layout.offsetof(7);
        KERNELPARAMS = layout.offsetof(8);
        EXTRA = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<CUDA_KERNEL_NODE_PARAMS, Buffer>
    implements NativeResource {
        private static final CUDA_KERNEL_NODE_PARAMS ELEMENT_FACTORY = CUDA_KERNEL_NODE_PARAMS.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CUDA_KERNEL_NODE_PARAMS getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUfunction")
        public long func() {
            return CUDA_KERNEL_NODE_PARAMS.nfunc(this.address());
        }

        @NativeType(value="unsigned int")
        public int gridDimX() {
            return CUDA_KERNEL_NODE_PARAMS.ngridDimX(this.address());
        }

        @NativeType(value="unsigned int")
        public int gridDimY() {
            return CUDA_KERNEL_NODE_PARAMS.ngridDimY(this.address());
        }

        @NativeType(value="unsigned int")
        public int gridDimZ() {
            return CUDA_KERNEL_NODE_PARAMS.ngridDimZ(this.address());
        }

        @NativeType(value="unsigned int")
        public int blockDimX() {
            return CUDA_KERNEL_NODE_PARAMS.nblockDimX(this.address());
        }

        @NativeType(value="unsigned int")
        public int blockDimY() {
            return CUDA_KERNEL_NODE_PARAMS.nblockDimY(this.address());
        }

        @NativeType(value="unsigned int")
        public int blockDimZ() {
            return CUDA_KERNEL_NODE_PARAMS.nblockDimZ(this.address());
        }

        @NativeType(value="unsigned int")
        public int sharedMemBytes() {
            return CUDA_KERNEL_NODE_PARAMS.nsharedMemBytes(this.address());
        }

        @NativeType(value="void **")
        public @Nullable PointerBuffer kernelParams(int capacity) {
            return CUDA_KERNEL_NODE_PARAMS.nkernelParams(this.address(), capacity);
        }

        @NativeType(value="void **")
        public @Nullable PointerBuffer extra(int capacity) {
            return CUDA_KERNEL_NODE_PARAMS.nextra(this.address(), capacity);
        }

        public Buffer func(@NativeType(value="CUfunction") long value) {
            CUDA_KERNEL_NODE_PARAMS.nfunc(this.address(), value);
            return this;
        }

        public Buffer gridDimX(@NativeType(value="unsigned int") int value) {
            CUDA_KERNEL_NODE_PARAMS.ngridDimX(this.address(), value);
            return this;
        }

        public Buffer gridDimY(@NativeType(value="unsigned int") int value) {
            CUDA_KERNEL_NODE_PARAMS.ngridDimY(this.address(), value);
            return this;
        }

        public Buffer gridDimZ(@NativeType(value="unsigned int") int value) {
            CUDA_KERNEL_NODE_PARAMS.ngridDimZ(this.address(), value);
            return this;
        }

        public Buffer blockDimX(@NativeType(value="unsigned int") int value) {
            CUDA_KERNEL_NODE_PARAMS.nblockDimX(this.address(), value);
            return this;
        }

        public Buffer blockDimY(@NativeType(value="unsigned int") int value) {
            CUDA_KERNEL_NODE_PARAMS.nblockDimY(this.address(), value);
            return this;
        }

        public Buffer blockDimZ(@NativeType(value="unsigned int") int value) {
            CUDA_KERNEL_NODE_PARAMS.nblockDimZ(this.address(), value);
            return this;
        }

        public Buffer sharedMemBytes(@NativeType(value="unsigned int") int value) {
            CUDA_KERNEL_NODE_PARAMS.nsharedMemBytes(this.address(), value);
            return this;
        }

        public Buffer kernelParams(@NativeType(value="void **") @Nullable PointerBuffer value) {
            CUDA_KERNEL_NODE_PARAMS.nkernelParams(this.address(), value);
            return this;
        }

        public Buffer extra(@NativeType(value="void **") @Nullable PointerBuffer value) {
            CUDA_KERNEL_NODE_PARAMS.nextra(this.address(), value);
            return this;
        }
    }
}

