/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_MEMSET_NODE_PARAMS_v2
extends Struct<CUDA_MEMSET_NODE_PARAMS_v2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DST;
    public static final int PITCH;
    public static final int VALUE;
    public static final int ELEMENTSIZE;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int CTX;

    protected CUDA_MEMSET_NODE_PARAMS_v2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CUDA_MEMSET_NODE_PARAMS_v2 create(long address, @Nullable ByteBuffer container) {
        return new CUDA_MEMSET_NODE_PARAMS_v2(address, container);
    }

    public CUDA_MEMSET_NODE_PARAMS_v2(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUDA_MEMSET_NODE_PARAMS_v2.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUdeviceptr")
    public long dst() {
        return CUDA_MEMSET_NODE_PARAMS_v2.ndst(this.address());
    }

    @NativeType(value="size_t")
    public long pitch() {
        return CUDA_MEMSET_NODE_PARAMS_v2.npitch(this.address());
    }

    @NativeType(value="unsigned int")
    public int value() {
        return CUDA_MEMSET_NODE_PARAMS_v2.nvalue(this.address());
    }

    @NativeType(value="unsigned int")
    public int elementSize() {
        return CUDA_MEMSET_NODE_PARAMS_v2.nelementSize(this.address());
    }

    @NativeType(value="size_t")
    public long width() {
        return CUDA_MEMSET_NODE_PARAMS_v2.nwidth(this.address());
    }

    @NativeType(value="size_t")
    public long height() {
        return CUDA_MEMSET_NODE_PARAMS_v2.nheight(this.address());
    }

    @NativeType(value="CUcontext")
    public long ctx() {
        return CUDA_MEMSET_NODE_PARAMS_v2.nctx(this.address());
    }

    public CUDA_MEMSET_NODE_PARAMS_v2 dst(@NativeType(value="CUdeviceptr") long value) {
        CUDA_MEMSET_NODE_PARAMS_v2.ndst(this.address(), value);
        return this;
    }

    public CUDA_MEMSET_NODE_PARAMS_v2 pitch(@NativeType(value="size_t") long value) {
        CUDA_MEMSET_NODE_PARAMS_v2.npitch(this.address(), value);
        return this;
    }

    public CUDA_MEMSET_NODE_PARAMS_v2 value(@NativeType(value="unsigned int") int value) {
        CUDA_MEMSET_NODE_PARAMS_v2.nvalue(this.address(), value);
        return this;
    }

    public CUDA_MEMSET_NODE_PARAMS_v2 elementSize(@NativeType(value="unsigned int") int value) {
        CUDA_MEMSET_NODE_PARAMS_v2.nelementSize(this.address(), value);
        return this;
    }

    public CUDA_MEMSET_NODE_PARAMS_v2 width(@NativeType(value="size_t") long value) {
        CUDA_MEMSET_NODE_PARAMS_v2.nwidth(this.address(), value);
        return this;
    }

    public CUDA_MEMSET_NODE_PARAMS_v2 height(@NativeType(value="size_t") long value) {
        CUDA_MEMSET_NODE_PARAMS_v2.nheight(this.address(), value);
        return this;
    }

    public CUDA_MEMSET_NODE_PARAMS_v2 ctx(@NativeType(value="CUcontext") long value) {
        CUDA_MEMSET_NODE_PARAMS_v2.nctx(this.address(), value);
        return this;
    }

    public CUDA_MEMSET_NODE_PARAMS_v2 set(long dst, long pitch, int value, int elementSize, long width, long height, long ctx) {
        this.dst(dst);
        this.pitch(pitch);
        this.value(value);
        this.elementSize(elementSize);
        this.width(width);
        this.height(height);
        this.ctx(ctx);
        return this;
    }

    public CUDA_MEMSET_NODE_PARAMS_v2 set(CUDA_MEMSET_NODE_PARAMS_v2 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUDA_MEMSET_NODE_PARAMS_v2 malloc() {
        return new CUDA_MEMSET_NODE_PARAMS_v2(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CUDA_MEMSET_NODE_PARAMS_v2 calloc() {
        return new CUDA_MEMSET_NODE_PARAMS_v2(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CUDA_MEMSET_NODE_PARAMS_v2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CUDA_MEMSET_NODE_PARAMS_v2(MemoryUtil.memAddress(container), container);
    }

    public static CUDA_MEMSET_NODE_PARAMS_v2 create(long address) {
        return new CUDA_MEMSET_NODE_PARAMS_v2(address, null);
    }

    public static @Nullable CUDA_MEMSET_NODE_PARAMS_v2 createSafe(long address) {
        return address == 0L ? null : new CUDA_MEMSET_NODE_PARAMS_v2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CUDA_MEMSET_NODE_PARAMS_v2.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_MEMSET_NODE_PARAMS_v2.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUDA_MEMSET_NODE_PARAMS_v2 malloc(MemoryStack stack) {
        return new CUDA_MEMSET_NODE_PARAMS_v2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUDA_MEMSET_NODE_PARAMS_v2 calloc(MemoryStack stack) {
        return new CUDA_MEMSET_NODE_PARAMS_v2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ndst(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DST);
    }

    public static long npitch(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PITCH);
    }

    public static int nvalue(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VALUE);
    }

    public static int nelementSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ELEMENTSIZE);
    }

    public static long nwidth(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)WIDTH);
    }

    public static long nheight(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HEIGHT);
    }

    public static long nctx(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CTX);
    }

    public static void ndst(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DST, Checks.check(value));
    }

    public static void npitch(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PITCH, value);
    }

    public static void nvalue(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VALUE, value);
    }

    public static void nelementSize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ELEMENTSIZE, value);
    }

    public static void nwidth(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HEIGHT, value);
    }

    public static void nctx(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)CTX, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DST));
    }

    static {
        Struct.Layout layout = CUDA_MEMSET_NODE_PARAMS_v2.__struct(CUDA_MEMSET_NODE_PARAMS_v2.__member(POINTER_SIZE), CUDA_MEMSET_NODE_PARAMS_v2.__member(POINTER_SIZE), CUDA_MEMSET_NODE_PARAMS_v2.__member(4), CUDA_MEMSET_NODE_PARAMS_v2.__member(4), CUDA_MEMSET_NODE_PARAMS_v2.__member(POINTER_SIZE), CUDA_MEMSET_NODE_PARAMS_v2.__member(POINTER_SIZE), CUDA_MEMSET_NODE_PARAMS_v2.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DST = layout.offsetof(0);
        PITCH = layout.offsetof(1);
        VALUE = layout.offsetof(2);
        ELEMENTSIZE = layout.offsetof(3);
        WIDTH = layout.offsetof(4);
        HEIGHT = layout.offsetof(5);
        CTX = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<CUDA_MEMSET_NODE_PARAMS_v2, Buffer>
    implements NativeResource {
        private static final CUDA_MEMSET_NODE_PARAMS_v2 ELEMENT_FACTORY = CUDA_MEMSET_NODE_PARAMS_v2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CUDA_MEMSET_NODE_PARAMS_v2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUdeviceptr")
        public long dst() {
            return CUDA_MEMSET_NODE_PARAMS_v2.ndst(this.address());
        }

        @NativeType(value="size_t")
        public long pitch() {
            return CUDA_MEMSET_NODE_PARAMS_v2.npitch(this.address());
        }

        @NativeType(value="unsigned int")
        public int value() {
            return CUDA_MEMSET_NODE_PARAMS_v2.nvalue(this.address());
        }

        @NativeType(value="unsigned int")
        public int elementSize() {
            return CUDA_MEMSET_NODE_PARAMS_v2.nelementSize(this.address());
        }

        @NativeType(value="size_t")
        public long width() {
            return CUDA_MEMSET_NODE_PARAMS_v2.nwidth(this.address());
        }

        @NativeType(value="size_t")
        public long height() {
            return CUDA_MEMSET_NODE_PARAMS_v2.nheight(this.address());
        }

        @NativeType(value="CUcontext")
        public long ctx() {
            return CUDA_MEMSET_NODE_PARAMS_v2.nctx(this.address());
        }

        public Buffer dst(@NativeType(value="CUdeviceptr") long value) {
            CUDA_MEMSET_NODE_PARAMS_v2.ndst(this.address(), value);
            return this;
        }

        public Buffer pitch(@NativeType(value="size_t") long value) {
            CUDA_MEMSET_NODE_PARAMS_v2.npitch(this.address(), value);
            return this;
        }

        public Buffer value(@NativeType(value="unsigned int") int value) {
            CUDA_MEMSET_NODE_PARAMS_v2.nvalue(this.address(), value);
            return this;
        }

        public Buffer elementSize(@NativeType(value="unsigned int") int value) {
            CUDA_MEMSET_NODE_PARAMS_v2.nelementSize(this.address(), value);
            return this;
        }

        public Buffer width(@NativeType(value="size_t") long value) {
            CUDA_MEMSET_NODE_PARAMS_v2.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(@NativeType(value="size_t") long value) {
            CUDA_MEMSET_NODE_PARAMS_v2.nheight(this.address(), value);
            return this;
        }

        public Buffer ctx(@NativeType(value="CUcontext") long value) {
            CUDA_MEMSET_NODE_PARAMS_v2.nctx(this.address(), value);
            return this;
        }
    }
}

